/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.Searchable;
import com.jidesoft.swing.SearchableProvider;
import com.jidesoft.swing.event.SearchableEvent;
import java.awt.Component;
import java.awt.IllegalComponentStateException;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class ComboBoxSearchable
extends Searchable
implements ListDataListener,
PropertyChangeListener,
PopupMenuListener {
    private boolean _refreshPopupDuringSearching = false;
    private boolean _showPopupDuringSearching = true;

    public ComboBoxSearchable(final JComboBox jComboBox) {
        super(jComboBox);
        jComboBox.setKeySelectionManager(new JComboBox.KeySelectionManager(){

            public int selectionForKey(char c2, ComboBoxModel comboBoxModel) {
                return -1;
            }
        });
        jComboBox.getModel().addListDataListener(this);
        jComboBox.addPropertyChangeListener("model", this);
        jComboBox.addPopupMenuListener(this);
        if (jComboBox.isEditable()) {
            Component component = jComboBox.getEditor().getEditorComponent();
            final JTextField jTextField = (JTextField)component;
            jTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                    if (keyEvent.getKeyChar() != '\uffff' && keyEvent.getKeyCode() != 10 && keyEvent.getKeyCode() != 27) {
                        String string = jTextField.getText();
                        ComboBoxModel comboBoxModel = jComboBox.getModel();
                        ListDataListener listDataListener = null;
                        if (comboBoxModel instanceof AbstractListModel) {
                            ListDataListener[] listDataListenerArray;
                            for (ListDataListener listDataListener2 : listDataListenerArray = ((AbstractListModel)((Object)comboBoxModel)).getListDataListeners()) {
                                if (listDataListener2.getClass().toString().indexOf("BasicComboBoxUI") == -1) continue;
                                listDataListener = listDataListener2;
                                comboBoxModel.removeListDataListener(listDataListener2);
                            }
                        }
                        ComboBoxSearchable.this.textChanged(string);
                        if (ComboBoxSearchable.this.isShowPopupDuringSearching()) {
                            if (!jComboBox.getUI().getClass().getName().contains("ExComboBoxUI")) {
                                jComboBox.hidePopup();
                            }
                            jComboBox.showPopup();
                        }
                        if (listDataListener != null) {
                            comboBoxModel.addListDataListener(listDataListener);
                        }
                    }
                }
            });
            this.setSearchableProvider(new SearchableProvider(){

                @Override
                public String getSearchingText() {
                    return jTextField.getText();
                }

                @Override
                public boolean isPassive() {
                    return true;
                }

                @Override
                public void processKeyEvent(KeyEvent keyEvent) {
                }
            });
        }
    }

    @Override
    public void uninstallListeners() {
        super.uninstallListeners();
        if (this._component instanceof JComboBox) {
            ((JComboBox)this._component).getModel().removeListDataListener(this);
            ((JComboBox)this._component).removePopupMenuListener(this);
        }
        this._component.removePropertyChangeListener("model", this);
    }

    public boolean isShowPopupDuringSearching() {
        return this._showPopupDuringSearching;
    }

    public void setShowPopupDuringSearching(boolean bl2) {
        this._showPopupDuringSearching = bl2;
    }

    public boolean isRefreshPopupDuringSearching() {
        return this._refreshPopupDuringSearching;
    }

    public void setRefreshPopupDuringSearching(boolean bl2) {
        this._refreshPopupDuringSearching = bl2;
    }

    @Override
    protected void setSelectedIndex(int n2, boolean bl2) {
        JComboBox jComboBox = (JComboBox)this._component;
        if (jComboBox.getSelectedIndex() != n2) {
            try {
                jComboBox.setSelectedIndex(n2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.isShowPopupDuringSearching() || this.isRefreshPopupDuringSearching()) {
            if (this._component.getClientProperty("ShrinkSearchableSupport") != null && jComboBox.isPopupVisible()) {
                boolean bl3 = this.isHideSearchPopupOnEvent();
                this.setHideSearchPopupOnEvent(false);
                jComboBox.hidePopup();
                this.setHideSearchPopupOnEvent(bl3);
            }
            try {
                if (!jComboBox.isPopupVisible() && KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner() != null && SwingUtilities.isDescendingFrom(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner(), this._component)) {
                    jComboBox.showPopup();
                }
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                // empty catch block
            }
        }
    }

    @Override
    protected int getSelectedIndex() {
        return ((JComboBox)this._component).getSelectedIndex();
    }

    @Override
    protected Object getElementAt(int n2) {
        ComboBoxModel comboBoxModel = ((JComboBox)this._component).getModel();
        return comboBoxModel.getElementAt(n2);
    }

    @Override
    protected int getElementCount() {
        ComboBoxModel comboBoxModel = ((JComboBox)this._component).getModel();
        return comboBoxModel.getSize();
    }

    @Override
    protected String convertElementToString(Object object) {
        if (object != null) {
            return object.toString();
        }
        return "";
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        if (!this.isProcessModelChangeEvent()) {
            return;
        }
        if (listDataEvent.getIndex0() != -1 || listDataEvent.getIndex1() != -1) {
            this.hidePopup();
            this.fireSearchableEvent(new SearchableEvent(this, 3005));
        }
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        if (!this.isProcessModelChangeEvent()) {
            return;
        }
        this.hidePopup();
        this.fireSearchableEvent(new SearchableEvent(this, 3005));
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        if (!this.isProcessModelChangeEvent()) {
            return;
        }
        this.hidePopup();
        this.fireSearchableEvent(new SearchableEvent(this, 3005));
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("model".equals(propertyChangeEvent.getPropertyName())) {
            this.hidePopup();
            if (propertyChangeEvent.getOldValue() instanceof ComboBoxModel) {
                ((ComboBoxModel)propertyChangeEvent.getOldValue()).removeListDataListener(this);
            }
            if (propertyChangeEvent.getNewValue() instanceof ComboBoxModel) {
                ((ComboBoxModel)propertyChangeEvent.getNewValue()).addListDataListener(this);
            }
            this.fireSearchableEvent(new SearchableEvent(this, 3005));
        }
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        if (this.isHideSearchPopupOnEvent()) {
            this.hidePopup();
        }
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
    }
}

