/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.aws.lw.client.xml.builder;

import com.github.davidmoten.aws.lw.client.internal.util.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class Xml {
    private final String name;
    private final Xml parent;
    private Map<String, String> attributes = new HashMap<String, String>();
    private List<Xml> children = new ArrayList<Xml>();
    private String content;
    private boolean prelude = true;
    private static final Map<Integer, String> CONTENT_CHARACTER_MAP = Xml.createContentCharacterMap();
    private static final Map<Integer, String> ATTRIBUTE_CHARACTER_MAP = Xml.createAttributeCharacterMap();

    private Xml(String name) {
        this(name, null);
    }

    private Xml(String name, Xml parent) {
        Xml.checkPresent(name, "name");
        this.name = name;
        this.parent = parent;
    }

    public static Xml create(String name) {
        return new Xml(name);
    }

    public Xml excludePrelude() {
        Xml xml = this;
        while (xml.parent != null) {
            xml = xml.parent;
        }
        xml.prelude = false;
        return this;
    }

    public Xml element(String name) {
        Xml.checkPresent(name, "name");
        Preconditions.checkArgument(this.content == null, "content cannot be already specified if starting a child element");
        Xml xml = new Xml(name, this);
        this.children.add(xml);
        return xml;
    }

    public Xml e(String name) {
        return this.element(name);
    }

    public Xml attribute(String name, String value) {
        Xml.checkPresent(name, "name");
        Preconditions.checkNotNull(value);
        this.attributes.put(name, value);
        return this;
    }

    public Xml a(String name, String value) {
        return this.attribute(name, value);
    }

    public Xml content(String content) {
        Preconditions.checkArgument(this.children.isEmpty());
        this.content = content;
        return this;
    }

    public Xml up() {
        return this.parent;
    }

    private static void checkPresent(String s, String name) {
        if (s == null || s.trim().isEmpty()) {
            throw new IllegalArgumentException(name + " must be non-null and non-blank");
        }
    }

    private String toString(String indent) {
        StringBuilder b = new StringBuilder();
        if (indent.length() == 0 && this.prelude) {
            b.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        }
        String atts = this.attributes.entrySet().stream().map(entry -> " " + (String)entry.getKey() + "=\"" + Xml.encodeXml((CharSequence)entry.getValue(), true) + "\"").collect(Collectors.joining());
        b.append(String.format("%s<%s%s>", indent, this.name, atts));
        if (this.content != null) {
            b.append(Xml.encodeXml(this.content, false));
            b.append(String.format("</%s>", this.name));
            if (this.parent != null) {
                b.append("\n");
            }
        } else {
            b.append("\n");
            for (Xml xml : this.children) {
                b.append(xml.toString(indent + "  "));
            }
            b.append(String.format("%s</%s>", indent, this.name));
            if (this.parent != null) {
                b.append("\n");
            }
        }
        return b.toString();
    }

    public String toString() {
        Xml xml = this;
        while (xml.parent != null) {
            xml = xml.parent;
        }
        return xml.toString("");
    }

    private static Map<Integer, String> createContentCharacterMap() {
        HashMap<Integer, String> m = new HashMap<Integer, String>();
        m.put(38, "&amp;");
        m.put(62, "&gt;");
        m.put(60, "&lt;");
        return m;
    }

    private static Map<Integer, String> createAttributeCharacterMap() {
        HashMap<Integer, String> m = new HashMap<Integer, String>();
        m.put(39, "&apos;");
        m.put(34, "&quot;");
        return m;
    }

    private static String encodeXml(CharSequence s, boolean isAttribute) {
        StringBuilder b = new StringBuilder();
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            int c = s.charAt(i);
            if (c >= 55296 && c <= 56319 && i + 1 < len) {
                c = c - 55232 << 10 | s.charAt(++i) & 0x3FF;
            }
            if (c < 128) {
                if (c < 32 && c != 9 && c != 13 && c != 10) {
                    b.append("&#xfffd;");
                    continue;
                }
                String r = CONTENT_CHARACTER_MAP.get(c);
                if (r != null) {
                    b.append(r);
                    continue;
                }
                if (isAttribute) {
                    String r2 = ATTRIBUTE_CHARACTER_MAP.get(c);
                    if (r2 != null) {
                        b.append(r2);
                        continue;
                    }
                    b.append((char)c);
                    continue;
                }
                b.append((char)c);
                continue;
            }
            if (c >= 55296 && c <= 57343 || c == 65534 || c == 65535) {
                b.append("&#xfffd;");
                continue;
            }
            b.append("&#x");
            b.append(Integer.toHexString(c));
            b.append(';');
        }
        return b.toString();
    }
}

