/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.registry;

import com.install4j.api.Util;
import com.install4j.api.windows.RegistryRoot;
import com.install4j.api.windows.RegistryView;
import com.install4j.api.windows.WinRegistry;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.registry.RegistryInterface;
import java.util.Arrays;
import java.util.List;

public class Win32Registry
implements RegistryInterface {
    private static final String REGKEY_INSTALLATIONS = "SOFTWARE\\ej-technologies\\install4j\\installations";

    @Override
    public void setValue(String name, String val) {
        WinRegistry.createKey(RegistryRoot.HKEY_LOCAL_MACHINE, REGKEY_INSTALLATIONS);
        WinRegistry.setValue(RegistryRoot.HKEY_LOCAL_MACHINE, REGKEY_INSTALLATIONS, name, val);
        WinRegistry.createKey(RegistryRoot.HKEY_CURRENT_USER, REGKEY_INSTALLATIONS);
        WinRegistry.setValue(RegistryRoot.HKEY_CURRENT_USER, REGKEY_INSTALLATIONS, name, val);
    }

    @Override
    public void deleteValue(String valueName) {
        WinRegistry.deleteValue(RegistryRoot.HKEY_LOCAL_MACHINE, REGKEY_INSTALLATIONS, valueName);
        WinRegistry.deleteValue(RegistryRoot.HKEY_CURRENT_USER, REGKEY_INSTALLATIONS, valueName);
    }

    @Override
    public String getValue(String valueName, boolean preferAllUsers) {
        List<RegistryRoot> roots = preferAllUsers ? Arrays.asList(RegistryRoot.HKEY_LOCAL_MACHINE, RegistryRoot.HKEY_CURRENT_USER) : Arrays.asList(RegistryRoot.HKEY_CURRENT_USER, RegistryRoot.HKEY_LOCAL_MACHINE);
        for (RegistryRoot root : roots) {
            Object ret = WinRegistry.getValue(root, REGKEY_INSTALLATIONS, valueName);
            if (!(ret instanceof String)) continue;
            return (String)ret;
        }
        return null;
    }

    @Override
    public String getOtherBitnessValue(String valueName) {
        RegistryView otherView;
        Object ret;
        if (Util.is64BitWindows() && (ret = WinRegistry.getValue(RegistryRoot.HKEY_LOCAL_MACHINE, REGKEY_INSTALLATIONS, valueName, otherView = InstallerUtil.is32BitJVM() ? RegistryView.BIT64 : RegistryView.BIT32)) instanceof String) {
            return (String)ret;
        }
        return null;
    }
}

