/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.files;

import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.SystemInstallOrUninstallAction;
import com.install4j.runtime.beans.actions.files.BackupFileForRollbackAction;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

public class CreateSymlinkAction
extends SystemInstallOrUninstallAction {
    private File file;
    private File linkFile;
    private boolean removeOnUninstall = true;
    private boolean executeOnWindows = false;

    public File getFile() {
        return this.replaceWithTextOverride("file", CreateSymlinkAction.replaceVariables(this.file), File.class);
    }

    public void setFile(File file) {
        this.file = file;
    }

    public File getLinkFile() {
        return this.replaceWithTextOverride("linkFile", CreateSymlinkAction.replaceVariables(this.linkFile), File.class);
    }

    public void setLinkFile(File linkFile) {
        this.linkFile = linkFile;
    }

    public boolean isExecuteOnWindows() {
        return this.replaceWithTextOverride("executeOnWindows", this.executeOnWindows);
    }

    public void setExecuteOnWindows(boolean executeOnWindows) {
        this.executeOnWindows = executeOnWindows;
    }

    public boolean isRemoveOnUninstall() {
        return this.replaceWithTextOverride("removeOnUninstall", this.removeOnUninstall);
    }

    public void setRemoveOnUninstall(boolean removeOnUninstall) {
        this.removeOnUninstall = removeOnUninstall;
    }

    @Override
    public boolean execute(Context context) throws UserCanceledException {
        if (InstallerUtil.isWindows() && !this.isExecuteOnWindows()) {
            return true;
        }
        File usedFile = context.getDestinationFile(this.getFile());
        if (usedFile == null || !usedFile.exists()) {
            return false;
        }
        File usedLinkFile = context.getDestinationFile(this.getLinkFile());
        if (usedLinkFile == null) {
            return false;
        }
        if (context instanceof InstallerContext) {
            BackupFileForRollbackAction backupAction = new BackupFileForRollbackAction(usedLinkFile, true, true);
            backupAction.install((InstallerContext)context);
            this.addRollbackAction(backupAction);
        }
        if (this.isRemoveOnUninstall()) {
            FileInstaller.getInstance().registerUninstallFile(usedLinkFile);
        }
        return CreateSymlinkAction.createLink(usedFile.getAbsolutePath(), usedLinkFile);
    }

    public static boolean createLink(String destFileName, File linkFile) {
        linkFile.delete();
        try {
            Files.createSymbolicLink(linkFile.toPath(), Paths.get(destFileName, new String[0]), new FileAttribute[0]);
            return true;
        }
        catch (Throwable e) {
            Logger.getInstance().log(null, "could not create symbolic link: " + e.getMessage(), false);
            return false;
        }
    }
}

