package com.install4j.api.windows;

import com.install4j.runtime.installer.platform.win32.Win32UserInfo;

/**
 * Enumeration class for the different elevation states the current process can be in.

 * @author ej-technologies GmbH
 */
public enum ElevationState {

    /**
     * All processes on a system with a Windows version previous to Vista.
     */
    ELEVATION_STATE_NOT_APPLICABLE(Win32UserInfo.ELEVATION_TYPE_NOT_APPLICABLE),

    /**
     * The current process is not limited and not elevated on Vista or higher. This can be a process of a non-admin user or of an admin user when UAC is turned off.
     * You can differentiate between those two with {@link com.install4j.api.Util#hasFullAdminRights()}.
     */
    ELEVATION_STATE_DEFAULT(Win32UserInfo.ELEVATION_TYPE_DEFAULT),

    /**
     * The current process runs with limited rights. UAC is turned on.
     */
    ELEVATION_STATE_LIMITED(Win32UserInfo.ELEVATION_TYPE_LIMITED),

    /**
     * The current process was elevated and runs with full rights. UAC is turned on.
     */
    ELEVATION_STATE_FULL(Win32UserInfo.ELEVATION_TYPE_FULL);

    private final int intValue;

    ElevationState(int intValue) {
        this.intValue = intValue;
    }

    static ElevationState getFromIntValue(int intValue) {
        for (ElevationState elevationState : values()) {
            if (elevationState.intValue == intValue) {
                return elevationState;
            }
        }
        return null;
    }

    @Override
    public String toString() {
        return "ElevationState{" +
                "intValue=" + intValue +
                '}';
    }
}