package com.install4j.api.update;

import com.install4j.runtime.installer.helper.apiimpl.UpdateScheduleRegistryImpl;

import java.util.Date;

/**
 * Administrates an update schedule for your application. This class is intended to be called by
 * your application. You have to call {@link #setUpdateSchedule(UpdateSchedule)}} at some point and
 * then call {@link #checkAndReset()} each time you start up your application (or whenever it is convenient)
 * to find out if you should check for an update. Note that no updater is started automatically, you have to
 * start a suitable updater with the {@link com.install4j.api.launcher.ApplicationLauncher} class.
 *
 * @author ej-technologies GmbH
 */
public class UpdateScheduleRegistry {

    private UpdateScheduleRegistry() {
    }

    /**
     * Checks if you should check for an update. If the configured update schedule and the last
     * time you checked for an update require a new check, this method returns true and sets the
     * time for the last update check to the current time.
     * @return if you should start an updater with the {@link com.install4j.api.launcher.ApplicationLauncher} class
     */
    public static boolean checkAndReset() {
        return UpdateScheduleRegistryImpl.checkAndReset();
    }

    /**
     * Sets the new update schedule.
     * @param updateSchedule the update schedule
     */
    public static void setUpdateSchedule(UpdateSchedule updateSchedule) {
        UpdateScheduleRegistryImpl.setUpdateSchedule(updateSchedule);
    }

    /**
     * Returns the configured update schedule.
     * @return the update schedule or {@code null} if no update schedule has been configured so far
     */
    public static UpdateSchedule getUpdateSchedule() {
        return UpdateScheduleRegistryImpl.getUpdateSchedule();
    }

    /**
     * Returns the date you last called {@link #checkAndReset()} and got a return value of {@code true}.
     * @return the last update check date
     */
    public static Date getLastUpdateCheckDate() {
        return UpdateScheduleRegistryImpl.getLastUpdateCheckDate();
    }

    /**
     * Tells the registry that the current time should be set as the last update check date. Usually,
     * you do not need to call this method since {@link #checkAndReset()} sets it automatically if required.
     */
    public static void checkedForUpdate() {
        UpdateScheduleRegistryImpl.checkedForUpdate();
    }

}
