package com.install4j.api.styles;

import com.install4j.api.formcomponents.FormComponent;

/**
 * Implemented by objects that handle screen style context changes. All {@link Style} instances implement this interface,
 * but {@link FormComponent}s can also implement it if they are used in styles and want to react to screen style context
 * changes. For example, you could implement it in a special form component that shows the screen title.
 *
 * @author ej-technologies GmbH
 */
public interface StyleContextReceiver {
    /**
     * Called by the framework when the current screen changes. This method is called before {@link Style#createComponent()}
     * where the {@link StyleContext} may be required for constructing the screen style component.
     * <p>
     * You have to delegate this method call to any nested styles, see {@link NestedStyleContainer} for more information.
     * </p>
     *
     * @param styleContext the screen style context
     */
    void setStyleContext(StyleContext styleContext);
}
