package com.install4j.api.screens;

import com.install4j.api.formcomponents.FormEnvironment;

import javax.swing.*;

/**
 * Any screen can have a form panel, just like the "Additional confirmations" screen or the "Configurable form" screen.
 * In the install4j GUI, the user can configure form components for screens that implement this interface.
 * The framework will then pass a form panel to the screen by calling  {@code setFormPanel}.
 */
public interface FormPanelContainer {

    /**
     * This method is called by the framework to pass the form panel to this screen.
     * It is your responsibility to display the form panel somewhere on this screen. For console mode, you have to
     * call {@code formEnvironment.handleConsole(console)} at some point in the {@code handleConsole} method
     * of this screen.
     * @param panel the form panel
     * @param formEnvironment the form environment
     */
    void setFormPanel(JPanel panel, FormEnvironment formEnvironment);

    /**
     * Determine if the form panel should be wrapped in a scroll pane. This influences the behavior of form components
     * which can grow vertically, such as the text area form component. If no scroll panel is added, those components
     * can claim the remaining vertical space in the form panel.
     * @return whether a scroll panel should be used for the form panel or not
     */
    boolean isScrollFormPanel();

    /**
     * Returns the form environment that was set with {@link #setFormPanel(JPanel, FormEnvironment)} .
     * This is useful for making changes on a form screen in scripts from another screen or action.
     * @return the form environment
     */
    FormEnvironment getFormEnvironment();
}
