package com.install4j.api.laf;

import com.install4j.api.UiUtil;

/**
 * A look and feel handler can apply a look and feel.
 * An implementation of this class together with its dependencies
 * can be added on the "Installer-&gt;Custom Code &amp; Resources" step and can then be
 * configured on the "Installer-&gt;Look &amp; Feel" step.
 * <p>
 * The super-interface {@link LookAndFeelEnhancer} contains a number of methods with
 * default implementations that can be overridden in order to customize certain aspects
 * of creating the UI.
 * </p>
 */
public interface LookAndFeelHandler extends LookAndFeelEnhancer {

    /**
     * Called when the installer application is ready to apply the look and feel.
     *
     * @param darkDesktop if the desktop is detected to be in dark mode. This auto-detection
     *                    is implemented for Windows 10 and macOS.
     */
    void applyLookAndFeel(boolean darkDesktop) throws Exception;

    /**
     * Switch between dark and light mode.
     * This method will be called when user code invokes {@link UiUtil#setDarkUi(boolean)},
     * that method will also update the component hierarchy in all windows.
     * <p>
     * By default, this method throws an {@code UnsupportedOperationException}.
     * If it is implemented, {@link #isDarkModeSwitchingSupported()} must be
     * overridden to return {@code true}.
     * </p>
     * @param dark {@code true} for dark mode
     * @see UiUtil#setDarkUi(boolean)
     */
    default void setDark(boolean dark) {
        throw new UnsupportedOperationException();
    }

}
