package com.install4j.api.formcomponents;

import java.util.List;

/**
 * Represents a layout group for form components. Instances of this interface
 * are contained in the list that is returned by {@link FormEnvironment#getFormComponentTree()}.
 */
public interface LayoutGroup {
    /**
     * Returns the type of the layout group
     * @return the type
     */
    GroupType getGroupType();

    /**
     * Sets whether contained form components are enabled or not. See
     * {@link FormComponent#setEnabled(boolean)} for more information.
     * All descendant form components are affected.
     * @param enabled whether to enable the descendant form components or not
     */
    void setEnabled(boolean enabled);

    /**
     * Sets whether the layout group is visible or not.
     * <p>
     * There is no corresponding {@code isVisible} method, because the state of the contained
     * form components may be mixed.
     * @param visible whether this layout group should be visible or not
     * @see FormComponent#setVisible(boolean)
     * @see #isVisible
     */
    void setVisible(boolean visible);

    /**
     * Returns whether the layout group is visible or not.
     * @return {@code true} or {@code false}.
     * @see #setVisible(boolean)
     */
    boolean isVisible();

    /**
     * Get the ID that the framework associates with this layout group.
     * You can get layout groups by ID with {@link FormEnvironment#getLayoutGroupById(String)}.
     * @return the ID
     */
    String getId();

    /**
     * Get the children of this layout group. The returned list has contents of
     * the same form as {@link FormEnvironment#getFormComponentTree()}.
     * @return a list with the next level of form components and layout groups that
     *         are children of this layout group
     */
    List<?> getChildren();
}
