package com.install4j.api.context;

import java.io.File;

/**
 * Provides information about a file in the distribution tree. Objects of this type are returned by
 * {@link Context#getDestinationFileInfo(String)}. Also, the "File filter" and "Directory resolver" handlers of the
 * "Install files" action offer a parameter of this type. In those handlers, this class is useful to filter or divert
 * an entire installation root.
 * @author ej-technologies GmbH
 */
public interface FileInfo {

    /**
     * Get the actual installation location of the file.
     * @return the installation location
     */
    File getDestinationFile();

    /**
     * Get the unresolved installation root for the file. "Unresolved" means that no installer variables have been replaced.
     * @return the unresolved root or  {@code null} for the installation directory.
     */
    String getRootUnresolved();

    /**
     * Get the resolved installation root for the file. "Resolved" means that all installer variables have been replaced.
     * @return the resolved root
     */
    File getRootResolved();

    /**
     * Get the relative path of the file in the distribution tree without the installation root.
     * @return the relative path
     */
    String getRelativeFilePath();

    /**
     * Get the id of the fileset or a zero-length string for the default fileset.
     * @return the fileset id
     */
    String getFilesetId();

    /**
     * Get the name of the fileset, a zero-length string for the default fileset, or {@code null} if the fileset is non-existent.
     * @return the fileset name
     */
    String getFilesetName();
}
