/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.formcomponents;

import com.install4j.api.Util;
import com.install4j.api.beans.ScriptProperty;
import com.install4j.api.formcomponents.FormEnvironment;
import com.install4j.runtime.beans.formcomponents.LeadingLabelComponent;
import com.install4j.runtime.beans.widgets.TextComponentWidgetStyle;
import com.install4j.runtime.installer.helper.Logger;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class SpinnerComponent
extends LeadingLabelComponent
implements ChangeListener {
    private String variableName = "";
    private JSpinner spinner;
    private ScriptProperty valueChangedScript;
    private String widgetStyleId = "";
    private TextComponentWidgetStyle widgetStyle = new TextComponentWidgetStyle();

    public String getVariableName() {
        return SpinnerComponent.replaceVariables(this.variableName);
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public ScriptProperty getValueChangedScript() {
        return this.replaceWithTextOverride("valueChangedScript", this.valueChangedScript, ScriptProperty.class);
    }

    public void setValueChangedScript(ScriptProperty valueChangedScript) {
        this.valueChangedScript = valueChangedScript;
    }

    public String getWidgetStyleId() {
        return SpinnerComponent.replaceVariables(this.widgetStyleId);
    }

    public void setWidgetStyleId(String widgetStyleId) {
        this.widgetStyleId = widgetStyleId;
    }

    public TextComponentWidgetStyle getWidgetStyle() {
        return this.replaceWithTextOverride("widgetStyle", this.widgetStyle, TextComponentWidgetStyle.class);
    }

    public void setWidgetStyle(TextComponentWidgetStyle widgetStyle) {
        this.widgetStyle = widgetStyle;
    }

    @Override
    public void setFormEnvironment(FormEnvironment formEnvironment) {
        super.setFormEnvironment(formEnvironment);
        if (this.spinner != null && formEnvironment != null) {
            this.spinner.setName(formEnvironment.getId(this));
        }
    }

    @Override
    public JComponent createCenterComponent() {
        this.spinner = new JSpinner(this.createSpinnerModel());
        this.adjustEditor(this.spinner);
        this.spinner.setAlignmentX(0.0f);
        this.getWidgetStyleHandler().applyWidgetStyle(this.spinner, this.getWidgetStyleId(), this.getWidgetStyle());
        return this.spinner;
    }

    protected void adjustEditor(JSpinner spinner) {
    }

    @Override
    public void initialize() {
        this.spinner.removeChangeListener(this);
        super.initialize();
        this.initValue(this.spinner.getModel());
        this.spinner.addChangeListener(this);
        this.valueChanged();
    }

    protected abstract void initValue(SpinnerModel var1);

    protected JSpinner getSpinner() {
        return this.spinner;
    }

    protected abstract SpinnerModel createSpinnerModel();

    @Override
    public boolean isFillCenterHorizontal() {
        return false;
    }

    @Override
    public Object getConfigurationObject() {
        return this.spinner;
    }

    @Override
    public Class<?> getConfigurationObjectClass() {
        return JSpinner.class;
    }

    @Override
    public boolean checkCompleted() {
        this.getContext().setVariable(this.getVariableName(), this.spinner.getValue());
        this.getContext().registerResponseFileVariable(this.getVariableName());
        return true;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.valueChanged();
    }

    private void valueChanged() {
        if (this.getValueChangedScript() != null) {
            try {
                this.getContext().runScript(this.getValueChangedScript(), this, this.getFormEnvironment(), this.spinner.getValue());
            }
            catch (Exception e) {
                Util.printAnnotatedStackTrace(e);
                Logger.getInstance().log(e);
            }
        }
    }
}

