/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.utils;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;

public class ThreadCheckingRepaintManager
extends RepaintManager {
    private boolean completeCheck = true;
    private boolean checkIsShowing = false;

    public ThreadCheckingRepaintManager() {
    }

    public ThreadCheckingRepaintManager(boolean bl2) {
        this.checkIsShowing = bl2;
    }

    public boolean isCompleteCheck() {
        return this.completeCheck;
    }

    public void setCompleteCheck(boolean bl2) {
        this.completeCheck = bl2;
    }

    @Override
    public synchronized void addInvalidComponent(JComponent jComponent) {
        this.checkThreadViolations(jComponent);
        super.addInvalidComponent(jComponent);
    }

    @Override
    public synchronized void addDirtyRegion(JComponent jComponent, int n2, int n3, int n4, int n5) {
        this.checkThreadViolations(jComponent);
        super.addDirtyRegion(jComponent, n2, n3, n4, n5);
    }

    private void checkThreadViolations(JComponent jComponent) {
        if (!SwingUtilities.isEventDispatchThread() && (this.completeCheck || this.checkIsShowing(jComponent))) {
            StackTraceElement[] stackTraceElementArray;
            Exception exception = new Exception();
            boolean bl2 = false;
            boolean bl3 = false;
            for (StackTraceElement stackTraceElement : stackTraceElementArray = exception.getStackTrace()) {
                if (bl2 && stackTraceElement.getClassName().startsWith("javax.swing.")) {
                    bl3 = true;
                }
                if (!"repaint".equals(stackTraceElement.getMethodName())) continue;
                bl2 = true;
            }
            if (bl2 && !bl3) {
                return;
            }
            System.out.println("----------Wrong Thread START");
            System.out.println(this.getStrackTraceAsString(exception));
            System.out.println("----------Wrong Thread END");
        }
    }

    private boolean checkIsShowing(JComponent jComponent) {
        if (this.checkIsShowing) {
            return jComponent.isShowing();
        }
        return true;
    }

    private String getStrackTraceAsString(Exception exception) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        exception.printStackTrace(printStream);
        printStream.flush();
        return byteArrayOutputStream.toString();
    }
}

