/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.a03;

import a03.swing.plaf.A03ListUI;
import com.jidesoft.list.GroupList;
import com.jidesoft.list.GroupListModel;
import com.jidesoft.plaf.basic.LazyActionMap;
import com.jidesoft.plaf.basic.UIAction;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListSelectionModel;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicListUI;

public class A03GroupListUI
extends A03ListUI {
    private int listHeight;
    private int listWidth;
    protected Map<Integer, Rectangle> _headerBounds;
    private int layoutOrientation;
    private int columnCount;
    private boolean isLeftToRight = true;
    private Dimension _preferredSize;
    private List<RowInfo> _rowInfos;
    private List<GroupInfo> _groupInfos;
    private int _columnIndex;
    private boolean _ignoreResetColumnIndex;
    private static final int layoutOrientationChanged = 128;
    private static final int heightChanged = 256;
    private static final int widthChanged = 512;
    private static final int componentOrientationChanged = 1024;
    private static final int CHANGE_LEAD = 0;
    private static final int CHANGE_SELECTION = 1;
    private static final int EXTEND_SELECTION = 2;

    public static void loadActionMap(LazyActionMap lazyActionMap) {
        lazyActionMap.put(new Actions("selectPreviousColumn"));
        lazyActionMap.put(new Actions("selectPreviousColumnExtendSelection"));
        lazyActionMap.put(new Actions("selectPreviousColumnChangeLead"));
        lazyActionMap.put(new Actions("selectNextColumn"));
        lazyActionMap.put(new Actions("selectNextColumnExtendSelection"));
        lazyActionMap.put(new Actions("selectNextColumnChangeLead"));
        lazyActionMap.put(new Actions("selectPreviousRow"));
        lazyActionMap.put(new Actions("selectPreviousRowExtendSelection"));
        lazyActionMap.put(new Actions("selectPreviousRowChangeLead"));
        lazyActionMap.put(new Actions("selectNextRow"));
        lazyActionMap.put(new Actions("selectNextRowExtendSelection"));
        lazyActionMap.put(new Actions("selectNextRowChangeLead"));
        lazyActionMap.put(new Actions("selectPreviousGroup"));
        lazyActionMap.put(new Actions("selectPreviousGroupExtendSelection"));
        lazyActionMap.put(new Actions("selectPreviousGroupChangeLead"));
        lazyActionMap.put(new Actions("selectNextGroup"));
        lazyActionMap.put(new Actions("selectNextGroupExtendSelection"));
        lazyActionMap.put(new Actions("selectNextGroupChangeLead"));
        lazyActionMap.put(new Actions("selectFirstRow"));
        lazyActionMap.put(new Actions("selectFirstRowExtendSelection"));
        lazyActionMap.put(new Actions("selectFirstRowChangeLead"));
        lazyActionMap.put(new Actions("selectLastRow"));
        lazyActionMap.put(new Actions("selectLastRowExtendSelection"));
        lazyActionMap.put(new Actions("selectLastRowChangeLead"));
        lazyActionMap.put(new Actions("scrollUp"));
        lazyActionMap.put(new Actions("scrollUpExtendSelection"));
        lazyActionMap.put(new Actions("scrollUpChangeLead"));
        lazyActionMap.put(new Actions("scrollDown"));
        lazyActionMap.put(new Actions("scrollDownExtendSelection"));
        lazyActionMap.put(new Actions("scrollDownChangeLead"));
        lazyActionMap.put(new Actions("selectAll"));
        lazyActionMap.put(new Actions("clearSelection"));
        lazyActionMap.put(new Actions("addToSelection"));
        lazyActionMap.put(new Actions("toggleAndAnchor"));
        lazyActionMap.put(new Actions("extendTo"));
        lazyActionMap.put(new Actions("moveSelectionTo"));
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        this.listHeight = -1;
        this.listWidth = -1;
        this._rowInfos = null;
        this._groupInfos = null;
    }

    protected void installDefaults() {
        super.installDefaults();
        GroupList groupList = (GroupList)this.list;
        if (groupList.getGroupCellRenderer() == null) {
            ListCellRenderer listCellRenderer = groupList.getCellRenderer();
            if (listCellRenderer == null) {
                groupList.setGroupCellRenderer((ListCellRenderer)UIManager.get("GroupableList.cellRenderer"));
            } else {
                groupList.setGroupCellRenderer(new BasicHeaderRenderer(listCellRenderer));
            }
        }
        this.layoutOrientation = groupList.getLayoutOrientation();
        this.isLeftToRight = groupList.getComponentOrientation().isLeftToRight();
    }

    protected void uninstallDefaults() {
        GroupList groupList = (GroupList)this.list;
        if (groupList.getGroupCellRenderer() instanceof UIResource) {
            groupList.setGroupCellRenderer(null);
        }
        super.uninstallDefaults();
    }

    protected void installListeners() {
        super.installListeners();
        this.list.removePropertyChangeListener(this.propertyChangeListener);
        this.list.getSelectionModel().removeListSelectionListener(this.listSelectionListener);
        this.propertyChangeListener = new PropertyChangeHandler();
        this.listSelectionListener = new ListSelectionHandler();
        this.list.addPropertyChangeListener(this.propertyChangeListener);
        this.list.getSelectionModel().addListSelectionListener(this.listSelectionListener);
    }

    public void uninstallListeners() {
        super.uninstallListeners();
        this.list.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        switch (this.layoutOrientation) {
            case 1: {
                if (this.list.getHeight() == this.listHeight) break;
                this.updateLayoutStateNeeded |= 0x100;
                this.redrawList();
                break;
            }
            case 2: {
                if (this.list.getWidth() == this.listWidth) break;
                this.updateLayoutStateNeeded |= 0x200;
                this.redrawList();
                break;
            }
        }
        this.maybeUpdateLayoutState();
        GroupList groupList = (GroupList)this.list;
        ListCellRenderer listCellRenderer = groupList.getCellRenderer();
        ListCellRenderer listCellRenderer2 = groupList.getGroupCellRenderer();
        GroupListModel groupListModel = groupList.getModel();
        ListSelectionModel listSelectionModel = groupList.getSelectionModel();
        int n2 = groupList.getLeadSelectionIndex();
        int n3 = groupListModel.getSize();
        for (int i2 = 0; i2 < n3; ++i2) {
            ListCellRenderer listCellRenderer3;
            Rectangle rectangle = this.getCellBounds(groupList, i2);
            ListCellRenderer listCellRenderer4 = listCellRenderer3 = groupListModel.isGroupRow(i2) ? listCellRenderer2 : listCellRenderer;
            if (listCellRenderer3 == null) continue;
            this.paintCell(graphics, i2, rectangle, listCellRenderer3, groupListModel, listSelectionModel, n2);
        }
    }

    protected void originalPaintCell(Graphics graphics, int n2, Rectangle rectangle, ListCellRenderer listCellRenderer, ListModel listModel, ListSelectionModel listSelectionModel, int n3) {
        Object e2 = listModel.getElementAt(n2);
        boolean bl2 = this.list.hasFocus() && n2 == n3;
        boolean bl3 = listSelectionModel.isSelectedIndex(n2);
        Component component = listCellRenderer.getListCellRendererComponent(this.list, e2, n2, bl3, bl2);
        int n4 = rectangle.x;
        int n5 = rectangle.y;
        int n6 = rectangle.width;
        int n7 = rectangle.height;
        this.rendererPane.paintComponent(graphics, component, this.list, n4, n5, n6, n7, true);
    }

    protected void paintCell(Graphics graphics, int n2, Rectangle rectangle, ListCellRenderer listCellRenderer, ListModel listModel, ListSelectionModel listSelectionModel, int n3) {
        if (listModel instanceof GroupListModel && ((GroupListModel)listModel).isGroupRow(n2)) {
            this.originalPaintCell(graphics, n2, rectangle, listCellRenderer, listModel, listSelectionModel, n3);
        } else {
            super.paintCell(graphics, n2, rectangle, listCellRenderer, listModel, listSelectionModel, n3);
        }
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        this.maybeUpdateLayoutState();
        return this._preferredSize;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new A03GroupListUI();
    }

    public int locationToIndex(JList jList, Point point) {
        this.maybeUpdateLayoutState();
        return this.convertLocationToModel(point.x, point.y);
    }

    public int locationToRow(JList jList, Point point) {
        return this.convertModelToRow(this.locationToIndex(jList, point));
    }

    public Point indexToLocation(JList jList, int n2) {
        this.maybeUpdateLayoutState();
        Rectangle rectangle = this.getCellBounds(jList, n2);
        if (rectangle != null) {
            return new Point(rectangle.x, rectangle.y);
        }
        return null;
    }

    public Rectangle getCellBounds(JList jList, int n2, int n3) {
        this.maybeUpdateLayoutState();
        int n4 = Math.min(jList.getModel().getSize() - 1, Math.min(n2, n3));
        int n5 = Math.min(jList.getModel().getSize() - 1, Math.max(n2, n3));
        if (n4 >= jList.getModel().getSize()) {
            return null;
        }
        Rectangle rectangle = this.getCellBounds(jList, n4);
        if (rectangle == null) {
            return null;
        }
        if (n4 == n5) {
            return rectangle;
        }
        Rectangle rectangle2 = this.getCellBounds(jList, n5);
        if (rectangle2 != null) {
            if (this.layoutOrientation == 2 || this.layoutOrientation == 3) {
                int n6;
                int n7 = this.convertModelToRow(n4);
                if (n7 != (n6 = this.convertModelToRow(n5))) {
                    rectangle.x = 0;
                    rectangle.width = jList.getWidth();
                }
            } else if (this.layoutOrientation == 1) {
                rectangle.setBounds(0, 0, jList.getWidth(), jList.getHeight());
            } else if (rectangle.x != rectangle2.x) {
                rectangle.y = 0;
                rectangle.height = jList.getHeight();
            }
            rectangle.add(rectangle2);
        }
        return rectangle;
    }

    public Rectangle getCellBounds(JList jList, int n2) {
        this.maybeUpdateLayoutState();
        Rectangle rectangle = new Rectangle();
        if (n2 == -1) {
            return new Rectangle();
        }
        Insets insets = jList.getInsets();
        GroupListModel groupListModel = ((GroupList)jList).getModel();
        if (groupListModel.isGroupRow(n2)) {
            rectangle.setBounds(this._headerBounds.get(n2));
            rectangle.x = insets.left;
            rectangle.width = jList.getWidth() - insets.left - insets.right;
            return rectangle;
        }
        int n3 = groupListModel.getGroupRowIndex(n2);
        assert (n3 == -1 || groupListModel.isGroupRow(n3));
        Rectangle rectangle2 = this._headerBounds.get(n3);
        if (rectangle2 == null) {
            assert (n3 == -1);
            rectangle2 = new Rectangle();
        }
        rectangle.y = rectangle2.y + rectangle2.height;
        ++n3;
        switch (this.layoutOrientation) {
            case 0: {
                for (int i2 = n3; i2 < n2; ++i2) {
                    rectangle.y = rectangle.y + (this.cellHeights != null ? this.cellHeights[i2] : this.cellHeight);
                }
                rectangle.y += insets.top;
                rectangle.x = insets.left;
                rectangle.width = jList.getWidth() - insets.left - insets.right;
                rectangle.height = this.cellHeights != null ? this.cellHeights[n2] : this.cellHeight;
                break;
            }
            case 1: 
            case 2: {
                int n4;
                int n5 = n2 - n3;
                int n6 = 0;
                if (this.layoutOrientation == 1) {
                    n4 = groupListModel.getNextGroupRowIndex(n2) - n3;
                    n6 = (n4 + this.columnCount - 1) / this.columnCount;
                }
                n4 = this.layoutOrientation == 1 ? n5 / n6 : n5 % this.columnCount;
                int n7 = this.layoutOrientation == 1 ? n5 % n6 : n5 / this.columnCount;
                rectangle.x = this.isLeftToRight ? insets.left : jList.getWidth() - insets.right - this.cellWidth;
                rectangle.y += insets.top;
                rectangle.x = this.isLeftToRight ? (rectangle.x += n4 * this.cellWidth) : (rectangle.x -= n4 * this.cellWidth);
                rectangle.y += n7 * this.cellHeight;
                rectangle.width = this.cellWidth;
                rectangle.height = this.cellHeight;
                break;
            }
            case 3: {
                int n8 = n2 - n3;
                rectangle.x = this.isLeftToRight ? insets.left : jList.getWidth() - insets.right - this.cellWidth;
                rectangle.y += insets.top;
                rectangle.x = this.isLeftToRight ? (rectangle.x += n8 * this.cellWidth) : (rectangle.x -= n8 * this.cellWidth);
                rectangle.width = this.cellWidth;
                rectangle.height = this.cellHeight;
            }
        }
        return rectangle;
    }

    private int convertLocationToRow(int n2, int n3, boolean bl2) {
        Insets insets = this.list.getInsets();
        for (int i2 = this._rowInfos.size() - 1; i2 >= 0; --i2) {
            int n4;
            RowInfo rowInfo = this._rowInfos.get(i2);
            int n5 = rowInfo.point.y + insets.top;
            int n6 = n4 = this.cellHeights != null ? this.cellHeights[rowInfo.index] : this.cellHeight;
            if (n3 < n5) continue;
            if (bl2 || n3 < n5 + n4) {
                return i2;
            }
            return -1;
        }
        return bl2 ? 0 : -1;
    }

    private int convertLocationToColumnInRow(int n2, int n3) {
        Insets insets = this.list.getInsets();
        if (n3 >= 0 && n3 < this._rowInfos.size()) {
            RowInfo rowInfo = this._rowInfos.get(n3);
            for (int i2 = rowInfo.size - 1; i2 >= 0; --i2) {
                if (!(this.isLeftToRight ? n2 >= insets.left + i2 * this.cellWidth : n2 <= this.list.getWidth() - insets.right - i2 * this.cellWidth)) continue;
                return i2;
            }
            return 0;
        }
        return -1;
    }

    private int convertLocationToModel(int n2, int n3) {
        int n4 = this.convertLocationToRow(n2, n3, true);
        int n5 = this.convertLocationToColumnInRow(n2, n4);
        if (n4 >= 0 && n5 >= 0) {
            return this.getModelIndex(n5, n4);
        }
        return -1;
    }

    public int getRowCount() {
        if (this.layoutOrientation == 0) {
            return this.list.getModel().getSize();
        }
        return this._rowInfos != null ? this._rowInfos.size() : 0;
    }

    public int getColumnCount(int n2) {
        if (this.layoutOrientation == 0) {
            return 1;
        }
        return this._rowInfos != null ? this._rowInfos.get((int)n2).size : 0;
    }

    private int getModelIndex(int n2, int n3) {
        switch (this.layoutOrientation) {
            case 1: {
                RowInfo rowInfo = this._rowInfos.get(n3);
                int n4 = rowInfo.index;
                GroupListModel groupListModel = (GroupListModel)this.list.getModel();
                if (groupListModel.isGroupRow(n4)) {
                    assert (n2 == 0);
                    return n4;
                }
                int n5 = groupListModel.getGroupRowIndex(n4);
                int n6 = groupListModel.getNextGroupRowIndex(n4) - n5;
                int n7 = n6 - 1;
                int n8 = (n7 + this.columnCount - 1) / this.columnCount;
                return n4 + n8 * n2;
            }
            case 2: 
            case 3: {
                RowInfo rowInfo = this._rowInfos.get(n3);
                return rowInfo.index + Math.min(n2, rowInfo.size - 1);
            }
        }
        return n3;
    }

    private int convertModelToRow(int n2) {
        GroupListModel groupListModel = (GroupListModel)this.list.getModel();
        int n3 = groupListModel.getSize();
        if (n2 < 0 || n2 >= n3) {
            return -1;
        }
        if (this.layoutOrientation == 2 || this.layoutOrientation == 3) {
            for (int i2 = this._rowInfos.size() - 1; i2 >= 0; --i2) {
                if (this._rowInfos.get((int)i2).index > n2) continue;
                return i2;
            }
        } else if (this.layoutOrientation == 1) {
            int n4;
            int n5 = groupListModel.getGroupRowIndex(n2);
            int n6 = -1;
            for (n4 = 0; n4 < this._rowInfos.size(); ++n4) {
                RowInfo rowInfo = this._rowInfos.get(n4);
                if (rowInfo.index != n5) continue;
                assert (rowInfo.size == 1);
                n6 = n4;
                break;
            }
            assert (n6 != -1);
            n4 = n2 - (n5 + 1);
            int n7 = groupListModel.getNextGroupRowIndex(n2) - (n5 + 1);
            int n8 = (n7 + this.columnCount - 1) / this.columnCount;
            return n6 + 1 + n4 % n8;
        }
        return n2;
    }

    private int convertModelToColumn(int n2) {
        GroupListModel groupListModel = (GroupListModel)this.list.getModel();
        int n3 = groupListModel.getSize();
        if (n2 < 0 || n2 >= n3) {
            return -1;
        }
        if (this.layoutOrientation == 2 || this.layoutOrientation == 3) {
            for (int i2 = this._rowInfos.size() - 1; i2 >= 0; --i2) {
                int n4 = this._rowInfos.get((int)i2).index;
                if (n4 > n2) continue;
                return n2 - n4;
            }
        } else if (this.layoutOrientation == 1) {
            int n5 = groupListModel.getGroupRowIndex(n2);
            int n6 = n2 - (n5 + 1);
            int n7 = groupListModel.getNextGroupRowIndex(n2) - (n5 + 1);
            int n8 = (n7 + this.columnCount - 1) / this.columnCount;
            return n6 / n8;
        }
        return 0;
    }

    protected void maybeUpdateLayoutState() {
        if (this.updateLayoutStateNeeded != 0) {
            this.updateLayoutState();
            this.updateLayoutStateNeeded = 0;
        }
    }

    protected void updateLayoutState() {
        int n2 = this.list.getFixedCellHeight();
        int n3 = this.list.getFixedCellWidth();
        int n4 = this.cellWidth = n3 != -1 ? n3 : -1;
        if (n2 != -1) {
            this.cellHeight = n2;
            this.cellHeights = null;
        } else {
            this.cellHeight = -1;
            this.cellHeights = new int[this.list.getModel().getSize()];
        }
        if (n3 == -1 || n2 == -1) {
            GroupListModel groupListModel = (GroupListModel)this.list.getModel();
            int n5 = groupListModel.getSize();
            ListCellRenderer listCellRenderer = this.list.getCellRenderer();
            ListCellRenderer listCellRenderer2 = ((GroupList)this.list).getGroupCellRenderer();
            for (int i2 = 0; i2 < n5; ++i2) {
                Object e2 = groupListModel.getElementAt(i2);
                Component component = new JPanel();
                if (!groupListModel.isGroupRow(i2)) {
                    component = listCellRenderer.getListCellRendererComponent(this.list, e2, i2, false, false);
                    Dimension dimension = component.getPreferredSize();
                    if (n3 == -1) {
                        this.cellWidth = Math.max(dimension.width, this.cellWidth);
                    }
                    if (n2 == -1) {
                        this.cellHeights[i2] = dimension.height;
                    }
                } else {
                    component = listCellRenderer2.getListCellRendererComponent(this.list, e2, i2, false, false);
                }
                this.rendererPane.add(component);
            }
        }
        this.updateCellLayoutState(n3, n2);
        this.updateGroupLayoutState(n3, n2);
        this._columnIndex = this.convertModelToColumn(this.list.getSelectedIndex());
    }

    protected void updateGroupLayoutState(int n2, int n3) {
        Object object;
        this.reset();
        ListCellRenderer listCellRenderer = ((GroupList)this.list).getGroupCellRenderer();
        int n4 = 0;
        int n5 = 0;
        GroupListModel groupListModel = ((GroupList)this.list).getModel();
        int n6 = groupListModel.getSize();
        while (n5 < n6) {
            Object object2;
            if (groupListModel.isGroupRow(n5)) {
                object = new RowInfo(n5);
                ((RowInfo)object).point = new Point(0, n4);
                this._rowInfos.add((RowInfo)object);
                this._groupInfos.add((GroupInfo)object);
                object2 = listCellRenderer.getListCellRendererComponent(this.list, groupListModel.getElementAt(n5), n5, false, false);
                Dimension dimension = ((Component)object2).getPreferredSize();
                Rectangle rectangle = new Rectangle(0, n4, dimension.width, dimension.height);
                this._headerBounds.put(n5, rectangle);
                n4 += dimension.height;
                this._preferredSize.width = Math.max(this._preferredSize.width, dimension.width);
                this._preferredSize.height += dimension.height;
            }
            ++n5;
            switch (this.layoutOrientation) {
                case 0: {
                    int n7 = 0;
                    while (n5 < n6 && !groupListModel.isGroupRow(n5)) {
                        object2 = new RowInfo(n5);
                        ((RowInfo)object2).point = new Point(0, n4 + n7);
                        this._rowInfos.add((RowInfo)object2);
                        n7 += this.cellHeights != null ? this.cellHeights[n5] : this.cellHeight;
                        ++n5;
                    }
                    n4 += n7;
                    this._preferredSize.height += n7;
                    break;
                }
                case 1: 
                case 2: {
                    int n8;
                    int n9;
                    int n10 = 0;
                    int n11 = n5;
                    while (n5 < n6 && !groupListModel.isGroupRow(n5)) {
                        ++n5;
                    }
                    int n12 = n5 - n11;
                    int n13 = (n12 + this.columnCount - 1) / this.columnCount;
                    if (this.layoutOrientation == 2) {
                        RowInfo rowInfo;
                        n9 = 0;
                        n8 = n11;
                        while (n8 + this.columnCount < n5) {
                            rowInfo = new RowInfo(n8, this.columnCount);
                            rowInfo.point = new Point(0, n4 + n9 * this.cellHeight);
                            this._rowInfos.add(rowInfo);
                            n8 += this.columnCount;
                            ++n9;
                        }
                        rowInfo = new RowInfo(n8, n5 - n8);
                        assert (n9 == n13 - 1);
                        rowInfo.point = new Point(0, n4 + n9 * this.cellHeight);
                        this._rowInfos.add(rowInfo);
                    } else {
                        assert (this.layoutOrientation == 1);
                        n8 = n12 % n13;
                        n9 = (n12 + n13 - 1) / n13;
                        for (int i2 = 0; i2 < n13; ++i2) {
                            int n14 = n8 == 0 || i2 < n8 ? n9 : n9 - 1;
                            RowInfo rowInfo = new RowInfo(n11 + i2, n14);
                            rowInfo.point = new Point(0, n4 + i2 * this.cellHeight);
                            this._rowInfos.add(rowInfo);
                        }
                    }
                    n4 += (n10 += n13 * this.cellHeight);
                    this._preferredSize.height += n10;
                    this._preferredSize.width = Math.max(this._preferredSize.width, this.columnCount * this.cellWidth);
                    break;
                }
                case 3: {
                    int n15 = 0;
                    int n16 = n5;
                    while (n5 < n6 && !groupListModel.isGroupRow(n5)) {
                        ++n5;
                    }
                    int n17 = n5 - n16;
                    int n18 = 1;
                    RowInfo rowInfo = new RowInfo(n16, n17);
                    rowInfo.point = new Point(0, n4);
                    this._rowInfos.add(rowInfo);
                    n15 = n18 * this.cellHeight;
                    n4 += n15;
                    this._preferredSize.height += n15;
                    this._preferredSize.width = Math.max(this._preferredSize.width, n17 * this.cellWidth);
                }
            }
        }
        object = this.list.getInsets();
        this._preferredSize.width += ((Insets)object).left + ((Insets)object).right;
        this._preferredSize.height += ((Insets)object).top + ((Insets)object).bottom;
    }

    protected void updateCellLayoutState(int n2, int n3) {
        GroupListModel groupListModel = (GroupListModel)this.list.getModel();
        int n4 = groupListModel.getSize();
        this.listHeight = this.list.getHeight();
        this.listWidth = this.list.getWidth();
        if (n4 == 0) {
            this.columnCount = 0;
            return;
        }
        if (this.layoutOrientation != 0) {
            if (n3 > 0) {
                this.cellHeight = n3;
            } else {
                this.cellHeight = 0;
                for (int i2 = 0; i2 < this.cellHeights.length; ++i2) {
                    this.cellHeight = Math.max(this.cellHeight, this.cellHeights[i2]);
                }
                this.cellHeights = null;
            }
        }
        switch (this.layoutOrientation) {
            case 0: {
                this.columnCount = 1;
                break;
            }
            case 1: 
            case 2: {
                this.columnCount = ((GroupList)this.list).getPreferredColumnCount();
                break;
            }
            case 3: {
                this.columnCount = Integer.MAX_VALUE;
            }
        }
    }

    private void redrawList() {
        this.list.revalidate();
        this.list.repaint();
    }

    private void reset() {
        if (this._preferredSize == null) {
            this._preferredSize = new Dimension();
        } else {
            this._preferredSize.setSize(0, 0);
        }
        if (this._headerBounds == null) {
            this._headerBounds = new LinkedHashMap<Integer, Rectangle>();
        } else {
            this._headerBounds.clear();
        }
        if (this._rowInfos == null) {
            this._rowInfos = new ArrayList<RowInfo>();
        } else {
            this._rowInfos.clear();
        }
        if (this._groupInfos == null) {
            this._groupInfos = new ArrayList<GroupInfo>();
        } else {
            this._groupInfos.clear();
        }
    }

    protected void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(0);
        SwingUtilities.replaceUIInputMap(this.list, 0, inputMap);
        InputMap inputMap2 = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(this.list, 1, inputMap2);
        LazyActionMap.installLazyActionMap(this.list, A03GroupListUI.class, "GroupList.actionMap");
    }

    InputMap getInputMap(int n2) {
        if (n2 == 1) {
            InputMap inputMap;
            InputMap inputMap2 = (InputMap)UIManager.get("GroupList.ancestorInputMap");
            if (inputMap2 == null) {
                inputMap2 = new InputMap();
            }
            inputMap2.setParent((InputMap)UIManager.get("List.focusInputMap"));
            if (this.list.getComponentOrientation().isLeftToRight()) {
                return inputMap2;
            }
            InputMap inputMap3 = (InputMap)UIManager.get("GroupList.ancestorInputMap.RightToLeft");
            if (inputMap3 == null) {
                inputMap3 = new InputMap();
            }
            if ((inputMap = (InputMap)UIManager.get("List.focusInputMap.RightToLeft")) == null) {
                inputMap = new InputMap();
            }
            inputMap3.setParent(inputMap);
            inputMap.setParent(inputMap2);
            return inputMap3;
        }
        if (n2 == 0) {
            InputMap inputMap;
            InputMap inputMap4 = (InputMap)UIManager.get("List.focusInputMap");
            if (this.isLeftToRight || (inputMap = (InputMap)UIManager.get("List.focusInputMap.RightToLeft")) == null) {
                return inputMap4;
            }
            inputMap.setParent(inputMap4);
            return inputMap;
        }
        return null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.list, null);
        SwingUtilities.replaceUIInputMap(this.list, 0, null);
        SwingUtilities.replaceUIInputMap(this.list, 1, null);
    }

    static {
        UIManager.put("GroupableList.headerRenderer", new BasicHeaderRenderer());
    }

    private static class Actions
    extends UIAction {
        private static final String SELECT_PREVIOUS_COLUMN = "selectPreviousColumn";
        private static final String SELECT_PREVIOUS_COLUMN_EXTEND = "selectPreviousColumnExtendSelection";
        private static final String SELECT_PREVIOUS_COLUMN_CHANGE_LEAD = "selectPreviousColumnChangeLead";
        private static final String SELECT_NEXT_COLUMN = "selectNextColumn";
        private static final String SELECT_NEXT_COLUMN_EXTEND = "selectNextColumnExtendSelection";
        private static final String SELECT_NEXT_COLUMN_CHANGE_LEAD = "selectNextColumnChangeLead";
        private static final String SELECT_PREVIOUS_ROW = "selectPreviousRow";
        private static final String SELECT_PREVIOUS_ROW_EXTEND = "selectPreviousRowExtendSelection";
        private static final String SELECT_PREVIOUS_ROW_CHANGE_LEAD = "selectPreviousRowChangeLead";
        private static final String SELECT_NEXT_ROW = "selectNextRow";
        private static final String SELECT_NEXT_ROW_EXTEND = "selectNextRowExtendSelection";
        private static final String SELECT_NEXT_ROW_CHANGE_LEAD = "selectNextRowChangeLead";
        private static final String SELECT_FIRST_ROW = "selectFirstRow";
        private static final String SELECT_FIRST_ROW_EXTEND = "selectFirstRowExtendSelection";
        private static final String SELECT_FIRST_ROW_CHANGE_LEAD = "selectFirstRowChangeLead";
        private static final String SELECT_LAST_ROW = "selectLastRow";
        private static final String SELECT_LAST_ROW_EXTEND = "selectLastRowExtendSelection";
        private static final String SELECT_LAST_ROW_CHANGE_LEAD = "selectLastRowChangeLead";
        private static final String SELECT_PREVIOUS_GROUP = "selectPreviousGroup";
        private static final String SELECT_PREVIOUS_GROUP_EXTEND = "selectPreviousGroupExtendSelection";
        private static final String SELECT_PREVIOUS_GROUP_CHANGE_LEAD = "selectPreviousGroupChangeLead";
        private static final String SELECT_NEXT_GROUP = "selectNextGroup";
        private static final String SELECT_NEXT_GROUP_EXTEND = "selectNextGroupExtendSelection";
        private static final String SELECT_NEXT_GROUP_CHANGE_LEAD = "selectNextGroupChangeLead";
        private static final String SCROLL_UP = "scrollUp";
        private static final String SCROLL_UP_EXTEND = "scrollUpExtendSelection";
        private static final String SCROLL_UP_CHANGE_LEAD = "scrollUpChangeLead";
        private static final String SCROLL_DOWN = "scrollDown";
        private static final String SCROLL_DOWN_EXTEND = "scrollDownExtendSelection";
        private static final String SCROLL_DOWN_CHANGE_LEAD = "scrollDownChangeLead";
        private static final String SELECT_ALL = "selectAll";
        private static final String CLEAR_SELECTION = "clearSelection";
        private static final String ADD_TO_SELECTION = "addToSelection";
        private static final String TOGGLE_AND_ANCHOR = "toggleAndAnchor";
        private static final String EXTEND_TO = "extendTo";
        private static final String MOVE_SELECTION_TO = "moveSelectionTo";

        Actions(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = this.getName();
            GroupList groupList = (GroupList)actionEvent.getSource();
            A03GroupListUI a03GroupListUI = (A03GroupListUI)((Object)groupList.getUI());
            if (string == SELECT_PREVIOUS_COLUMN) {
                this.changeSelection(groupList, 1, this.getNextColumnIndex(groupList, a03GroupListUI, -1), true);
            } else if (string == SELECT_PREVIOUS_COLUMN_EXTEND) {
                this.changeSelection(groupList, 2, this.getNextColumnIndex(groupList, a03GroupListUI, -1), true);
            } else if (string == SELECT_PREVIOUS_COLUMN_CHANGE_LEAD) {
                this.changeSelection(groupList, 0, this.getNextColumnIndex(groupList, a03GroupListUI, -1), true);
            } else if (string == SELECT_NEXT_COLUMN) {
                this.changeSelection(groupList, 1, this.getNextColumnIndex(groupList, a03GroupListUI, 1), true);
            } else if (string == SELECT_NEXT_COLUMN_EXTEND) {
                this.changeSelection(groupList, 2, this.getNextColumnIndex(groupList, a03GroupListUI, 1), true);
            } else if (string == SELECT_NEXT_COLUMN_CHANGE_LEAD) {
                this.changeSelection(groupList, 0, this.getNextColumnIndex(groupList, a03GroupListUI, 1), true);
            } else if (string == SELECT_PREVIOUS_ROW) {
                a03GroupListUI._ignoreResetColumnIndex = true;
                this.changeSelection(groupList, 1, this.getNextIndex(groupList, a03GroupListUI, -1), true);
            } else if (string == SELECT_PREVIOUS_ROW_EXTEND) {
                a03GroupListUI._ignoreResetColumnIndex = true;
                this.changeSelection(groupList, 2, this.getNextIndex(groupList, a03GroupListUI, -1), true);
            } else if (string == SELECT_PREVIOUS_ROW_CHANGE_LEAD) {
                a03GroupListUI._ignoreResetColumnIndex = true;
                this.changeSelection(groupList, 0, this.getNextIndex(groupList, a03GroupListUI, -1), true);
            } else if (string == SELECT_NEXT_ROW) {
                a03GroupListUI._ignoreResetColumnIndex = true;
                this.changeSelection(groupList, 1, this.getNextIndex(groupList, a03GroupListUI, 1), true);
            } else if (string == SELECT_NEXT_ROW_EXTEND) {
                a03GroupListUI._ignoreResetColumnIndex = true;
                this.changeSelection(groupList, 2, this.getNextIndex(groupList, a03GroupListUI, 1), true);
            } else if (string == SELECT_NEXT_ROW_CHANGE_LEAD) {
                a03GroupListUI._ignoreResetColumnIndex = true;
                this.changeSelection(groupList, 0, this.getNextIndex(groupList, a03GroupListUI, 1), true);
            } else if (string == SELECT_FIRST_ROW) {
                a03GroupListUI._ignoreResetColumnIndex = true;
                this.changeSelection(groupList, 1, 0, true);
            } else if (string == SELECT_FIRST_ROW_EXTEND) {
                a03GroupListUI._ignoreResetColumnIndex = true;
                this.changeSelection(groupList, 2, 0, true);
            } else if (string == SELECT_FIRST_ROW_CHANGE_LEAD) {
                this.changeSelection(groupList, 0, 0, true);
            } else if (string == SELECT_LAST_ROW) {
                a03GroupListUI._ignoreResetColumnIndex = true;
                this.changeSelection(groupList, 1, groupList.getModel().getSize() - 1, true);
            } else if (string == SELECT_LAST_ROW_EXTEND) {
                a03GroupListUI._ignoreResetColumnIndex = true;
                this.changeSelection(groupList, 2, groupList.getModel().getSize() - 1, true);
            } else if (string == SELECT_LAST_ROW_CHANGE_LEAD) {
                a03GroupListUI._ignoreResetColumnIndex = true;
                this.changeSelection(groupList, 0, groupList.getModel().getSize() - 1, true);
            } else if (string == SELECT_PREVIOUS_GROUP) {
                this.changeSelection(groupList, 1, this.getNextGroupIndex(groupList, a03GroupListUI, -1), true);
            } else if (string == SELECT_NEXT_GROUP) {
                this.changeSelection(groupList, 1, this.getNextGroupIndex(groupList, a03GroupListUI, 1), true);
            } else if (string == SCROLL_UP) {
                a03GroupListUI._ignoreResetColumnIndex = true;
                this.scroll(groupList, 1, true);
            } else if (string == SCROLL_UP_EXTEND) {
                a03GroupListUI._ignoreResetColumnIndex = true;
                this.scroll(groupList, 2, true);
            } else if (string == SCROLL_UP_CHANGE_LEAD) {
                a03GroupListUI._ignoreResetColumnIndex = true;
                this.scroll(groupList, 0, true);
            } else if (string == SCROLL_DOWN) {
                a03GroupListUI._ignoreResetColumnIndex = true;
                this.scroll(groupList, 1, false);
            } else if (string == SCROLL_DOWN_EXTEND) {
                a03GroupListUI._ignoreResetColumnIndex = true;
                this.scroll(groupList, 2, false);
            } else if (string == SCROLL_DOWN_CHANGE_LEAD) {
                a03GroupListUI._ignoreResetColumnIndex = true;
                this.scroll(groupList, 0, false);
            } else if (string == SELECT_ALL) {
                this.selectAll(groupList);
            } else if (string == CLEAR_SELECTION) {
                this.clearSelection(groupList);
            } else if (string == ADD_TO_SELECTION) {
                int n2 = groupList.getSelectionModel().getLeadSelectionIndex();
                if (!groupList.isSelectedIndex(n2)) {
                    int n3 = groupList.getSelectionModel().getAnchorSelectionIndex();
                    groupList.setValueIsAdjusting(true);
                    groupList.addSelectionInterval(n2, n2);
                    groupList.getSelectionModel().setAnchorSelectionIndex(n3);
                    groupList.setValueIsAdjusting(false);
                }
            } else if (string == TOGGLE_AND_ANCHOR) {
                int n4 = groupList.getSelectionModel().getLeadSelectionIndex();
                if (groupList.isSelectedIndex(n4)) {
                    groupList.removeSelectionInterval(n4, n4);
                } else {
                    groupList.addSelectionInterval(n4, n4);
                }
            } else if (string == EXTEND_TO) {
                this.changeSelection(groupList, 2, groupList.getSelectionModel().getLeadSelectionIndex(), false);
            } else if (string == MOVE_SELECTION_TO) {
                this.changeSelection(groupList, 1, groupList.getSelectionModel().getLeadSelectionIndex(), false);
            }
            a03GroupListUI._ignoreResetColumnIndex = false;
        }

        @Override
        public boolean isEnabled(Object object) {
            String string = this.getName();
            if (string == SELECT_PREVIOUS_COLUMN_CHANGE_LEAD || string == SELECT_NEXT_COLUMN_CHANGE_LEAD || string == SELECT_PREVIOUS_ROW_CHANGE_LEAD || string == SELECT_NEXT_ROW_CHANGE_LEAD || string == SELECT_FIRST_ROW_CHANGE_LEAD || string == SELECT_LAST_ROW_CHANGE_LEAD || string == SCROLL_UP_CHANGE_LEAD || string == SCROLL_DOWN_CHANGE_LEAD) {
                return object != null && ((JList)object).getSelectionModel() instanceof DefaultListSelectionModel;
            }
            return true;
        }

        private void clearSelection(JList jList) {
            jList.clearSelection();
        }

        private void selectAll(JList jList) {
            int n2 = jList.getModel().getSize();
            if (n2 > 0) {
                ListSelectionModel listSelectionModel = jList.getSelectionModel();
                if (listSelectionModel.getSelectionMode() == 0) {
                    int n3 = jList.getLeadSelectionIndex();
                    if (n3 != -1) {
                        jList.setSelectionInterval(n3, n3);
                    } else if (jList.getMinSelectionIndex() == -1) {
                        jList.setSelectionInterval(0, 0);
                        jList.ensureIndexIsVisible(0);
                    }
                } else {
                    jList.setValueIsAdjusting(true);
                    int n4 = listSelectionModel.getAnchorSelectionIndex();
                    int n5 = listSelectionModel.getLeadSelectionIndex();
                    jList.setSelectionInterval(0, n2 - 1);
                    jList.addSelectionInterval(n4, n5);
                    jList.setValueIsAdjusting(false);
                }
            }
        }

        private void scroll(GroupList groupList, int n2, boolean bl2) {
            int n3 = this.getNextPageIndex(groupList, bl2);
            if (n3 != -1) {
                this.changeSelection(groupList, n2, n3, true);
            }
        }

        private int getValidPageIndex(GroupList groupList, int n2, int n3) {
            A03GroupListUI a03GroupListUI = (A03GroupListUI)((Object)groupList.getUI());
            GroupListModel groupListModel = groupList.getModel();
            int n4 = n3 - n2 > 0 ? 1 : -1;
            int n5 = a03GroupListUI.convertModelToRow(n2);
            int n6 = a03GroupListUI.convertModelToRow(n3);
            int n7 = n3;
            switch (groupList.getLayoutOrientation()) {
                default: 
            }
            int n8 = a03GroupListUI.convertModelToRow(n7);
            if (!groupList.isGroupCellSelectable() && groupListModel.isGroupRow(n7)) {
                n8 -= n4;
            }
            if (0 <= n8 && n8 < a03GroupListUI._rowInfos.size()) {
                RowInfo rowInfo = (RowInfo)a03GroupListUI._rowInfos.get(n8);
                n7 = a03GroupListUI.getModelIndex(Math.min(rowInfo.size - 1, a03GroupListUI._columnIndex), n8);
                if (n5 <= n8 && n8 <= n6 || n6 <= n8 && n8 <= n5) {
                    return n7;
                }
            }
            n7 = n3;
            n8 = groupListModel.getSize();
            switch (groupList.getLayoutOrientation()) {
                default: 
            }
            int n9 = a03GroupListUI.convertModelToRow(n7);
            if (!groupList.isGroupCellSelectable() && groupListModel.isGroupRow(n7)) {
                n9 += n4;
            }
            if (0 <= n9 && n9 < a03GroupListUI._rowInfos.size()) {
                RowInfo rowInfo = (RowInfo)a03GroupListUI._rowInfos.get(n5);
                n7 = a03GroupListUI.getModelIndex(Math.min(rowInfo.size - 1, a03GroupListUI._columnIndex), n5);
                if (0 <= n9 && n9 <= n6 || n6 <= n9 && n9 < a03GroupListUI._rowInfos.size()) {
                    return n7;
                }
            }
            return n3;
        }

        private int getNextPageIndex(GroupList groupList, boolean bl2) {
            A03GroupListUI a03GroupListUI = (A03GroupListUI)((Object)groupList.getUI());
            if (bl2) {
                int n2 = groupList.getFirstVisibleIndex();
                int n3 = a03GroupListUI.convertModelToRow(n2);
                ListSelectionModel listSelectionModel = groupList.getSelectionModel();
                int n4 = listSelectionModel.getLeadSelectionIndex();
                int n5 = a03GroupListUI.convertModelToRow(n4);
                if (n5 == n3) {
                    Rectangle rectangle = groupList.getVisibleRect();
                    rectangle.y = Math.max(0, rectangle.y - rectangle.height);
                    int n6 = groupList.locationToIndex(rectangle.getLocation());
                    n2 = this.getValidPageIndex(groupList, n2, n6);
                } else {
                    n2 = this.getValidPageIndex(groupList, n4, n2);
                }
                return n2;
            }
            int n7 = groupList.getLastVisibleIndex();
            ListSelectionModel listSelectionModel = groupList.getSelectionModel();
            if (n7 == -1) {
                n7 = groupList.getModel().getSize() - 1;
            }
            int n8 = a03GroupListUI.convertModelToRow(n7);
            int n9 = listSelectionModel.getLeadSelectionIndex();
            int n10 = a03GroupListUI.convertModelToRow(n9);
            if (n10 == n8) {
                Rectangle rectangle = groupList.getVisibleRect();
                rectangle.y += rectangle.height + rectangle.height - 1;
                int n11 = groupList.locationToIndex(rectangle.getLocation());
                if (n11 == -1) {
                    n11 = groupList.getModel().getSize() - 1;
                }
                n7 = this.getValidPageIndex(groupList, n7, n11);
            } else {
                n7 = this.getValidPageIndex(groupList, n9, n7);
            }
            return n7;
        }

        private void changeSelection(JList jList, int n2, int n3, boolean bl2) {
            if (n3 >= 0 && n3 < jList.getModel().getSize()) {
                int n4;
                ListSelectionModel listSelectionModel = jList.getSelectionModel();
                if (n2 == 0 && jList.getSelectionMode() != 2) {
                    n2 = 1;
                }
                if (n2 == 2) {
                    int n5 = jList.getSelectedIndex();
                    int n6 = listSelectionModel.getAnchorSelectionIndex();
                    if (n6 == -1) {
                        n6 = n3;
                    }
                    jList.setSelectionInterval(n6, n3);
                    n4 = this.getVisibleRect(jList, n5, n3);
                } else if (n2 == 1) {
                    int n7 = jList.getSelectedIndex();
                    jList.setSelectedIndex(n3);
                    n4 = this.getVisibleRect(jList, n7, n3);
                } else {
                    int n8 = jList.getSelectedIndex();
                    ((DefaultListSelectionModel)listSelectionModel).moveLeadSelectionIndex(n3);
                    n4 = this.getVisibleRect(jList, n8, n3);
                }
                if (bl2) {
                    jList.ensureIndexIsVisible(n4);
                }
            }
        }

        private int getNextColumnIndex(GroupList groupList, A03GroupListUI a03GroupListUI, int n2) {
            int n3;
            int n4 = groupList.getLeadSelectionIndex();
            GroupListModel groupListModel = groupList.getModel();
            int n5 = groupListModel.getSize();
            int n6 = a03GroupListUI._rowInfos.size();
            int n7 = n3 = n2 > 0 ? 1 : -1;
            if (a03GroupListUI == null || n5 == 0) {
                return -1;
            }
            if (n5 == 1) {
                return 0;
            }
            if (n4 == -1) {
                return 0;
            }
            int n8 = a03GroupListUI.convertModelToColumn(n4);
            int n9 = a03GroupListUI.convertModelToRow(n4);
            RowInfo rowInfo = (RowInfo)a03GroupListUI._rowInfos.get(n9);
            int n10 = -2;
            while (n2 != 0) {
                RowInfo rowInfo2 = rowInfo;
                int n11 = n8 + n2;
                if (0 <= n11 && n11 < rowInfo2.size) {
                    n8 = n11;
                    n4 = a03GroupListUI.getModelIndex(n8, n9);
                    break;
                }
                if (0 > (n9 += n3) || n9 >= n6) break;
                rowInfo = (RowInfo)a03GroupListUI._rowInfos.get(n9);
                int n12 = n8;
                n8 = n3 > 0 ? 0 : rowInfo.size - 1;
                n10 = a03GroupListUI.getModelIndex(n8, n9);
                if (!groupList.isGroupCellSelectable() && groupListModel.isGroupRow(n10)) continue;
                assert (n10 != -2);
                n4 = n10;
                if (n3 > 0) {
                    n2 -= rowInfo2.size - n12;
                    continue;
                }
                n2 += n12 + 1;
            }
            return n4;
        }

        private int getNextIndex(GroupList groupList, A03GroupListUI a03GroupListUI, int n2) {
            int n3;
            block3: {
                int n4;
                int n5;
                GroupListModel groupListModel;
                block5: {
                    int n6;
                    block4: {
                        groupListModel = groupList.getModel();
                        n5 = groupListModel.getSize();
                        n4 = n2 > 0 ? 1 : -1;
                        n6 = groupList.getLayoutOrientation();
                        if (n3 != -1) break block4;
                        if (n5 <= 0 || groupList.isGroupCellSelectable()) break block3;
                        for (n3 = groupList.getLeadSelectionIndex(); 0 <= n3 && n3 < n5 && groupListModel.isGroupRow(n3); n3 += n4) {
                        }
                        if (n3 < n5) break block3;
                        n3 = -1;
                        break block3;
                    }
                    if (n6 != 2 && n6 != 3) break block5;
                    if (a03GroupListUI == null) break block3;
                    int n7 = a03GroupListUI.convertModelToRow(n3);
                    int n8 = a03GroupListUI._rowInfos.size();
                    while (0 <= (n7 += n4) && n7 < n8) {
                        int n9 = ((RowInfo)((A03GroupListUI)a03GroupListUI)._rowInfos.get((int)n7)).size;
                        int n10 = Math.min(a03GroupListUI._columnIndex, n9 - 1);
                        int n11 = a03GroupListUI.getModelIndex(n10, n7);
                        if (!groupList.isGroupCellSelectable() && groupListModel.isGroupRow(n11)) continue;
                        n3 = n11;
                        if ((n2 -= n4) != 0) continue;
                        break block3;
                    }
                    break block3;
                }
                int n12 = n3;
                while (0 <= (n12 += n4) && n12 < n5) {
                    if (!groupList.isGroupCellSelectable() && groupListModel.isGroupRow(n12)) continue;
                    n3 = n12;
                    if ((n2 -= n4) != 0) continue;
                    break;
                }
            }
            return n3;
        }

        private int getNextGroupIndex(GroupList groupList, A03GroupListUI a03GroupListUI, int n2) {
            int n3;
            int n4 = groupList.getLeadSelectionIndex();
            GroupListModel groupListModel = groupList.getModel();
            int n5 = groupListModel.getSize();
            boolean bl2 = groupList.isGroupCellSelectable();
            int n6 = n3 = n2 > 0 ? 1 : -1;
            while (n2 != 0) {
                int n7;
                int n8 = n7 = n3 > 0 ? groupListModel.getNextGroupRowIndex(n4) : groupListModel.getGroupRowIndex(n4);
                boolean bl3 = false;
                if (n3 > 0 && n8 == n5 || n3 < 0 && n8 == 0) {
                    bl3 = true;
                }
                if (!bl2) {
                    int n9;
                    int n10 = n9 = n3 > 0 ? n5 - 1 : n4;
                    while (++n8 < n9 && groupListModel.isGroupRow(n8)) {
                    }
                }
                if (bl3) {
                    n4 = n8;
                    break;
                }
                if (n4 == n8) {
                    assert (n3 == -1);
                    if (n7 > 0) {
                        n7 = groupListModel.getGroupRowIndex(n7 - 1);
                    }
                    n8 = n7;
                    if (!bl2) {
                        while (++n8 < n4 && groupListModel.isGroupRow(n8)) {
                        }
                    }
                }
                n4 = n8;
                n2 -= n3;
            }
            return n4;
        }

        private int getVisibleRect(JList jList, int n2, int n3) {
            int n4 = n3;
            if (n2 == n3) {
                if (jList.getLayoutOrientation() == 0) {
                    n4 = Math.max(0, n3 - 1);
                } else {
                    A03GroupListUI a03GroupListUI = (A03GroupListUI)((Object)jList.getUI());
                    int n5 = a03GroupListUI.convertModelToRow(n3);
                    if (n5 > 0) {
                        --n5;
                    }
                    n4 = a03GroupListUI.getModelIndex(0, n5);
                }
            }
            return n4;
        }
    }

    private static class BasicHeaderRenderer
    implements ListCellRenderer,
    UIResource {
        private ListCellRenderer cellRenderer;

        public BasicHeaderRenderer(ListCellRenderer listCellRenderer) {
            this.cellRenderer = listCellRenderer;
        }

        public BasicHeaderRenderer() {
            this(new DefaultListCellRenderer());
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl2, boolean bl3) {
            Component component = this.cellRenderer.getListCellRendererComponent(jList, object, n2, true, true);
            if (object != null) {
                ((JComponent)component).setToolTipText(String.valueOf(object));
            }
            return component;
        }
    }

    public class PropertyChangeHandler
    extends BasicListUI.PropertyChangeHandler {
        public PropertyChangeHandler() {
            super((BasicListUI)((Object)A03GroupListUI.this));
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("layoutOrientation".equals(propertyChangeEvent.getPropertyName())) {
                A03GroupListUI.this.updateLayoutStateNeeded |= 128;
                A03GroupListUI.this.layoutOrientation = A03GroupListUI.this.list.getLayoutOrientation();
                A03GroupListUI.this.redrawList();
            } else if ("visibleRowCount".equals(string) || "preferredColumnCount".equals(string)) {
                if (A03GroupListUI.this.layoutOrientation != 0) {
                    A03GroupListUI.this.updateLayoutStateNeeded |= 128;
                    A03GroupListUI.this.redrawList();
                }
            } else if ("componentOrientation".equals(string)) {
                A03GroupListUI.this.updateLayoutStateNeeded |= 1024;
                A03GroupListUI.this.isLeftToRight = A03GroupListUI.this.list.getComponentOrientation().isLeftToRight();
                A03GroupListUI.this.redrawList();
                InputMap inputMap = A03GroupListUI.this.getInputMap(0);
                SwingUtilities.replaceUIInputMap(A03GroupListUI.this.list, 0, inputMap);
            } else if ("groupCellSelectable".equals(string)) {
                A03GroupListUI.this.redrawList();
            } else {
                super.propertyChange(propertyChangeEvent);
            }
        }
    }

    public class ListSelectionHandler
    extends BasicListUI.ListSelectionHandler {
        public ListSelectionHandler() {
            super((BasicListUI)((Object)A03GroupListUI.this));
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            A03GroupListUI.this.maybeUpdateLayoutState();
            if (!A03GroupListUI.this._ignoreResetColumnIndex) {
                A03GroupListUI.this._columnIndex = A03GroupListUI.this.convertModelToColumn(A03GroupListUI.this.list.getSelectedIndex());
            }
            super.valueChanged(listSelectionEvent);
        }
    }

    private static class RowInfo
    extends GroupInfo {
        RowInfo(int n2, int n3) {
            super(n2, n3);
        }

        RowInfo(int n2) {
            this(n2, 1);
        }
    }

    private static class GroupInfo {
        int size;
        int index;
        Point point;

        GroupInfo(int n2, int n3) {
            this.index = n2;
            this.size = n3;
        }

        GroupInfo(int n2) {
            this(n2, 1);
        }

        public String toString() {
            return String.format("%s(start: %d, size: %d)", this.getClass().getSimpleName(), this.index, this.size);
        }
    }
}

