/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.comm.impl;

import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

class HelperProgressInterface
implements ProgressInterface,
Serializable {
    private transient HelperCommunication helperCommunication = HelperCommunication.getInstance();
    private transient int lastPercentCompleted = -1;
    private transient int lastSecondaryPercentCompleted = -1;
    private transient String lastStatusMessage;
    private transient String lastDetailMessage;

    HelperProgressInterface() {
    }

    @Override
    public void setStatusMessage(String message) {
        if (!Objects.equals(message, this.lastStatusMessage)) {
            this.helperCommunication.runAction(ExecutionContext.UNELEVATED, context -> context.getProgressInterface().setStatusMessage(message));
            this.lastStatusMessage = message;
        }
    }

    @Override
    public void setDetailMessage(String message) {
        if (!Objects.equals(message, this.lastDetailMessage)) {
            this.helperCommunication.runAction(ExecutionContext.UNELEVATED, context -> context.getProgressInterface().setDetailMessage(message));
            this.lastDetailMessage = message;
        }
    }

    @Override
    public void setPercentCompleted(int value) {
        if (this.lastPercentCompleted != value) {
            this.helperCommunication.runAction(ExecutionContext.UNELEVATED, context -> context.getProgressInterface().setPercentCompleted(value));
            this.lastPercentCompleted = value;
        }
    }

    @Override
    public void setSecondaryPercentCompleted(int value) {
        if (this.lastSecondaryPercentCompleted != value) {
            this.helperCommunication.runAction(ExecutionContext.UNELEVATED, context -> context.getProgressInterface().setSecondaryPercentCompleted(value));
            this.lastSecondaryPercentCompleted = value;
        }
    }

    @Override
    public int getPercentCompleted() {
        return this.helperCommunication.fetchInt(ExecutionContext.UNELEVATED, context -> context.getProgressInterface().getPercentCompleted());
    }

    @Override
    public void setIndeterminateProgress(boolean indeterminateProgress) {
        this.helperCommunication.runAction(ExecutionContext.UNELEVATED, context -> context.getProgressInterface().setIndeterminateProgress(indeterminateProgress));
    }

    @Override
    public void showFailure(String message) {
        this.helperCommunication.runAction(ExecutionContext.UNELEVATED, context -> context.getProgressInterface().showFailure(message));
    }

    @Override
    public int askOverwrite(File file) throws UserCanceledException {
        try {
            return this.helperCommunication.fetchIntChecked(ExecutionContext.UNELEVATED, context -> context.getProgressInterface().askOverwrite(file));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int askRetry(File file) throws UserCanceledException {
        try {
            return this.helperCommunication.fetchIntChecked(ExecutionContext.UNELEVATED, context -> context.getProgressInterface().askRetry(file));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean askContinue(File file) throws UserCanceledException {
        try {
            return this.helperCommunication.fetchBooleanChecked(ExecutionContext.UNELEVATED, context -> context.getProgressInterface().askContinue(file));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

