/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.applaunch;

import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.launcher.ApplicationLauncher;
import com.install4j.runtime.util.HtmlTextHelper;
import java.io.File;
import java.util.Objects;
import org.jetbrains.annotations.Nls;

public class ProgressInterfaceWrapper
implements ProgressInterface {
    private final ProgressInterface delegate;
    private final ApplicationLauncher.ProgressListener progressListener;
    private String lastStatusMessage;
    private String lastDetailMessage;
    private int lastPercentCompleted;
    private int lastSecondaryPercentCompleted;

    public ProgressInterfaceWrapper(ProgressInterface delegate, ApplicationLauncher.ProgressListener progressListener) {
        this.delegate = delegate;
        this.progressListener = progressListener;
    }

    @Override
    public void setStatusMessage(@Nls String message) {
        this.delegate.setStatusMessage(message);
        if (!Objects.equals(message, this.lastStatusMessage)) {
            this.progressListener.statusMessage(HtmlTextHelper.formatTextWithoutHtmlTags(message));
            this.lastStatusMessage = message;
        }
    }

    @Override
    public void setDetailMessage(@Nls String message) {
        this.delegate.setDetailMessage(message);
        if (!Objects.equals(message, this.lastDetailMessage)) {
            this.progressListener.detailMessage(HtmlTextHelper.formatTextWithoutHtmlTags(message));
            this.lastDetailMessage = message;
        }
    }

    @Override
    public void setPercentCompleted(int value) {
        this.delegate.setPercentCompleted(value);
        if (value != this.lastPercentCompleted) {
            this.progressListener.percentCompleted(value);
            this.lastPercentCompleted = value;
        }
    }

    @Override
    public int getPercentCompleted() {
        return this.delegate.getPercentCompleted();
    }

    @Override
    public void setSecondaryPercentCompleted(int value) {
        this.delegate.setSecondaryPercentCompleted(value);
        if (this.lastSecondaryPercentCompleted != value) {
            this.progressListener.secondaryPercentCompleted(value);
            this.lastSecondaryPercentCompleted = value;
        }
    }

    @Override
    public void setIndeterminateProgress(boolean indeterminateProgress) {
        this.delegate.setIndeterminateProgress(indeterminateProgress);
        this.progressListener.indeterminateProgress(indeterminateProgress);
    }

    @Override
    public void showFailure(String message) {
        this.delegate.showFailure(message);
    }

    @Override
    public int askOverwrite(File file) throws UserCanceledException {
        return this.delegate.askOverwrite(file);
    }

    @Override
    public int askRetry(File file) throws UserCanceledException {
        return this.delegate.askRetry(file);
    }

    @Override
    public boolean askContinue(File file) throws UserCanceledException {
        return this.delegate.askContinue(file);
    }
}

