/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.formcomponents;

import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.events.EventType;
import com.install4j.api.events.InstallerVariableEvent;
import com.install4j.api.screens.Console;
import com.install4j.runtime.beans.formcomponents.TextfieldComponent;
import com.install4j.runtime.util.Base64;
import java.io.UnsupportedEncodingException;
import java.util.Objects;
import javax.swing.JPasswordField;
import javax.swing.text.JTextComponent;

public class PasswordComponent
extends TextfieldComponent {
    private static final String ENCODING = "UTF-8";
    private boolean writeToResponseFile = false;
    private JPasswordField passwordField;
    private boolean eyeVisible = false;

    public boolean isEyeVisible() {
        return this.replaceWithTextOverride("eyeVisible", this.eyeVisible);
    }

    public void setEyeVisible(boolean eyeVisible) {
        this.eyeVisible = eyeVisible;
    }

    @Override
    protected JTextComponent createTextComponent() {
        this.passwordField = new JPasswordField();
        this.passwordField.putClientProperty("FlatLaf.style", "showRevealButton: " + this.isEyeVisible() + ";");
        this.applyTextFieldProperties(this.passwordField);
        return this.passwordField;
    }

    public boolean isWriteToResponseFile() {
        return this.replaceWithTextOverride("writeToResponseFile", this.writeToResponseFile);
    }

    public void setWriteToResponseFile(boolean writeToResponseFile) {
        this.writeToResponseFile = writeToResponseFile;
    }

    @Override
    public Class<?> getConfigurationObjectClass() {
        return JPasswordField.class;
    }

    @Override
    public void setContext(Context context) {
        super.setContext(context);
        if (context != null) {
            this.decodeVariable();
            context.addInstallerEventListener(event -> {
                if (event.getType() == EventType.VARIABLE_CHANGED && Objects.equals(((InstallerVariableEvent)event).getVariableName(), this.getEncodedVariableName())) {
                    this.decodeVariable();
                }
            });
        }
    }

    private void decodeVariable() {
        String initValue = (String)this.getInitValue(null, this.getEncodedVariableName(), String.class);
        if (initValue != null) {
            Context context = this.getContext();
            String value = this.decodeValue(initValue);
            if (value != null) {
                String variableName = this.getVariableName();
                context.registerHiddenVariable(variableName);
                context.setVariable(variableName, value);
            }
        }
    }

    @Override
    public boolean checkCompleted() {
        if (!super.checkCompleted()) {
            return false;
        }
        if (this.isWriteToResponseFile()) {
            String encodedVariableName = this.getEncodedVariableName();
            try {
                byte[] bytes = this.getValue().toString().getBytes(ENCODING);
                for (int i = 0; i < bytes.length; ++i) {
                    bytes[i] = (byte)(255 - bytes[i]);
                }
                this.getContext().setVariable(encodedVariableName, Base64.encode(bytes));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            this.getContext().registerResponseFileVariable(encodedVariableName);
        }
        return true;
    }

    private String getEncodedVariableName() {
        return this.getVariableName() + ".encoded";
    }

    @Override
    protected boolean isRegisterResponseFileVariable() {
        return false;
    }

    @Override
    protected void initText(JTextComponent textComponent) {
        String decodedValue;
        super.initText(textComponent);
        this.getContext().registerHiddenVariable(this.getVariableName());
        String initValue = (String)this.getInitValue(null, this.getEncodedVariableName(), String.class);
        if (initValue != null && (decodedValue = this.decodeValue(initValue)) != null) {
            textComponent.setText(decodedValue);
        }
    }

    private String decodeValue(String initValue) {
        try {
            byte[] bytes = Base64.decode(initValue);
            for (int i = 0; i < bytes.length; ++i) {
                bytes[i] = (byte)(255 - bytes[i]);
            }
            return new String(bytes, ENCODING);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    protected Object getValue() {
        return this.getTextComponent().getText();
    }

    @Override
    protected String askString(Console console, String oldValue, String labelText) throws UserCanceledException {
        return console.askPassword(labelText, oldValue);
    }
}

