/*
 * Decompiled with CFR 0.152.
 */
package org.pkcs11.jacknji11;

import java.nio.ByteOrder;

public class ULong {
    public static ULongSize ULONG_SIZE = ULongSize.ULONG4;

    public static byte[] ulong2b(long ... la) {
        if (la == null || la.length == 0) {
            return new byte[0];
        }
        if (ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN) {
            if (ULONG_SIZE == ULongSize.ULONG4) {
                byte[] result = new byte[la.length * 4];
                int j = result.length - 1;
                for (int i = la.length - 1; i >= 0; --i) {
                    long val = la[i];
                    result[j--] = (byte)val;
                    result[j--] = (byte)(val >>= 8);
                    result[j--] = (byte)(val >>= 8);
                    result[j--] = (byte)(val >>= 8);
                }
                return result;
            }
            byte[] result = new byte[la.length * 8];
            int j = result.length - 1;
            for (int i = la.length - 1; i >= 0; --i) {
                long val = la[i];
                result[j--] = (byte)val;
                result[j--] = (byte)(val >>= 8);
                result[j--] = (byte)(val >>= 8);
                result[j--] = (byte)(val >>= 8);
                result[j--] = (byte)(val >>= 8);
                result[j--] = (byte)(val >>= 8);
                result[j--] = (byte)(val >>= 8);
                result[j--] = (byte)(val >>= 8);
            }
            return result;
        }
        if (ULONG_SIZE == ULongSize.ULONG4) {
            byte[] result = new byte[la.length * 4];
            int j = 0;
            for (int i = 0; i < la.length; ++i) {
                long val = la[i];
                result[j++] = (byte)val;
                result[j++] = (byte)(val >>= 8);
                result[j++] = (byte)(val >>= 8);
                result[j++] = (byte)(val >>= 8);
            }
            return result;
        }
        byte[] result = new byte[la.length * 8];
        int j = 0;
        for (int i = 0; i < la.length; ++i) {
            long val = la[i];
            result[j++] = (byte)val;
            result[j++] = (byte)(val >>= 8);
            result[j++] = (byte)(val >>= 8);
            result[j++] = (byte)(val >>= 8);
            result[j++] = (byte)(val >>= 8);
            result[j++] = (byte)(val >>= 8);
            result[j++] = (byte)(val >>= 8);
            result[j++] = (byte)(val >>= 8);
        }
        return result;
    }

    public static long b2ulong(byte[] buf) {
        if (ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN) {
            if (ULONG_SIZE == ULongSize.ULONG4) {
                return (buf[0] & 0xFF) << 24 | (buf[1] & 0xFF) << 16 | (buf[2] & 0xFF) << 8 | buf[3] & 0xFF;
            }
            return (buf[0] & 0xFF) << 56 | (buf[1] & 0xFF) << 48 | (buf[2] & 0xFF) << 40 | (buf[3] & 0xFF) << 32 | (buf[4] & 0xFF) << 24 | (buf[5] & 0xFF) << 16 | (buf[6] & 0xFF) << 8 | buf[7] & 0xFF;
        }
        if (ULONG_SIZE == ULongSize.ULONG4) {
            return (buf[3] & 0xFF) << 24 | (buf[2] & 0xFF) << 16 | (buf[1] & 0xFF) << 8 | buf[0] & 0xFF;
        }
        return (buf[7] & 0xFF) << 56 | (buf[6] & 0xFF) << 48 | (buf[5] & 0xFF) << 40 | (buf[4] & 0xFF) << 32 | (buf[3] & 0xFF) << 24 | (buf[2] & 0xFF) << 16 | (buf[1] & 0xFF) << 8 | buf[0] & 0xFF;
    }

    public static enum ULongSize {
        ULONG4(4),
        ULONG8(8);

        private int size;

        private ULongSize(int size) {
            this.size = size;
        }

        public int size() {
            return this.size;
        }
    }
}

