/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.applications;

import com.install4j.api.beaninfo.BeanValidationException;
import com.install4j.api.beaninfo.FilePropertyDescriptor;
import com.install4j.api.beaninfo.FileSelectionMode;
import com.install4j.api.beaninfo.Install4JPropertyDescriptor;
import com.install4j.api.beans.Bean;
import com.install4j.runtime.beans.applications.ApplicationBeanInfo;
import com.install4j.runtime.beans.applications.ApplicationWithPath;
import com.install4j.runtime.beans.common.BeanInfoUtil;
import com.install4j.runtime.beans.common.CategoryUtil;

public abstract class ApplicationWithPathBeanInfo
extends ApplicationBeanInfo {
    public static final String PROPERTY_EXECUTABLE_NAME = "executableName";
    public static final String PROPERTY_EXECUTABLE_DIRECTORY = "executableDirectory";
    private static final String PROPERTY_UNIX_MODE = "unixMode";
    private static final String PROPERTY_USE_CUSTOM_MACOS_EXECUTABLE_NAME = "useCustomMacosExecutableName";
    private static final String PROPERTY_CUSTOM_MACOS_EXECUTABLE_NAME = "customMacosExecutableName";

    protected ApplicationWithPathBeanInfo(String string, String string2, Class<? extends ApplicationWithPath> clazz, boolean bl2) {
        super(string, string2, clazz, false);
        this.addPropertyDescriptor(this.executableProperty(Install4JPropertyDescriptor.create((String)PROPERTY_EXECUTABLE_NAME, (Class)this.getBeanClass(), (String)"Executable name", (String)("The name of the executable for the " + this.getApplicationName() + ". Please enter a name without any path components and without a file extension."), (String)"noInstallerVariables")));
        this.addPropertyDescriptor(this.executableProperty((Install4JPropertyDescriptor)FilePropertyDescriptor.create((String)PROPERTY_EXECUTABLE_DIRECTORY, (Class)this.getBeanClass(), (String)"Executable directory", (String)("The directory to which the executable of the " + this.getApplicationName() + " will be written. If empty, it will be placed in the <tt>.install4j</tt> runtime directory."), (FileSelectionMode)FileSelectionMode.DIRECTORIES_ONLY, (String)"noInstallerVariables")).setEmptyMessage("[Runtime directory]"));
        this.addPropertyDescriptor(this.categoryUnix(Install4JPropertyDescriptor.create((String)PROPERTY_UNIX_MODE, (Class)this.getBeanClass(), (String)"Unix mode", (String)("The executable mode for the " + this.getApplicationName() + " on Unix."))));
        this.addPropertyDescriptor(CategoryUtil.categoryMacos(Install4JPropertyDescriptor.create((String)PROPERTY_USE_CUSTOM_MACOS_EXECUTABLE_NAME, (Class)this.getBeanClass(), (String)"Use custom application bundle name", (String)"If selected, a different application bundle name is used on macOS. Executable names on macOS are localizable. Otherwise, the value of the \"Executable name\" property is used for the application bundle name.")));
        this.addPropertyDescriptor(BeanInfoUtil.reparent(PROPERTY_USE_CUSTOM_MACOS_EXECUTABLE_NAME, Install4JPropertyDescriptor.create((String)PROPERTY_CUSTOM_MACOS_EXECUTABLE_NAME, (Class)this.getBeanClass(), (String)"Custom application bundle name", (String)"The application bundle name to be used for macOS media files. Bundle names on macOS are shown in the Finder and are localizable. For example, the executable name could be set to <tt>${i18n:myLauncherName(${compiler:sys.fullName})}</tt> where <tt>myLauncherName</tt> is an i18n message with value \"Launcher for {0}\".", (String)"noInstallerVariables")));
        if (bl2) {
            this.addDescriptors();
        }
    }

    private String getApplicationName() {
        return this.getBeanDescriptor().getDisplayName().toLowerCase();
    }

    @Override
    public void validateBean(Bean bean) throws BeanValidationException {
        super.validateBean(bean);
        this.validateExecutableProperties(bean);
        this.checkNotEmpty(PROPERTY_UNIX_MODE, bean);
        ApplicationWithPath applicationWithPath = (ApplicationWithPath)bean;
        if (applicationWithPath.getUnixMode().trim().length() != 3) {
            throw new BeanValidationException("The unix mode must consist of 3 octal digits.", PROPERTY_UNIX_MODE);
        }
        if (applicationWithPath.isUseCustomMacosExecutableName()) {
            this.checkNotEmpty(PROPERTY_CUSTOM_MACOS_EXECUTABLE_NAME, bean);
        }
    }

    protected void validateExecutableProperties(Bean bean) throws BeanValidationException {
        this.checkNotEmpty(PROPERTY_EXECUTABLE_NAME, bean);
    }

    protected Install4JPropertyDescriptor executableProperty(Install4JPropertyDescriptor install4JPropertyDescriptor) {
        return this.categoryExecutable(install4JPropertyDescriptor);
    }

    protected Install4JPropertyDescriptor categoryExecutable(Install4JPropertyDescriptor install4JPropertyDescriptor) {
        install4JPropertyDescriptor.setPropertyCategory("Executable");
        return install4JPropertyDescriptor;
    }
}

