/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.misc;

import com.install4j.api.beaninfo.ActionElevationType;
import com.install4j.api.beaninfo.BeanValidationException;
import com.install4j.api.beaninfo.BeanValidator;
import com.install4j.api.beaninfo.Install4JPropertyDescriptor;
import com.install4j.api.beans.Bean;
import com.install4j.runtime.beans.BeanInfo;
import com.install4j.runtime.beans.actions.SystemActionBeanInfo;
import com.install4j.runtime.beans.actions.misc.ModifyEnvironmentVariableAction;
import com.install4j.runtime.beans.actions.misc.ModifyStringType;
import com.install4j.runtime.beans.common.CategoryUtil;

@BeanInfo
public class ModifyEnvironmentVariableActionBeanInfo
extends SystemActionBeanInfo
implements BeanValidator {
    private static final String PROPERTY_TYPE = "type";
    private static final String PROPERTY_VARIABLE_NAME = "variableName";
    private static final String PROPERTY_VALUE = "value";
    private static final String PROPERTY_USER_SPECIFIC = "userSpecific";
    private static final String PROPERTY_REVERT_ON_UNINSTALLATION = "revertOnUninstallation";
    private static final String PROPERTY_REVERT_ONLY_IF_NOT_MODIFIED = "revertOnlyIfNotModified";

    public ModifyEnvironmentVariableActionBeanInfo() {
        super("Modify an environment variable on Windows", "Sets, appends to, prepends to or removes an environment variable on Windows. This action can be automatically reverted by the 'Uninstall files' action.", "Miscellaneous", true, false, null, ModifyEnvironmentVariableAction.class);
        this.setDefaultActionElevationType(ActionElevationType.ELEVATE, true);
        this.addPropertyDescriptor(Install4JPropertyDescriptor.create((String)PROPERTY_TYPE, (Class)this.getBeanClass(), (String)"Modification type", (String)"Modification type"));
        this.addPropertyDescriptor(Install4JPropertyDescriptor.create((String)PROPERTY_VARIABLE_NAME, (Class)this.getBeanClass(), (String)"Variable name", (String)"The name of the variable that should be modified."));
        this.addPropertyDescriptor(Install4JPropertyDescriptor.create((String)PROPERTY_VALUE, (Class)this.getBeanClass(), (String)"Value", (String)"The value to be set, appended or prepended.").setVisibilityDiscriminator((bean, object) -> ((ModifyEnvironmentVariableAction)bean).getType() != ModifyStringType.REMOVE));
        this.addPropertyDescriptor(Install4JPropertyDescriptor.create((String)PROPERTY_USER_SPECIFIC, (Class)this.getBeanClass(), (String)"User specific", (String)"If the variable is user-specific or system-wide."));
        this.addPropertyDescriptor(CategoryUtil.categoryUninstallation(Install4JPropertyDescriptor.create((String)PROPERTY_REVERT_ON_UNINSTALLATION, (Class)this.getBeanClass(), (String)"Revert on uninstallation", (String)"Revert the change automatically on uninstallation if this action is used for an installer.")));
        Install4JPropertyDescriptor install4JPropertyDescriptor = Install4JPropertyDescriptor.create((String)PROPERTY_REVERT_ONLY_IF_NOT_MODIFIED, (Class)this.getBeanClass(), (String)"Only if not modified", (String)"Revert the change only if the environment variable hss not been modified in the meantime. This is mainly useful for the 'set' modification type.");
        install4JPropertyDescriptor.setParentProperty(PROPERTY_REVERT_ON_UNINSTALLATION);
        this.addPropertyDescriptor(install4JPropertyDescriptor);
    }

    public void validateBean(Bean bean) throws BeanValidationException {
        this.checkNotEmpty(PROPERTY_VARIABLE_NAME, bean);
    }
}

