/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.desktop;

import com.install4j.api.beaninfo.ActionElevationType;
import com.install4j.api.beaninfo.BeanValidationException;
import com.install4j.api.beaninfo.BeanValidator;
import com.install4j.api.beaninfo.Install4JPropertyDescriptor;
import com.install4j.api.beans.Bean;
import com.install4j.c.d.e.e.l;
import com.install4j.config.h;
import com.install4j.runtime.beans.BeanInfo;
import com.install4j.runtime.beans.actions.SystemActionBeanInfo;
import com.install4j.runtime.beans.actions.desktop.CreateFileAssociationAction;
import com.install4j.runtime.beans.common.CategoryUtil;
import com.install4j.runtime.beans.screens.FileAssociationsScreen;
import java.util.Objects;

@BeanInfo
public class CreateFileAssociationActionBeanInfo
extends SystemActionBeanInfo
implements BeanValidator {
    public static final String NAME = "Create a file association";
    private static final String MACOS_NOTICE = "For macOS, file associations have to be defined on the \"Executable info->macOS options\" step of the launcher wizard.";
    private static final String PROPERTY_EXTENSION = "extension";
    private static final String PROPERTY_DESCRIPTION = "description";
    public static final String PROPERTY_LAUNCHER_ID = "launcherId";
    private static final String PROPERTY_SELECTED = "selected";
    private static final String PROPERTY_WINDOWS = "windows";
    private static final String PROPERTY_WINDOWS_ICON_FILE = "windowsIconFile";
    private static final String PROPERTY_WIN_ADDITIONAL_PARAMETERS = "winAdditionalParameters";
    private static final String PROPERTY_UNIX = "unix";
    private static final String PROPERTY_UNIX_MIME_TYPE = "unixMimeType";

    public CreateFileAssociationActionBeanInfo() {
        super(NAME, "Create an association between a file extension and a launcher, so that the launcher is invoked when the user double-clicks a file with the selected extension. <p>If the application has not yet been started, the arguments to the main method will contain the file name. Subsequent invocations can be intercepted with the <tt>com.install4j.api.launcher.StartupNotification</tt> class. This action will be automatically reverted by the 'Uninstall files' action.</p><p>For macOS, file associations have to be defined on the \"Executable info->macOS options\" step of the launcher wizard.</p>", "Desktop integration", true, true, null, CreateFileAssociationAction.class);
        this.setDefaultActionElevationType(ActionElevationType.ELEVATE, true);
        this.addPropertyDescriptor(CategoryUtil.categoryGeneral(Install4JPropertyDescriptor.create((String)PROPERTY_EXTENSION, (Class)this.getBeanClass(), (String)"File extension", (String)"The file extension for which the file association should be created. Must not include the leading dot. Multiple extensions can be separated with a comma.")));
        this.addPropertyDescriptor(CategoryUtil.categoryGeneral(Install4JPropertyDescriptor.create((String)PROPERTY_DESCRIPTION, (Class)this.getBeanClass(), (String)"Description", (String)"A description that is presented to the user as the text next to the corresponding checkbox in the \"File associations\" screen.")));
        this.addPropertyDescriptor(CategoryUtil.categoryGeneral(Install4JPropertyDescriptor.create((String)PROPERTY_LAUNCHER_ID, (Class)this.getBeanClass(), (String)"Launcher", (String)"The launcher that will be invoked when the file association is invoked by the user.", (String)"nonServiceLauncher")));
        this.addPropertyDescriptor(CategoryUtil.categoryGeneral(Install4JPropertyDescriptor.create((String)PROPERTY_SELECTED, (Class)this.getBeanClass(), (String)"Selected", (String)"If the file association is selected in the \"File associations\" screen.")));
        this.addPropertyDescriptor(CategoryUtil.categoryWindows(Install4JPropertyDescriptor.create((String)PROPERTY_WINDOWS, (Class)this.getBeanClass(), (String)"Execute on Windows", (String)"If the file association should be performed on Windows.")));
        this.addPropertyDescriptor(CategoryUtil.categoryWindows(Install4JPropertyDescriptor.create((String)PROPERTY_WINDOWS_ICON_FILE, (Class)this.getBeanClass(), (String)"Icon file for Windows", (String)"An optional icon file (*.ico) for the file association on Windows. If empty, a default icon will be used.").setEmptyMessage("[Default]")));
        this.addPropertyDescriptor(CategoryUtil.categoryWindows(Install4JPropertyDescriptor.create((String)PROPERTY_WIN_ADDITIONAL_PARAMETERS, (Class)this.getBeanClass(), (String)"Additional parameters", (String)"Optional additional parameters that will be passed to the executable in front of the file to be opened.")));
        this.addPropertyDescriptor(CategoryUtil.categoryUnix(Install4JPropertyDescriptor.create((String)PROPERTY_UNIX, (Class)this.getBeanClass(), (String)"Execute on Linux/Unix", (String)"If the file association should be performed on Linux/Unix. A MIME type must be specified in that case.")));
        this.addPropertyDescriptor(CategoryUtil.categoryUnix(Install4JPropertyDescriptor.create((String)PROPERTY_UNIX_MIME_TYPE, (Class)this.getBeanClass(), (String)"MIME type", (String)"The MIME type to be used for the Unix file association.")));
        this.addPropertyDescriptor(CategoryUtil.categoryUnix(Install4JPropertyDescriptor.create((String)"unixIconFile", (Class)this.getBeanClass(), (String)"Icon file for Linux/Unix", (String)"An optional icon file (*.png) for the file association on Linux/Unix. If empty, a default icon will be used. A 64x64 icon is recommended.").setEmptyMessage("[Default]")));
        this.setAssociatedScreen(FileAssociationsScreen.class.getName());
        if (h.O().ac()) {
            this.setNoticePanel(new l(MACOS_NOTICE){

                @Override
                protected boolean isHidden() {
                    return h.O().Y();
                }

                @Override
                protected void saveHidden() {
                    h.O().m(false);
                }
            });
        }
    }

    public void validateBean(Bean bean) throws BeanValidationException {
        this.checkNotEmpty(PROPERTY_EXTENSION, bean);
        this.checkNotEmpty(PROPERTY_DESCRIPTION, bean);
        this.checkNotEmpty(PROPERTY_LAUNCHER_ID, bean);
        if (Objects.equals(this.getPropertyValue(this.findPropertyDescriptor(PROPERTY_UNIX), bean), Boolean.TRUE)) {
            this.checkNotEmpty(PROPERTY_UNIX_MIME_TYPE, bean);
        }
    }
}

