/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.structures.constants;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gjt.jclasslib.io.DataInput;
import org.gjt.jclasslib.io.DataOutput;
import org.gjt.jclasslib.structures.AbstractConstant;
import org.gjt.jclasslib.structures.ClassFile;
import org.gjt.jclasslib.structures.ConstantType;
import org.gjt.jclasslib.structures.constants.ConstantUtf8Info;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001eH\u0014J\u0013\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$H\u0096\u0002J\b\u0010%\u001a\u00020\u0007H\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u001f\u001a\u00020\u00158TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0017\u00a8\u0006&"}, d2={"Lorg/gjt/jclasslib/structures/constants/ConstantStringInfo;", "Lorg/gjt/jclasslib/structures/AbstractConstant;", "classFile", "Lorg/gjt/jclasslib/structures/ClassFile;", "<init>", "(Lorg/gjt/jclasslib/structures/ClassFile;)V", "stringIndex", "", "getStringIndex", "()I", "setStringIndex", "(I)V", "utf8Constant", "Lorg/gjt/jclasslib/structures/constants/ConstantUtf8Info;", "getUtf8Constant", "()Lorg/gjt/jclasslib/structures/constants/ConstantUtf8Info;", "constantType", "Lorg/gjt/jclasslib/structures/ConstantType;", "getConstantType", "()Lorg/gjt/jclasslib/structures/ConstantType;", "verbose", "", "getVerbose", "()Ljava/lang/String;", "readData", "", "input", "Lorg/gjt/jclasslib/io/DataInput;", "writeData", "output", "Lorg/gjt/jclasslib/io/DataOutput;", "debugInfo", "getDebugInfo", "equals", "", "other", "", "hashCode", "data"})
public final class ConstantStringInfo
extends AbstractConstant {
    private int stringIndex;

    public ConstantStringInfo(@NotNull ClassFile classFile) {
        Intrinsics.checkNotNullParameter((Object)classFile, (String)"classFile");
        super(classFile);
    }

    public final int getStringIndex() {
        return this.stringIndex;
    }

    public final void setStringIndex(int n) {
        this.stringIndex = n;
    }

    @NotNull
    public final ConstantUtf8Info getUtf8Constant() {
        return this.getClassFile().getConstantPoolUtf8Entry(this.stringIndex);
    }

    @Override
    @NotNull
    public ConstantType getConstantType() {
        return ConstantType.STRING;
    }

    @Override
    @NotNull
    public String getVerbose() {
        return this.getUtf8Constant().getString();
    }

    @Override
    protected void readData(@NotNull DataInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.stringIndex = input.readUnsignedShort();
    }

    @Override
    protected void writeData(@NotNull DataOutput output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        output.writeByte(ConstantType.STRING.getTag());
        output.writeShort(this.stringIndex);
    }

    @Override
    @NotNull
    protected String getDebugInfo() {
        return "with stringIndex " + this.stringIndex;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (!(other instanceof ConstantStringInfo)) {
            return false;
        }
        return super.equals(other) && ((ConstantStringInfo)other).stringIndex == this.stringIndex;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.stringIndex;
    }
}

