/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.aws.lw.client;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public final class ResponseInputStream
extends InputStream {
    private final Closeable closeable;
    private final int statusCode;
    private final Map<String, List<String>> headers;
    private final InputStream content;

    public ResponseInputStream(HttpURLConnection connection, int statusCode, Map<String, List<String>> headers, InputStream content) {
        this(() -> connection.disconnect(), statusCode, headers, content);
    }

    public ResponseInputStream(Closeable closeable, int statusCode, Map<String, List<String>> headers, InputStream content) {
        this.closeable = closeable;
        this.statusCode = statusCode;
        this.headers = headers;
        this.content = content;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.content.read(b, off, len);
    }

    @Override
    public int read() throws IOException {
        return this.content.read();
    }

    @Override
    public void close() throws IOException {
        try {
            this.content.close();
        }
        finally {
            this.closeable.close();
        }
    }

    public int statusCode() {
        return this.statusCode;
    }

    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public Optional<String> header(String name) {
        for (String key : this.headers.keySet()) {
            if (!name.equalsIgnoreCase(key)) continue;
            return Optional.of(this.headers.get(key).stream().collect(Collectors.joining(",")));
        }
        return Optional.empty();
    }
}

