/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.aws.lw.client;

import com.github.davidmoten.aws.lw.client.internal.CredentialsImpl;
import com.github.davidmoten.aws.lw.client.internal.Environment;
import java.util.Optional;

public interface Credentials {
    public String accessKey();

    public String secretKey();

    public Optional<String> sessionToken();

    public static Credentials of(String accessKey, String secretKey) {
        return new CredentialsImpl(accessKey, secretKey, Optional.empty());
    }

    public static Credentials of(String accessKey, String secretKey, String sessionToken) {
        return new CredentialsImpl(accessKey, secretKey, Optional.of(sessionToken));
    }

    public static Credentials fromEnvironment() {
        return Environment.instance().credentials();
    }

    public static Credentials fromSystemProperties() {
        return new CredentialsImpl(System.getProperty("aws.accessKeyId"), System.getProperty("aws.secretKey"), Optional.empty());
    }
}

