/*
 * Decompiled with CFR 0.152.
 */
package com.install4j;

import com.install4j.BaseProjectTask;
import com.install4j.buildtools.BaseProjectTaskConfig;
import com.install4j.buildtools.Install4jTaskConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.BuildException;

public class Install4JTask
extends BaseProjectTask {
    private boolean faster = false;
    private boolean disableSigning = false;
    private boolean disableBundling = false;
    private boolean buildSelected = false;
    private String buildIds = null;
    private String mediaTypes = null;
    private boolean incremental = false;
    private boolean debug = false;
    private boolean preserve = false;
    private String winKeystorePassword = null;
    private String macKeystorePassword = null;
    private boolean disableNotarization = false;
    private List<Variable> variables = new ArrayList<Variable>();
    private List<VariableFile> variableFiles = new ArrayList<VariableFile>();
    private File variableFile = null;
    private Install4jTaskConfig.Provider provider;

    public Install4JTask() {
        this(null);
    }

    public Install4JTask(Install4jTaskConfig.Provider provider) {
        this.provider = provider;
    }

    public void setPreserve(boolean preserve) {
        this.preserve = preserve;
    }

    public void setFaster(boolean faster) {
        this.faster = faster;
    }

    public void setDisableSigning(boolean disableSigning) {
        this.disableSigning = disableSigning;
    }

    public void setDisableBundling(boolean disableBundling) {
        this.disableBundling = disableBundling;
    }

    public void setBuildSelected(boolean buildSelected) {
        this.buildSelected = buildSelected;
    }

    public void addConfiguredVariable(Variable variable) {
        variable.check();
        this.variables.add(variable);
    }

    public void addConfiguredVariableFile(VariableFile variableFile) {
        this.variableFiles.add(variableFile);
    }

    @Deprecated
    public void setVariableFile(File variableFile) {
        this.variableFile = variableFile;
    }

    public void setBuildIds(String buildIds) {
        this.buildIds = buildIds;
    }

    public void setMediaTypes(String mediaTypes) {
        this.mediaTypes = mediaTypes;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setIncremental(boolean incremental) {
        this.incremental = incremental;
    }

    public void setWinKeystorePassword(String winKeystorePassword) {
        this.winKeystorePassword = winKeystorePassword;
    }

    public void setDisableNotarization(boolean disableNotarization) {
        this.disableNotarization = disableNotarization;
    }

    public void setMacKeystorePassword(String macKeystorePassword) {
        this.macKeystorePassword = macKeystorePassword;
    }

    @Override
    protected String getApplicationName() {
        return "install4j";
    }

    @Override
    protected BaseProjectTaskConfig createTaskConfig(File projectFile, boolean verbose, boolean quiet, boolean test, boolean failOnWarning, String release, File destination, String license) {
        if (this.provider != null) {
            return this.provider.createTaskConfig();
        }
        return new Install4jTaskConfig(this.getInstallDir(), this.getAutoProvisioningCacheDir(), this.getVmParameters(), projectFile, verbose, quiet, test, failOnWarning, release, destination, license, this.faster, this.disableSigning, this.disableBundling, this.buildSelected, this.split(this.buildIds, ","), this.split(this.mediaTypes, ","), this.incremental, this.debug, this.preserve, this.winKeystorePassword, this.macKeystorePassword, this.disableNotarization, this.getVariables(), this.getVariableFiles());
    }

    private List<File> getVariableFiles() {
        ArrayList<File> files = new ArrayList<File>();
        if (this.variableFile != null) {
            files.add(this.variableFile);
        }
        for (VariableFile variableFile : this.variableFiles) {
            files.add(variableFile.file);
        }
        return files;
    }

    private Map<String, String> getVariables() {
        LinkedHashMap<String, String> variablesMap = new LinkedHashMap<String, String>();
        for (Variable variable : this.variables) {
            variablesMap.put(variable.getQualifiedName(), variable.value);
        }
        return variablesMap;
    }

    public static class VariableFile {
        private File file;

        public void setFile(File file) {
            this.file = file;
        }
    }

    public static class Variable {
        private String name;
        private String value;
        private String mediaFileId;

        public void setName(String name) {
            this.name = name;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public void setMediaFileId(String mediaFileId) {
            this.mediaFileId = mediaFileId;
        }

        private String getQualifiedName() {
            if (this.mediaFileId != null) {
                return this.mediaFileId + ":" + this.name;
            }
            return this.name;
        }

        private void check() throws BuildException {
            if (this.name == null) {
                throw new BuildException("The property \"name\" of all variable elements must be set.");
            }
            this.name = this.name.trim();
            if (this.name.isEmpty()) {
                throw new BuildException("The property \"name\" of all variable elements must not be empty.");
            }
            if (this.value == null) {
                throw new BuildException("The property \"value\" of all variable elements must be set.");
            }
        }
    }
}

