package com.install4j.api.windows;

import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.platform.win32.Registry;

/**
 * Enumeration class for the different views of the Microsoft Windows registry on 64-bit systems.
 * <p>
 * You can find more information <a href="https://msdn.microsoft.com/en-us/library/aa384253%28v=VS.85%29.aspx">here</a>.

 * @author ej-technologies GmbH
 */
public enum RegistryView {

    /**
     * Use the 32-bit view for a 32-bit, and the 64-bit view for a 64-bit process.
     */
    DEFAULT(Registry.WOW64_DEFAULT, "Default"),

    /**
     * Always use the 32-bit view stored in the special Wow6432Node key.
     */
    BIT32(Registry.WOW64_32KEY, "32-bit view"),

    /**
     * Always use the 64-bit view.
     */
    BIT64(Registry.WOW64_64KEY, "64-bit view");

    private final transient int type;
    private final transient String name;

    RegistryView(int type, String name) {
        this.type = type;
        this.name = name;
    }

    int getUsedType() {
        if (InstallerUtil.isWindows()) {
            return type;
        } else {
            return DEFAULT.type;
        }
    }

    @Override
    public String toString() {
        return name;
    }

}