package com.install4j.api.formcomponents;

/**
 * Type of a layout group.
 * This enumeration is returned by {@link LayoutGroup#getGroupType()}.
 */
public enum GroupType {

    /**
     * Vertical layout group
     */
    VERTICAL("Vertical"),

    /**
     * Horizontal layout group
     */
    HORIZONTAL("Horizontal"),

    /**
     * Tabbed pane
     */
    TABBED_PANE("Tabbed pane"),

    /**
     * Tabbed pane
     */
    SINGLE_TAB("Single tab");

    private final String verbose;

    GroupType(String verbose) {
        this.verbose = verbose;
    }

    @Override
    public String toString() {
        return verbose;
    }
}
