package com.install4j.api.beans;

/**
 * Interceptor interface for beans to modify property values that are written to the installer log file.
 * If you wish to modify logged property values, you have to make your bean implement this interface.
 * This can be necessary for security reasons, for example, if a property value contains a variable that expands
 * to a password.
 *
 * @author ej-technologies GmbH
 */
public interface PropertyLoggingInterceptor {
    /**
     * Replace the value of the property for logging purposes. The returned value will not be used in any other context.
     * @param propertyName the name of the property that is being logged.
     * @param propertyValue the value of the property that would be logged by default.
     * @return the value that will be logged.
     */
    Object getLogValueForProperty(String propertyName, Object propertyValue);
}
