package com.install4j.api.beaninfo;

import com.install4j.api.screens.Screen;

/**
 * Base class for screen bean infos.
 * <p>Using this class is not strictly required. In principle, you could also set values for the {@code ATTRIBUTE_*} constants in the bean descriptor
 * of an unrelated bean info class.
 */
public class ScreenBeanInfo extends Install4JBeanInfo {

    /**
     * @see #setDefaultQuitAfterScreen(boolean)
     */
    public static final String ATTRIBUTE_DEFAULT_QUIT_AFTER_SCREEN = "defaultQuitAfterScreen";

    /**
     * @deprecated no longer used
     */
    @Deprecated
    public static final String ATTRIBUTE_FORM_COMPONENT_CUSTOMIZER_PLACEMENT = "formComponentCustomizerPlacement";

    /**
     * @see #setAssociatedAction(String, String)
     */
    public static final String ATTRIBUTE_ASSOCIATED_ACTION = "associatedAction";

    /**
     * @see #setAssociatedAction(String, String, boolean, String, ActionInitializer)
     */
    public static final String ATTRIBUTE_ASSOCIATED_ACTION_TARGET_SCREEN = "associatedActionTargetScreen";

    /**
     * @see #setAssociatedAction(String, String, boolean, String, ActionInitializer)
     */
    public static final String ATTRIBUTE_ASSOCIATED_ACTION_INSERT_FIRST = "associatedActionInsertFirst";

    /**
     * @see #setAssociatedAction(String, String, boolean, String, ActionInitializer)
     */
    public static final String ATTRIBUTE_ASSOCIATED_ACTION_INITIALIZER = "associatedActionInitializer";

    /**
     * @see #setAssociatedAction(String, String, boolean, String, ActionInitializer)
     */
    public static final String ATTRIBUTE_ASSOCIATED_ACTION_CONDITION_EXPRESSION = "associatedActionConditionExpression";

    /**
     * @see #setDefaultStyleName(String)
     */
    public static final String ATTRIBUTE_DEFAULT_STYLE_NAME = "defaultStyleName";

    /**
     * @see #setDefaultPreActivationScript(String)
     */
    public static final String ATTRIBUTE_DEFAULT_PRE_ACTIVATION_SCRIPT = "defaultPreActivationScript";

    /**
     * @see #setDefaultPostActivationScript(String)
     */
    public static final String ATTRIBUTE_DEFAULT_POST_ACTIVATION_SCRIPT = "defaultPostActivationScript";

    /**
     * Same as {@link Install4JBeanInfo#Install4JBeanInfo(String, String, String, boolean, boolean, Integer, Class, Class)}.
     */
    public ScreenBeanInfo(String displayName, String shortDescription, String category, boolean multipleInstancesSupported, boolean installedFilesRequired, Integer sortKey, Class<? extends Screen> beanClass, Class customizerClass) {
        super(displayName, shortDescription, category, multipleInstancesSupported, installedFilesRequired, sortKey, beanClass, customizerClass);
    }

    /**
     * Same as {@link Install4JBeanInfo#Install4JBeanInfo(String, String, String, boolean, boolean, Integer, Class)}.
     */
    public ScreenBeanInfo(String displayName, String shortDescription, String category, boolean multipleInstancesSupported, boolean installedFilesRequired, Integer sortKey, Class<? extends Screen> beanClass) {
        super(displayName, shortDescription, category, multipleInstancesSupported, installedFilesRequired, sortKey, beanClass);
    }

    /**
     * Configures the default value for the "Quit after screen" property of the screen.
     * @param defaultQuitAfterScreen the default value
     */
    public void setDefaultQuitAfterScreen(boolean defaultQuitAfterScreen) {
        getBeanDescriptor().setValue(ATTRIBUTE_DEFAULT_QUIT_AFTER_SCREEN, defaultQuitAfterScreen);
    }

    /**
     * @deprecated no longer used
     */
    @SuppressWarnings("unused")
    @Deprecated
    public void setFormComponentCustomizerPlacement(CustomizerPlacement customizerPlacement) {
    }

    /**
     * Same as {@link #setAssociatedAction(String, String, boolean, String, ActionInitializer)} with first set to {@code false},
     * conditionExpression set to {@code null} and actionInitializer set to {@code null}.
     */
    public void setAssociatedAction(String actionClassName, String targetScreenClassName) {
        setAssociatedAction(actionClassName, targetScreenClassName, false, null, null);
    }

    /**
     * Configures an associated action. If set, and the user adds the action, the install4j GUI checks if
     * an instance of the specified action is present in the list of configured actions on any screen. If not,
     * it will remind the user to add such an action or propose to add the action immediately, depending on whether
     * {@code targetScreenClassName} is {@code null}.
     *
     * @param actionClassName       the class of the associated action
     * @param targetScreenClassName the target screen. If non-null, the install4j GUI will propose to add the
     *                              associated action to the target screen if it cannot already be found on any screen.
     * @param addFirst              If targetScreenClassName is non-null, and the action is inserted, it will be inserted as the first action
     * @param actionInitializer     an initializer that configures the added action
     */
    public void setAssociatedAction(String actionClassName, String targetScreenClassName, boolean addFirst, String conditionExpression, ActionInitializer actionInitializer) {
        if (actionClassName != null) {
            getBeanDescriptor().setValue(ATTRIBUTE_ASSOCIATED_ACTION, actionClassName);
        }
        if (targetScreenClassName!= null) {
            getBeanDescriptor().setValue(ATTRIBUTE_ASSOCIATED_ACTION_TARGET_SCREEN, targetScreenClassName);
            getBeanDescriptor().setValue(ATTRIBUTE_ASSOCIATED_ACTION_INSERT_FIRST, addFirst);
            if (actionInitializer != null) {
                getBeanDescriptor().setValue(ATTRIBUTE_ASSOCIATED_ACTION_INITIALIZER, actionInitializer);
            }
            if (conditionExpression != null) {
                getBeanDescriptor().setValue(ATTRIBUTE_ASSOCIATED_ACTION_CONDITION_EXPRESSION, conditionExpression);
            }
        }
    }

    /**
     * Sets a default screen style name. If set, the install4j GUI checks if a style with the corresponding name is
     * available and sets that screen style for the screen.
     * @param defaultStyleName the default screen style name
     */
    public void setDefaultStyleName(String defaultStyleName) {
        if (defaultStyleName != null) {
            getBeanDescriptor().setValue(ATTRIBUTE_DEFAULT_STYLE_NAME, defaultStyleName);
        }
    }

    /**
     * Configures the default value for the "Pre-activation script" property of the bean.
     * @param defaultPreActivationScript the default value
     * @see #ATTRIBUTE_DEFAULT_PRE_ACTIVATION_SCRIPT
     */
    public void setDefaultPreActivationScript(String defaultPreActivationScript) {
        getBeanDescriptor().setValue(ATTRIBUTE_DEFAULT_PRE_ACTIVATION_SCRIPT, defaultPreActivationScript);
    }

    /**
     * Configures the default value for the "Post-activation script" property of the bean.
     * @param defaultPostActivationScript the default value
     * @see #ATTRIBUTE_DEFAULT_POST_ACTIVATION_SCRIPT
     */
    public void setDefaultPostActivationScript(String defaultPostActivationScript) {
        getBeanDescriptor().setValue(ATTRIBUTE_DEFAULT_POST_ACTIVATION_SCRIPT, defaultPostActivationScript);
    }

}
