package com.install4j.api.beaninfo;

import javax.swing.*;

/**
 * Entry in an enumeration defined by {@link EnumerationMapper}.
 * An enumeration map entry maps a verbose description to an arbitrary object.
 * For primitive enumerated values, an instance of the corresponding wrapper class can be used for the object property.
 */
public class EnumerationMapEntry {
    
    private String name;
    private Object object;
    private Icon icon;

    /**
     * Construct a map entry.
     * @param name the name
     * @param object the object
     */
    public EnumerationMapEntry(String name, Object object) {
        this(name, object, null);
    }

    /**
     * Construct a map entry.
     * @param name the name
     * @param object the object
     * @param icon the icon to be displayed in the drop-down list in the IDE, may be {@code null}
     */
    public EnumerationMapEntry(String name, Object object, Icon icon) {
        this.name = name;
        this.object = object;
        this.icon = icon;
    }

    /**
     * Get the name of the map entry. This name is displayed in the install4j GUI.
     * @return the name
     */
    public String getName() {
        return name;
    }

    /**
     * Get the object mapped to the specified name.
     * @return the object
     */
    public Object getObject() {
        return object;
    }

    /**
     * Get the icon that is to be displayed in the drop-down list in the IDE.
     * @return the icon or {@code null} if no icon is defined
     */
    public Icon getIcon() {
        return icon;
    }
}
