package com.install4j.api.actions;

import java.util.Properties;

/**
 * If you write an installation action that wants to be automatically invoked in the uninstaller to
 * revert its changes, you can additionally implement this interface. The additional
 * methods of this interface give you access to a persistent store that can be used at installation time
 * to save information about any performed changes. At uninstallation time, you can use the persistent store to
 * load this information again. Each instance of an action has a separate persistent store.
 * <p>
 * Auto-uninstall actions have their {@code uninstall} method invoked by the "Uninstall files" action
 * before any files are uninstalled and in the reverse order in which they were invoked in the installer.
 * If no "Uninstall files" action is present in the uninstaller, the {@code uninstall} method will not
 * be called.
 * </p>
 * <p>
 * Note: If you add an auto-uninstall action to the uninstaller, its {@code AutoUninstallAction} interface
 * will be ignored.
 * </p>

 * @author ej-technologies GmbH
 */
public interface AutoUninstallAction extends UninstallAction {
    /**
     * The framework invokes this method in the installer just before the installer exits to get the persistent properties
     * of the installation action.
     * @return the persistent properties
     */
    Properties getPersistentProperties();

    /**
     * The framework invokes this method in the uninstaller at the beginning of the "Uninstall files" action to restore the persistent
     * properties that were saved in the installer.
     * @param properties the persistent properties
     */
    void setPersistentProperties(Properties properties);
}
