/*
 * Decompiled with CFR 0.152.
 */
package org.pkcs11.jacknji11;

import java.util.ArrayList;
import org.pkcs11.jacknji11.AttributeLengthStrategy;
import org.pkcs11.jacknji11.CKA;
import org.pkcs11.jacknji11.CKRException;
import org.pkcs11.jacknji11.Cryptoki;

class GetAttributeProcess {
    private final Cryptoki cryptoki;
    private final long session;
    private final long object;
    private final Entry[] entries;
    private boolean maxLengthUsedInLastQuery;
    private final boolean batchMode;

    GetAttributeProcess(Cryptoki cryptoki, long session, long object, AttributeLengthStrategy attributeLengthStrategy, boolean batchMode, long ... types) {
        this.cryptoki = cryptoki;
        this.session = session;
        this.object = object;
        this.batchMode = batchMode;
        this.entries = new Entry[types.length];
        for (int i = 0; i < types.length; ++i) {
            this.entries[i] = new Entry(types[i], attributeLengthStrategy.getAttributeLength(types[i]));
        }
    }

    private CKA[] buildQuery() {
        ArrayList<CKA> query = new ArrayList<CKA>();
        boolean maxLengthsUsed = false;
        for (Entry entry : this.entries) {
            if (entry.isFetched()) continue;
            maxLengthsUsed |= entry.isMaxLength();
            query.add(entry.query());
            if (!this.batchMode) break;
        }
        this.maxLengthUsedInLastQuery = maxLengthsUsed;
        return query.toArray(new CKA[0]);
    }

    private Entry getEntry(long type) {
        for (Entry entry : this.entries) {
            if (entry.type != type) continue;
            return entry;
        }
        throw new IllegalStateException("No such attribute type: " + type);
    }

    CKA[] fetch() throws CKRException {
        CKA[] query;
        while ((query = this.buildQuery()).length > 0) {
            long rv = this.cryptoki.GetAttributeValue(this.session, this.object, query);
            if (rv != 0L) {
                this.processError(rv, query);
            }
            this.processAvailable(query);
        }
        return this.buildResult();
    }

    private void processError(long rv, CKA[] response) throws CKRException {
        if (rv == 336L) {
            this.bufferTooSmall(response);
        } else if (rv == 17L || rv == 18L) {
            if (this.countUnavailable(response) > 1 && this.maxLengthUsedInLastQuery) {
                this.bufferTooSmall(response);
            } else {
                this.attributesInvalid(response);
            }
        } else {
            throw new CKRException("Error fetching " + this.listUnavailable(response) + " attributes, rv = " + rv, rv);
        }
    }

    private String listUnavailable(CKA[] templ) {
        StringBuilder sb = new StringBuilder();
        for (CKA cka : templ) {
            if (cka.ulValueLen != -1L) continue;
            sb.append(cka.type).append(", ");
        }
        return sb.toString();
    }

    private int countUnavailable(CKA[] templ) {
        int count = 0;
        for (CKA cka : templ) {
            if (cka.ulValueLen != -1L) continue;
            ++count;
        }
        return count;
    }

    private CKA[] buildResult() {
        CKA[] result = new CKA[this.entries.length];
        for (int i = 0; i < this.entries.length; ++i) {
            result[i] = this.entries[i].getCka();
        }
        return result;
    }

    private void processAvailable(CKA[] response) {
        for (CKA cka : response) {
            Entry entry = this.getEntry(cka.type);
            if (cka.ulValueLen == 0L || cka.ulValueLen > 0L && cka.pValue != null) {
                entry.setCka(cka);
                continue;
            }
            if (cka.ulValueLen <= 0L) continue;
            entry.setKnownLength((int)cka.ulValueLen);
        }
    }

    private void bufferTooSmall(CKA[] response) {
        for (CKA cka : response) {
            Entry entry = this.getEntry(cka.type);
            if (cka.ulValueLen != -1L) continue;
            entry.bufferTooSmall();
        }
    }

    private void attributesInvalid(CKA[] response) {
        for (CKA cka : response) {
            Entry entry = this.getEntry(cka.type);
            if (cka.ulValueLen != -1L) continue;
            entry.setCka(cka);
        }
    }

    private static class Entry {
        private final long type;
        private CKA cka;
        private int length;
        private boolean lengthKnown;

        Entry(long type, int maxLength) {
            this.type = type;
            this.length = maxLength;
        }

        public boolean isMaxLength() {
            return !this.lengthKnown && this.length > 0;
        }

        private CKA query() {
            if (this.length > 0) {
                return CKA.allocate(this.type, this.length);
            }
            return CKA.indefinite(this.type);
        }

        public boolean isFetched() {
            return this.getCka() != null;
        }

        public void bufferTooSmall() {
            this.length = 0;
            this.lengthKnown = false;
        }

        public void setKnownLength(int length) {
            this.length = length;
            this.lengthKnown = true;
        }

        public CKA getCka() {
            return this.cka;
        }

        public void setCka(CKA cka) {
            this.cka = cka;
        }
    }
}

