/*
 * Decompiled with CFR 0.152.
 */
package org.pkcs11.jacknji11;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pkcs11.jacknji11.CKA;
import org.pkcs11.jacknji11.CKM;
import org.pkcs11.jacknji11.CK_C_INITIALIZE_ARGS;
import org.pkcs11.jacknji11.CK_INFO;
import org.pkcs11.jacknji11.CK_MECHANISM_INFO;
import org.pkcs11.jacknji11.CK_NOTIFY;
import org.pkcs11.jacknji11.CK_SESSION_INFO;
import org.pkcs11.jacknji11.CK_SLOT_INFO;
import org.pkcs11.jacknji11.CK_TOKEN_INFO;
import org.pkcs11.jacknji11.Cryptoki;
import org.pkcs11.jacknji11.LongRef;
import org.pkcs11.jacknji11.NativePointer;
import org.pkcs11.jacknji11.NativeProvider;
import org.pkcs11.jacknji11.jna.JNA;

public class C {
    private static final Log log = LogFactory.getLog(C.class);
    public static NativeProvider NATIVE;
    private static Cryptoki CRYPTOKI;

    static void initCryptoki() {
        if (NATIVE == null) {
            NATIVE = new JNA();
        }
        if (CRYPTOKI == null) {
            CRYPTOKI = new Cryptoki(NATIVE);
        }
    }

    public static String getLibraryName() {
        String lib = System.getenv("JACKNJI11_PKCS11_LIB_PATH");
        if (lib == null || lib.length() == 0) {
            lib = "cryptoki";
        }
        log.debug((Object)("Loading native library " + lib));
        return lib;
    }

    public static long Initialize() {
        C.initCryptoki();
        return CRYPTOKI.Initialize();
    }

    public static long Initialize(CK_C_INITIALIZE_ARGS pInitArgs) {
        C.initCryptoki();
        return CRYPTOKI.Initialize(pInitArgs);
    }

    public static long Finalize() {
        return CRYPTOKI.Finalize();
    }

    public static long GetInfo(CK_INFO info) {
        return CRYPTOKI.GetInfo(info);
    }

    public static long GetSlotList(boolean tokenPresent, long[] slotList, LongRef count) {
        return CRYPTOKI.GetSlotList(tokenPresent, slotList, count);
    }

    public static long GetSlotInfo(long slotID, CK_SLOT_INFO info) {
        return CRYPTOKI.GetSlotInfo(slotID, info);
    }

    public static long GetTokenInfo(long slotID, CK_TOKEN_INFO info) {
        return CRYPTOKI.GetTokenInfo(slotID, info);
    }

    public static long WaitForSlotEvent(long flags, LongRef slot, NativePointer reserved) {
        return CRYPTOKI.WaitForSlotEvent(flags, slot, reserved);
    }

    public static long GetMechanismList(long slotID, long[] mechanismList, LongRef count) {
        return CRYPTOKI.GetMechanismList(slotID, mechanismList, count);
    }

    public static long GetMechanismInfo(long slotID, long type, CK_MECHANISM_INFO info) {
        return CRYPTOKI.GetMechanismInfo(slotID, type, info);
    }

    public static long InitToken(long slotID, byte[] pin, byte[] label) {
        return CRYPTOKI.InitToken(slotID, pin, label);
    }

    public static long InitPIN(long session, byte[] pin) {
        return CRYPTOKI.InitPIN(session, pin);
    }

    public static long SetPIN(long session, byte[] oldPin, byte[] newPin) {
        return CRYPTOKI.SetPIN(session, oldPin, newPin);
    }

    public static long OpenSession(long slotID, long flags, NativePointer application, CK_NOTIFY notify, LongRef session) {
        return CRYPTOKI.OpenSession(slotID, flags, application, notify, session);
    }

    public static long CloseSession(long session) {
        return CRYPTOKI.CloseSession(session);
    }

    public static long CloseAllSessions(long slotID) {
        return CRYPTOKI.CloseAllSessions(slotID);
    }

    public static long GetSessionInfo(long session, CK_SESSION_INFO info) {
        return CRYPTOKI.GetSessionInfo(session, info);
    }

    public static long GetOperationState(long session, byte[] operationState, LongRef operationStateLen) {
        return CRYPTOKI.GetOperationState(session, operationState, operationStateLen);
    }

    public static long SetOperationState(long session, byte[] operationState, long encryptionKey, long authenticationKey) {
        return CRYPTOKI.SetOperationState(session, operationState, encryptionKey, authenticationKey);
    }

    public static long Login(long session, long userType, byte[] pin) {
        return CRYPTOKI.Login(session, userType, pin);
    }

    public static long Logout(long session) {
        return CRYPTOKI.Logout(session);
    }

    public static long CreateObject(long session, CKA[] templ, LongRef object) {
        return CRYPTOKI.CreateObject(session, templ, object);
    }

    public static long CopyObject(long session, long object, CKA[] templ, LongRef newObject) {
        return CRYPTOKI.CopyObject(session, object, templ, newObject);
    }

    public static long DestroyObject(long session, long object) {
        return CRYPTOKI.DestroyObject(session, object);
    }

    public static long GetObjectSize(long session, long object, LongRef size) {
        return CRYPTOKI.GetObjectSize(session, object, size);
    }

    public static long GetAttributeValue(long session, long object, CKA[] templ) {
        return CRYPTOKI.GetAttributeValue(session, object, templ);
    }

    public static long SetAttributeValue(long session, long object, CKA[] templ) {
        return CRYPTOKI.SetAttributeValue(session, object, templ);
    }

    public static long FindObjectsInit(long session, CKA[] templ) {
        return CRYPTOKI.FindObjectsInit(session, templ);
    }

    public static long FindObjects(long session, long[] found, LongRef objectCount) {
        return CRYPTOKI.FindObjects(session, found, objectCount);
    }

    public static long FindObjectsFinal(long session) {
        return CRYPTOKI.FindObjectsFinal(session);
    }

    public static long EncryptInit(long session, CKM mechanism, long key) {
        return CRYPTOKI.EncryptInit(session, mechanism, key);
    }

    public static long Encrypt(long session, byte[] data, byte[] encryptedData, LongRef encryptedDataLen) {
        return CRYPTOKI.Encrypt(session, data, encryptedData, encryptedDataLen);
    }

    public static long EncryptUpdate(long session, byte[] part, byte[] encryptedPart, LongRef encryptedPartLen) {
        return CRYPTOKI.EncryptUpdate(session, part, encryptedPart, encryptedPartLen);
    }

    public static long EncryptFinal(long session, byte[] lastEncryptedPart, LongRef lastEncryptedPartLen) {
        return CRYPTOKI.EncryptFinal(session, lastEncryptedPart, lastEncryptedPartLen);
    }

    public static long DecryptInit(long session, CKM mechanism, long key) {
        return CRYPTOKI.DecryptInit(session, mechanism, key);
    }

    public static long Decrypt(long session, byte[] encryptedData, byte[] data, LongRef dataLen) {
        return CRYPTOKI.Decrypt(session, encryptedData, data, dataLen);
    }

    public static long DecryptUpdate(long session, byte[] encryptedPart, byte[] data, LongRef dataLen) {
        return CRYPTOKI.DecryptUpdate(session, encryptedPart, data, dataLen);
    }

    public static long DecryptFinal(long session, byte[] lastPart, LongRef lastPartLen) {
        return CRYPTOKI.DecryptFinal(session, lastPart, lastPartLen);
    }

    public static long DigestInit(long session, CKM mechanism) {
        return CRYPTOKI.DigestInit(session, mechanism);
    }

    public static long Digest(long session, byte[] data, byte[] digest, LongRef digestLen) {
        return CRYPTOKI.Digest(session, data, digest, digestLen);
    }

    public static long DigestUpdate(long session, byte[] part) {
        return CRYPTOKI.DigestUpdate(session, part);
    }

    public static long DigestKey(long session, long key) {
        return CRYPTOKI.DigestKey(session, key);
    }

    public static long DigestFinal(long session, byte[] digest, LongRef digestLen) {
        return CRYPTOKI.DigestFinal(session, digest, digestLen);
    }

    public static long SignInit(long session, CKM mechanism, long key) {
        return CRYPTOKI.SignInit(session, mechanism, key);
    }

    public static long Sign(long session, byte[] data, byte[] signature, LongRef signatureLen) {
        return CRYPTOKI.Sign(session, data, signature, signatureLen);
    }

    public static long SignUpdate(long session, byte[] part) {
        return CRYPTOKI.SignUpdate(session, part);
    }

    public static long SignFinal(long session, byte[] signature, LongRef signatureLen) {
        return CRYPTOKI.SignFinal(session, signature, signatureLen);
    }

    public static long SignRecoverInit(long session, CKM mechanism, long key) {
        return CRYPTOKI.SignRecoverInit(session, mechanism, key);
    }

    public static long SignRecover(long session, byte[] data, byte[] signature, LongRef signatureLen) {
        return CRYPTOKI.SignRecover(session, data, signature, signatureLen);
    }

    public static long VerifyInit(long session, CKM mechanism, long key) {
        return CRYPTOKI.VerifyInit(session, mechanism, key);
    }

    public static long Verify(long session, byte[] data, byte[] signature) {
        return CRYPTOKI.Verify(session, data, signature);
    }

    public static long VerifyUpdate(long session, byte[] part) {
        return CRYPTOKI.VerifyUpdate(session, part);
    }

    public static long VerifyFinal(long session, byte[] signature) {
        return CRYPTOKI.VerifyFinal(session, signature);
    }

    public static long VerifyRecoverInit(long session, CKM mechanism, long key) {
        return CRYPTOKI.VerifyRecoverInit(session, mechanism, key);
    }

    public static long VerifyRecover(long session, byte[] signature, byte[] data, LongRef dataLen) {
        return CRYPTOKI.VerifyRecover(session, signature, data, dataLen);
    }

    public static long DigestEncryptUpdate(long session, byte[] part, byte[] encryptedPart, LongRef encryptedPartLen) {
        return CRYPTOKI.DigestEncryptUpdate(session, part, encryptedPart, encryptedPartLen);
    }

    public static long DecryptDigestUpdate(long session, byte[] encryptedPart, byte[] part, LongRef partLen) {
        return CRYPTOKI.DecryptDigestUpdate(session, encryptedPart, part, partLen);
    }

    public static long SignEncryptUpdate(long session, byte[] part, byte[] encryptedPart, LongRef encryptedPartLen) {
        return CRYPTOKI.SignEncryptUpdate(session, part, encryptedPart, encryptedPartLen);
    }

    public static long DecryptVerifyUpdate(long session, byte[] encryptedPart, byte[] part, LongRef partLen) {
        return CRYPTOKI.DecryptVerifyUpdate(session, encryptedPart, part, partLen);
    }

    public static long GenerateKey(long session, CKM mechanism, CKA[] templ, LongRef key) {
        return CRYPTOKI.GenerateKey(session, mechanism, templ, key);
    }

    public static long GenerateKeyPair(long session, CKM mechanism, CKA[] publicKeyTemplate, CKA[] privateKeyTemplate, LongRef publicKey, LongRef privateKey) {
        return CRYPTOKI.GenerateKeyPair(session, mechanism, publicKeyTemplate, privateKeyTemplate, publicKey, privateKey);
    }

    public static long WrapKey(long session, CKM mechanism, long wrappingKey, long key, byte[] wrappedKey, LongRef wrappedKeyLen) {
        return CRYPTOKI.WrapKey(session, mechanism, wrappingKey, key, wrappedKey, wrappedKeyLen);
    }

    public static long UnwrapKey(long session, CKM mechanism, long unwrappingKey, byte[] wrappedKey, CKA[] templ, LongRef key) {
        return CRYPTOKI.UnwrapKey(session, mechanism, unwrappingKey, wrappedKey, templ, key);
    }

    public static long DeriveKey(long session, CKM mechanism, long baseKey, CKA[] templ, LongRef key) {
        return CRYPTOKI.DeriveKey(session, mechanism, baseKey, templ, key);
    }

    public static long SeedRandom(long session, byte[] seed) {
        return CRYPTOKI.SeedRandom(session, seed);
    }

    public static long GenerateRandom(long session, byte[] randomData) {
        return CRYPTOKI.GenerateRandom(session, randomData);
    }

    public static long GetFunctionStatus(long session) {
        return CRYPTOKI.GetFunctionStatus(session);
    }

    public static long CancelFunction(long session) {
        return CRYPTOKI.CancelFunction(session);
    }

    private static int baLen(byte[] buf) {
        return buf == null ? 0 : buf.length;
    }

    private static int templLen(CKA[] templ) {
        return templ == null ? 0 : templ.length;
    }

    private static void dumpTemplate(StringBuilder sb, CKA[] template) {
        int templateLen = C.templLen(template);
        sb.append("  template (size=").append(templateLen).append(')');
        for (int i = 0; i < templateLen; ++i) {
            sb.append("\n  ");
            template[i].dump(sb);
        }
    }

    public static Map<Long, String> createL2SMap(Class<?> c) {
        HashMap<Long, String> map = new HashMap<Long, String>();
        try {
            for (Field f : c.getDeclaredFields()) {
                if (f.getType() != Long.TYPE || !Modifier.isPublic(f.getModifiers()) || !Modifier.isStatic(f.getModifiers()) || !Modifier.isFinal(f.getModifiers())) continue;
                map.put(f.getLong(null), f.getName());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return map;
    }

    public static String l2s(Map<Long, String> map, String ckx, long l) {
        String s = map.get(l);
        if (s != null) {
            return s;
        }
        return String.format("unknown %s constant 0x%08x", ckx, l);
    }

    public static String f2s(Map<Long, String> l2s, long flags) {
        StringBuilder sb = new StringBuilder();
        String sep = "";
        for (int i = 63; i >= 0; --i) {
            long mask = 1L << i;
            if ((flags & mask) == 0L) continue;
            sb.append(sep);
            sb.append(C.l2s(l2s, "CKF", mask));
            sep = "|";
        }
        return sb.toString();
    }
}

