/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.structures.constants;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.gjt.jclasslib.io.DataInput;
import org.gjt.jclasslib.io.DataOutput;
import org.gjt.jclasslib.structures.AbstractConstant;
import org.gjt.jclasslib.structures.ClassFile;
import org.gjt.jclasslib.structures.constants.ConstantNameAndTypeInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0096\u0002J\b\u0010$\u001a\u00020\u0007H\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\t\"\u0004\b\u000e\u0010\u000bR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u001e\u001a\u00020\u00108TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0012\u00a8\u0006%"}, d2={"Lorg/gjt/jclasslib/structures/constants/ConstantDynamic;", "Lorg/gjt/jclasslib/structures/AbstractConstant;", "classFile", "Lorg/gjt/jclasslib/structures/ClassFile;", "<init>", "(Lorg/gjt/jclasslib/structures/ClassFile;)V", "bootstrapMethodAttributeIndex", "", "getBootstrapMethodAttributeIndex", "()I", "setBootstrapMethodAttributeIndex", "(I)V", "nameAndTypeIndex", "getNameAndTypeIndex", "setNameAndTypeIndex", "verbose", "", "getVerbose", "()Ljava/lang/String;", "nameAndTypeInfo", "Lorg/gjt/jclasslib/structures/constants/ConstantNameAndTypeInfo;", "getNameAndTypeInfo", "()Lorg/gjt/jclasslib/structures/constants/ConstantNameAndTypeInfo;", "readData", "", "input", "Lorg/gjt/jclasslib/io/DataInput;", "writeData", "output", "Lorg/gjt/jclasslib/io/DataOutput;", "debugInfo", "getDebugInfo", "equals", "", "other", "", "hashCode", "data"})
public abstract class ConstantDynamic
extends AbstractConstant {
    private int bootstrapMethodAttributeIndex;
    private int nameAndTypeIndex;

    public ConstantDynamic(@NotNull ClassFile classFile) {
        Intrinsics.checkNotNullParameter((Object)classFile, (String)"classFile");
        super(classFile);
    }

    public final int getBootstrapMethodAttributeIndex() {
        return this.bootstrapMethodAttributeIndex;
    }

    public final void setBootstrapMethodAttributeIndex(int n) {
        this.bootstrapMethodAttributeIndex = n;
    }

    public final int getNameAndTypeIndex() {
        return this.nameAndTypeIndex;
    }

    public final void setNameAndTypeIndex(int n) {
        this.nameAndTypeIndex = n;
    }

    @Override
    @NotNull
    public String getVerbose() {
        return this.getNameAndTypeInfo().getName() + ", BootstrapMethods #" + this.bootstrapMethodAttributeIndex;
    }

    @NotNull
    public final ConstantNameAndTypeInfo getNameAndTypeInfo() {
        return (ConstantNameAndTypeInfo)this.getClassFile().getConstantPoolEntry(this.nameAndTypeIndex, Reflection.getOrCreateKotlinClass(ConstantNameAndTypeInfo.class));
    }

    @Override
    protected void readData(@NotNull DataInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.bootstrapMethodAttributeIndex = input.readUnsignedShort();
        this.nameAndTypeIndex = input.readUnsignedShort();
    }

    @Override
    protected void writeData(@NotNull DataOutput output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        output.writeByte(this.getConstantType().getTag());
        output.writeShort(this.bootstrapMethodAttributeIndex);
        output.writeShort(this.nameAndTypeIndex);
    }

    @Override
    @NotNull
    protected String getDebugInfo() {
        return "with bootstrapMethodAttributeIndex " + this.bootstrapMethodAttributeIndex + " and nameAndTypeIndex " + this.nameAndTypeIndex;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (!(other instanceof ConstantDynamic) || ((ConstantDynamic)other).getConstantType() != this.getConstantType()) {
            return false;
        }
        return super.equals(other) && ((ConstantDynamic)other).bootstrapMethodAttributeIndex == this.bootstrapMethodAttributeIndex && ((ConstantDynamic)other).nameAndTypeIndex == this.nameAndTypeIndex;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.bootstrapMethodAttributeIndex ^ this.nameAndTypeIndex;
    }
}

