/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.structures.attributes;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gjt.jclasslib.io.DataInput;
import org.gjt.jclasslib.io.DataOutput;
import org.gjt.jclasslib.structures.ClassFile;
import org.gjt.jclasslib.structures.attributes.StackFrameType;
import org.gjt.jclasslib.structures.attributes.SubStructure;
import org.gjt.jclasslib.structures.attributes.VerificationType;
import org.gjt.jclasslib.structures.attributes.VerificationTypeInfoEntry;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0014J\u0010\u0010'\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010(\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010)\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010*\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010+\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010,\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010-\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J#\u0010.\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010%\u001a\u00020&2\u0006\u0010/\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u00100J\u0010\u00101\u001a\u00020$2\u0006\u00102\u001a\u000203H\u0014J\u0010\u00104\u001a\u00020$2\u0006\u00102\u001a\u000203H\u0002J\u0010\u00105\u001a\u00020$2\u0006\u00102\u001a\u000203H\u0002J\u0010\u00106\u001a\u00020$2\u0006\u00102\u001a\u000203H\u0002J\u0010\u00107\u001a\u00020$2\u0006\u00102\u001a\u000203H\u0002J\u0010\u00108\u001a\u00020$2\u0006\u00102\u001a\u000203H\u0002J\u0010\u00109\u001a\u00020$2\u0006\u00102\u001a\u000203H\u0002J\u0014\u0010@\u001a\u00020$2\n\u0010A\u001a\u00060Bj\u0002`CH\u0002J\u0014\u0010D\u001a\u00020$2\n\u0010A\u001a\u00060Bj\u0002`CH\u0002J\u0014\u0010E\u001a\u00020$2\n\u0010A\u001a\u00060Bj\u0002`CH\u0002J'\u0010F\u001a\u00020$2\f\u0010G\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\n\u0010A\u001a\u00060Bj\u0002`CH\u0002\u00a2\u0006\u0002\u0010HJ\u0017\u0010K\u001a\u00020\u0007*\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002\u00a2\u0006\u0002\u0010LR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\t\"\u0004\b\u0014\u0010\u000bR\u001a\u0010\u0015\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\t\"\u0004\b\u0017\u0010\u000bR\"\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001f\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\"\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001f\u001a\u0004\b!\u0010\u001c\"\u0004\b\"\u0010\u001eR\u0014\u0010:\u001a\u00020;8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b<\u0010=R\u0011\u0010>\u001a\u00020;8F\u00a2\u0006\u0006\u001a\u0004\b?\u0010=R\u0014\u0010I\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bJ\u0010\t\u00a8\u0006M"}, d2={"Lorg/gjt/jclasslib/structures/attributes/StackMapFrameEntry;", "Lorg/gjt/jclasslib/structures/attributes/SubStructure;", "classFile", "Lorg/gjt/jclasslib/structures/ClassFile;", "<init>", "(Lorg/gjt/jclasslib/structures/ClassFile;)V", "tag", "", "getTag", "()I", "setTag", "(I)V", "frameType", "Lorg/gjt/jclasslib/structures/attributes/StackFrameType;", "getFrameType", "()Lorg/gjt/jclasslib/structures/attributes/StackFrameType;", "setFrameType", "(Lorg/gjt/jclasslib/structures/attributes/StackFrameType;)V", "offsetDelta", "getOffsetDelta", "setOffsetDelta", "offset", "getOffset", "setOffset", "localItems", "", "Lorg/gjt/jclasslib/structures/attributes/VerificationTypeInfoEntry;", "getLocalItems", "()[Lorg/gjt/jclasslib/structures/attributes/VerificationTypeInfoEntry;", "setLocalItems", "([Lorg/gjt/jclasslib/structures/attributes/VerificationTypeInfoEntry;)V", "[Lorg/gjt/jclasslib/structures/attributes/VerificationTypeInfoEntry;", "stackItems", "getStackItems", "setStackItems", "readData", "", "input", "Lorg/gjt/jclasslib/io/DataInput;", "readOneStackItem", "readVerificationTypeInfoEntry", "readOneStackItemExt", "readChop", "readSameExt", "readAppend", "readFull", "readEntries", "numLocals", "(Lorg/gjt/jclasslib/io/DataInput;I)[Lorg/gjt/jclasslib/structures/attributes/VerificationTypeInfoEntry;", "writeData", "output", "Lorg/gjt/jclasslib/io/DataOutput;", "writeOneStackItem", "writeOneStackItemExt", "writeChop", "writeSameExt", "writeAppend", "writeFull", "debugInfo", "", "getDebugInfo", "()Ljava/lang/String;", "verbose", "getVerbose", "appendOffset", "buffer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "appendStack", "appendLocals", "appendEntries", "entries", "([Lorg/gjt/jclasslib/structures/attributes/VerificationTypeInfoEntry;Ljava/lang/StringBuilder;)V", "length", "getLength", "totalLength", "([Lorg/gjt/jclasslib/structures/attributes/VerificationTypeInfoEntry;)I", "data"})
@SourceDebugExtension(value={"SMAP\nStackMapFrameEntry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StackMapFrameEntry.kt\norg/gjt/jclasslib/structures/attributes/StackMapFrameEntry\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,219:1\n13467#2,3:220\n1#3:223\n*S KotlinDebug\n*F\n+ 1 StackMapFrameEntry.kt\norg/gjt/jclasslib/structures/attributes/StackMapFrameEntry\n*L\n194#1:220,3\n*E\n"})
public final class StackMapFrameEntry
extends SubStructure {
    @NotNull
    private final ClassFile classFile;
    private int tag;
    @NotNull
    private StackFrameType frameType;
    private int offsetDelta;
    private int offset;
    @NotNull
    private VerificationTypeInfoEntry[] localItems;
    @NotNull
    private VerificationTypeInfoEntry[] stackItems;

    public StackMapFrameEntry(@NotNull ClassFile classFile) {
        Intrinsics.checkNotNullParameter((Object)classFile, (String)"classFile");
        this.classFile = classFile;
        this.frameType = StackFrameType.SAME;
        this.localItems = new VerificationTypeInfoEntry[0];
        this.stackItems = new VerificationTypeInfoEntry[0];
    }

    public final int getTag() {
        return this.tag;
    }

    public final void setTag(int n) {
        this.tag = n;
    }

    @NotNull
    public final StackFrameType getFrameType() {
        return this.frameType;
    }

    public final void setFrameType(@NotNull StackFrameType stackFrameType) {
        Intrinsics.checkNotNullParameter((Object)((Object)stackFrameType), (String)"<set-?>");
        this.frameType = stackFrameType;
    }

    public final int getOffsetDelta() {
        return this.offsetDelta;
    }

    public final void setOffsetDelta(int n) {
        this.offsetDelta = n;
    }

    public final int getOffset() {
        return this.offset;
    }

    public final void setOffset(int n) {
        this.offset = n;
    }

    @NotNull
    public final VerificationTypeInfoEntry[] getLocalItems() {
        return this.localItems;
    }

    public final void setLocalItems(@NotNull VerificationTypeInfoEntry[] verificationTypeInfoEntryArray) {
        Intrinsics.checkNotNullParameter((Object)verificationTypeInfoEntryArray, (String)"<set-?>");
        this.localItems = verificationTypeInfoEntryArray;
    }

    @NotNull
    public final VerificationTypeInfoEntry[] getStackItems() {
        return this.stackItems;
    }

    public final void setStackItems(@NotNull VerificationTypeInfoEntry[] verificationTypeInfoEntryArray) {
        Intrinsics.checkNotNullParameter((Object)verificationTypeInfoEntryArray, (String)"<set-?>");
        this.stackItems = verificationTypeInfoEntryArray;
    }

    @Override
    protected void readData(@NotNull DataInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.tag = input.readUnsignedByte();
        this.frameType = StackFrameType.Companion.getFromTag(this.tag);
        switch (WhenMappings.$EnumSwitchMapping$0[this.frameType.ordinal()]) {
            case 1: {
                this.offsetDelta = this.tag;
                break;
            }
            case 2: {
                this.readOneStackItem(input);
                break;
            }
            case 3: {
                this.readOneStackItemExt(input);
                break;
            }
            case 4: {
                this.readChop(input);
                break;
            }
            case 5: {
                this.readSameExt(input);
                break;
            }
            case 6: {
                this.readAppend(input);
                break;
            }
            case 7: {
                this.readFull(input);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final void readOneStackItem(DataInput input) {
        this.offsetDelta = this.tag - 64;
        VerificationTypeInfoEntry[] verificationTypeInfoEntryArray = new VerificationTypeInfoEntry[]{this.readVerificationTypeInfoEntry(input)};
        this.stackItems = verificationTypeInfoEntryArray;
    }

    private final VerificationTypeInfoEntry readVerificationTypeInfoEntry(DataInput input) {
        VerificationTypeInfoEntry verificationTypeInfoEntry;
        int tag = input.readUnsignedByte();
        VerificationType verificationType = (VerificationType)VerificationType.Companion.getFromTag(tag);
        VerificationTypeInfoEntry $this$readVerificationTypeInfoEntry_u24lambda_u240 = verificationTypeInfoEntry = verificationType.createEntry(this.classFile);
        boolean bl = false;
        $this$readVerificationTypeInfoEntry_u24lambda_u240.read(input);
        return verificationTypeInfoEntry;
    }

    private final void readOneStackItemExt(DataInput input) {
        this.offsetDelta = input.readUnsignedShort();
        VerificationTypeInfoEntry[] verificationTypeInfoEntryArray = new VerificationTypeInfoEntry[]{this.readVerificationTypeInfoEntry(input)};
        this.stackItems = verificationTypeInfoEntryArray;
    }

    private final void readChop(DataInput input) {
        this.offsetDelta = input.readUnsignedShort();
    }

    private final void readSameExt(DataInput input) {
        this.offsetDelta = input.readUnsignedShort();
    }

    private final void readAppend(DataInput input) {
        this.offsetDelta = input.readUnsignedShort();
        int numLocals = this.tag - 251;
        this.localItems = this.readEntries(input, numLocals);
    }

    private final void readFull(DataInput input) {
        this.offsetDelta = input.readUnsignedShort();
        int numLocals = input.readUnsignedShort();
        this.localItems = this.readEntries(input, numLocals);
        int numStacks = input.readUnsignedShort();
        this.stackItems = this.readEntries(input, numStacks);
    }

    private final VerificationTypeInfoEntry[] readEntries(DataInput input, int numLocals) {
        int n = 0;
        VerificationTypeInfoEntry[] verificationTypeInfoEntryArray = new VerificationTypeInfoEntry[numLocals];
        while (n < numLocals) {
            int n2 = n++;
            verificationTypeInfoEntryArray[n2] = this.readVerificationTypeInfoEntry(input);
        }
        return verificationTypeInfoEntryArray;
    }

    @Override
    protected void writeData(@NotNull DataOutput output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        output.writeByte(this.tag);
        switch (WhenMappings.$EnumSwitchMapping$0[this.frameType.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                this.writeOneStackItem(output);
                break;
            }
            case 3: {
                this.writeOneStackItemExt(output);
                break;
            }
            case 4: {
                this.writeChop(output);
                break;
            }
            case 5: {
                this.writeSameExt(output);
                break;
            }
            case 6: {
                this.writeAppend(output);
                break;
            }
            case 7: {
                this.writeFull(output);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final void writeOneStackItem(DataOutput output) {
        this.stackItems[0].write(output);
    }

    private final void writeOneStackItemExt(DataOutput output) {
        output.writeShort(this.offsetDelta);
        this.stackItems[0].write(output);
    }

    private final void writeChop(DataOutput output) {
        output.writeShort(this.offsetDelta);
    }

    private final void writeSameExt(DataOutput output) {
        output.writeShort(this.offsetDelta);
    }

    private final void writeAppend(DataOutput output) {
        output.writeShort(this.offsetDelta);
        for (VerificationTypeInfoEntry localItem : this.localItems) {
            localItem.write(output);
        }
    }

    private final void writeFull(DataOutput output) {
        output.writeShort(this.offsetDelta);
        output.writeShort(this.localItems.length);
        for (VerificationTypeInfoEntry localItem : this.localItems) {
            localItem.write(output);
        }
        output.writeShort(this.stackItems.length);
        for (VerificationTypeInfoEntry stackItem : this.stackItems) {
            stackItem.write(output);
        }
    }

    @Override
    @NotNull
    protected String getDebugInfo() {
        return "of type " + this.frameType;
    }

    @NotNull
    public final String getVerbose() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<b>").append((Object)this.frameType).append("</b> (").append(this.tag).append(')');
        this.appendOffset(buffer);
        switch (WhenMappings.$EnumSwitchMapping$0[this.frameType.ordinal()]) {
            case 1: 
            case 4: 
            case 5: {
                break;
            }
            case 2: 
            case 3: {
                this.appendStack(buffer);
                break;
            }
            case 6: {
                this.appendLocals(buffer);
                break;
            }
            case 7: {
                this.appendLocals(buffer);
                this.appendStack(buffer);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String string = buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return StringsKt.replace$default((String)StringsKt.replace$default((String)string, (String)"\n", (String)"<br>", (boolean)false, (int)4, null), (String)" ", (String)"&nbsp;", (boolean)false, (int)4, null);
    }

    private final void appendOffset(StringBuilder buffer) {
        buffer.append(", Offset: ").append(this.offset).append(" (+").append(this.offsetDelta).append(")");
    }

    private final void appendStack(StringBuilder buffer) {
        buffer.append("\n    Stack verifications:\n");
        this.appendEntries(this.stackItems, buffer);
    }

    private final void appendLocals(StringBuilder buffer) {
        buffer.append("\n    Local verifications:\n");
        this.appendEntries(this.localItems, buffer);
    }

    /*
     * WARNING - void declaration
     */
    private final void appendEntries(VerificationTypeInfoEntry[] entries, StringBuilder buffer) {
        VerificationTypeInfoEntry[] $this$forEachIndexed$iv = entries;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (VerificationTypeInfoEntry item$iv : $this$forEachIndexed$iv) {
            void entry;
            int n = index$iv++;
            VerificationTypeInfoEntry verificationTypeInfoEntry = item$iv;
            int i = n;
            boolean bl = false;
            buffer.append("        ");
            entry.appendTo(buffer);
            if (i >= entries.length - 1) continue;
            buffer.append("\n");
        }
    }

    @Override
    public int getLength() {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.frameType.ordinal()]) {
            case 1 -> 1;
            case 2 -> 1 + this.totalLength(this.stackItems);
            case 3 -> 3 + this.totalLength(this.stackItems);
            case 4, 5 -> 3;
            case 6 -> 3 + this.totalLength(this.localItems);
            case 7 -> 7 + this.totalLength(this.localItems) + this.totalLength(this.stackItems);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    /*
     * WARNING - void declaration
     */
    private final int totalLength(VerificationTypeInfoEntry[] $this$totalLength) {
        VerificationTypeInfoEntry[] verificationTypeInfoEntryArray = $this$totalLength;
        int n = 0;
        int n2 = verificationTypeInfoEntryArray.length;
        for (int i = 0; i < n2; ++i) {
            void it;
            VerificationTypeInfoEntry verificationTypeInfoEntry;
            VerificationTypeInfoEntry verificationTypeInfoEntry2 = verificationTypeInfoEntry = verificationTypeInfoEntryArray[i];
            int n3 = n;
            boolean bl = false;
            int n4 = it.getLength();
            n = n3 + n4;
        }
        return n;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[StackFrameType.values().length];
            try {
                nArray[StackFrameType.SAME.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StackFrameType.SAME_LOCALS_1_STACK_ITEM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StackFrameType.SAME_LOCALS_1_STACK_ITEM_EXT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StackFrameType.CHOP.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StackFrameType.SAME_EXT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StackFrameType.APPEND.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StackFrameType.FULL.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

