/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.misc;

import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.misc.AbstractPrivilegesAction;
import com.install4j.runtime.beans.actions.misc.PrivilegeRequirement;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.helper.MsiHelper;
import com.install4j.runtime.installer.platform.win32.MsiCommunication;
import java.util.Objects;

public class RequestPrivilegesAction
extends AbstractPrivilegesAction {
    private boolean obtainIfAdminWin = true;
    private boolean obtainIfNormalWin = false;
    private boolean failIfNotObtainedWin = true;
    private boolean obtainIfAdminMac = false;
    private boolean obtainIfNormalMac = false;
    private boolean failIfNotObtainedMac = true;
    private PrivilegeRequirement linuxPrivilegeRequirement = PrivilegeRequirement.NONE;
    private boolean failIfNotObtainedLinux = false;
    private boolean failIfNotRootUnix = false;

    public boolean isObtainIfAdminWin() {
        return this.replaceWithTextOverride("obtainIfAdminWin", this.obtainIfAdminWin);
    }

    public void setObtainIfAdminWin(boolean obtainIfAdminWin) {
        this.obtainIfAdminWin = obtainIfAdminWin;
    }

    public boolean isObtainIfNormalWin() {
        return this.replaceWithTextOverride("obtainIfNormalWin", this.obtainIfNormalWin);
    }

    public void setObtainIfNormalWin(boolean obtainIfNormalWin) {
        this.obtainIfNormalWin = obtainIfNormalWin;
    }

    public boolean isFailIfNotObtainedWin() {
        return this.replaceWithTextOverride("failIfNotObtainedWin", this.failIfNotObtainedWin);
    }

    public void setFailIfNotObtainedWin(boolean failIfNotObtainedWin) {
        this.failIfNotObtainedWin = failIfNotObtainedWin;
    }

    public boolean isObtainIfAdminMac() {
        return this.replaceWithTextOverride("obtainIfAdminMac", this.obtainIfAdminMac);
    }

    public void setObtainIfAdminMac(boolean obtainIfAdminMac) {
        this.obtainIfAdminMac = obtainIfAdminMac;
    }

    public boolean isObtainIfNormalMac() {
        return this.replaceWithTextOverride("obtainIfNormalMac", this.obtainIfNormalMac);
    }

    public void setObtainIfNormalMac(boolean obtainIfNormalMac) {
        this.obtainIfNormalMac = obtainIfNormalMac;
    }

    public boolean isFailIfNotObtainedMac() {
        return this.replaceWithTextOverride("failIfNotObtainedMac", this.failIfNotObtainedMac);
    }

    public void setFailIfNotObtainedMac(boolean failIfNotObtainedMac) {
        this.failIfNotObtainedMac = failIfNotObtainedMac;
    }

    public boolean isFailIfNotRootUnix() {
        return this.replaceWithTextOverride("failIfNotRootUnix", this.failIfNotRootUnix);
    }

    public void setFailIfNotRootUnix(boolean failIfNotRootUnix) {
        this.failIfNotRootUnix = failIfNotRootUnix;
    }

    public PrivilegeRequirement getLinuxPrivilegeRequirement() {
        return this.replaceWithTextOverride("linuxPrivilegeRequirement", this.linuxPrivilegeRequirement, PrivilegeRequirement.class);
    }

    public void setLinuxPrivilegeRequirement(PrivilegeRequirement linuxPrivilegeRequirement) {
        this.linuxPrivilegeRequirement = linuxPrivilegeRequirement;
    }

    public boolean isFailIfNotObtainedLinux() {
        return this.replaceWithTextOverride("failIfNotObtainedLinux", this.failIfNotObtainedLinux);
    }

    public void setFailIfNotObtainedLinux(boolean failIfNotObtainedLinux) {
        this.failIfNotObtainedLinux = failIfNotObtainedLinux;
    }

    @Override
    public boolean execute(Context context) throws UserCanceledException {
        boolean success = this.requestRights(context);
        boolean adminRightsSet = this.setAdminRightsVariable();
        if (adminRightsSet && RequestPrivilegesAction.isLinuxPrivilegeHandling()) {
            context.setVariable("sys.adminRightsUiRootUnix", this.getLinuxPrivilegeRequirement() == PrivilegeRequirement.ROOT);
            InstallerVariables.registerResponseFileVariable("sys.adminRightsUiRootUnix");
        }
        return success;
    }

    private boolean requestRights(Context context) throws UserCanceledException {
        if (Util.isWindows()) {
            return this.executeOnWindows(context);
        }
        if (Util.isMacOS()) {
            return this.executeOnMac(context);
        }
        if (RequestPrivilegesAction.isLinuxPrivilegeHandling()) {
            return this.executeOnLinux(context);
        }
        return this.executeOnUnix(context);
    }

    private boolean executeOnUnix(Context context) throws UserCanceledException {
        if (!Util.hasFullAdminRights()) {
            if (this.isFailIfNotRootUnix()) {
                this.showFailureMessage(context);
            }
            return false;
        }
        return true;
    }

    private boolean executeOnLinux(Context context) throws UserCanceledException {
        if (!Util.hasFullAdminRights()) {
            switch (this.getLinuxPrivilegeRequirement()) {
                case NONE: {
                    return true;
                }
                case ROOT: {
                    if (this.isFailIfNotObtainedLinux()) {
                        this.showFailureMessage(context);
                    }
                    return false;
                }
                case OBTAIN: {
                    if (!this.startOnLinux(context)) {
                        if (this.isFailIfNotObtainedLinux()) {
                            this.showFailureMessage(context);
                        }
                        return false;
                    }
                    return true;
                }
            }
        }
        return true;
    }

    private boolean executeOnMac(Context context) throws UserCanceledException {
        boolean success = true;
        if (Util.isAdminGroup()) {
            if (this.isObtainIfAdminMac()) {
                success = Util.hasFullAdminRights() || this.startOnMac(context);
            }
        } else if (this.isObtainIfNormalMac()) {
            success = this.startOnMac(context);
        }
        if (!success && this.isFailIfNotObtainedMac()) {
            this.showFailureMessage(context);
        }
        return success;
    }

    private boolean executeOnWindows(Context context) throws UserCanceledException {
        boolean success = true;
        if (Util.isAdminGroup()) {
            if (this.isObtainIfAdminWin()) {
                if (Util.hasFullAdminRights()) {
                    if (MsiHelper.isStartedFromMsi() && !context.isUnattended() && MsiCommunication.isConnected() && MsiCommunication.sendElevationRequested()) {
                        MsiHelper.setMsiAllUsers(true);
                    }
                } else {
                    success = this.startOnWindows(context);
                }
            }
        } else if (this.isObtainIfNormalWin()) {
            success = this.startOnWindows(context);
        }
        if (!success && this.isFailIfNotObtainedWin()) {
            this.showFailureMessage(context);
        }
        return success;
    }

    public boolean isAllRequested(boolean windowsOnly) {
        return this.isObtainIfAdminWin() && this.isObtainIfNormalWin() && (windowsOnly || this.isObtainIfAdminMac() && this.isObtainIfNormalMac() && this.getLinuxPrivilegeRequirement() != PrivilegeRequirement.NONE);
    }

    public void setAllRequested(boolean windowsOnly) {
        this.setObtainIfAdminWin(true);
        this.setObtainIfNormalWin(true);
        this.setFailIfNotObtainedWin(true);
        if (!windowsOnly) {
            this.setObtainIfAdminMac(true);
            this.setObtainIfNormalMac(true);
            this.setFailIfNotObtainedMac(true);
            if (this.getLinuxPrivilegeRequirement() == PrivilegeRequirement.NONE) {
                this.setLinuxPrivilegeRequirement(PrivilegeRequirement.OBTAIN);
            }
            this.setFailIfNotObtainedLinux(true);
            this.setFailIfNotRootUnix(true);
        }
    }

    static boolean isLinuxPrivilegeHandling() {
        return Util.isLinux() || !Util.isWindows() && !Util.isMacOS() && Objects.equals(Boolean.TRUE, InstallerVariables.getVariable("sys.forcePrivilegeRequest"));
    }
}

