/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.applications;

import com.install4j.api.beaninfo.BeanValidationException;
import com.install4j.api.beaninfo.BeanValidator;
import com.install4j.api.beaninfo.Install4JBeanInfo;
import com.install4j.api.beaninfo.Install4JPropertyDescriptor;
import com.install4j.api.beaninfo.ScriptParameter;
import com.install4j.api.beaninfo.ScriptPropertyDescriptor;
import com.install4j.api.beans.Bean;
import com.install4j.api.context.UnattendedProgressInterface;
import com.install4j.api.screens.Console;
import com.install4j.runtime.beans.applications.Application;
import com.install4j.runtime.beans.applications.ExecutionMode;
import com.install4j.runtime.beans.common.BeanIconHolder;
import com.install4j.runtime.beans.common.BeanInfoUtil;
import java.lang.reflect.ParameterizedType;
import java.util.List;

public abstract class ApplicationBeanInfo
extends Install4JBeanInfo
implements BeanValidator {
    public static final String CATEGORY_EXECUTABLE = "Executable";
    public static final String CATEGORY_GUI_OPTIONS = "GUI Options";
    public static final String PROPERTY_USE_CUSTOM_ICON = "useCustomIcon";
    public static final String PROPERTY_CUSTOM_ICON_IMAGE_FILES = "customIconImageFiles";
    private static final String PROPERTY_ALLOW_UNATTENDED = "allowUnattended";
    private static final String PROPERTY_ALLOW_CONSOLE = "allowConsole";
    private static final String PROPERTY_DISABLE_CONSOLE_ON_WINDOWS = "disableConsoleOnWindows";
    private static final String PROPERTY_FRAME_WIDTH = "frameWidth";
    private static final String PROPERTY_FRAME_HEIGHT = "frameHeight";
    private static final String PROPERTY_FRAME_SIZE_CLIENT_AREA = "frameSizeClientArea";
    public static final String PROPERTY_VM_PARAMETERS = "vmParameters";
    private static final String PROPERTY_ARGUMENTS = "arguments";
    private static final String PROPERTY_RESIZABLE = "resizable";
    private static final String PROPERTY_ROLLBACK = "rollback";
    public static final String PROPERTY_EXECUTION_MODE = "executionMode";
    private static final String PROPERTY_SPLASH_MESSAGE = "splashMessage";
    private static final String PROPERTY_UNATTENDED_PROGRESS_INTERFACE_PROVIDER = "unattendedProgressInterfaceProvider";
    private static final String PROPERTY_UNIX_FALLBACK_TO_CONSOLE = "unixFallbackToConsole";
    private static final String PROPERTY_WINDOWS_CONSOLE_EXECUTABLE = "windowsConsoleExecutable";
    private static final String PROPERTY_CONSOLE_SCREEN_CHANGE_HANDLER = "consoleScreenChangeHandler";
    private static final String PROPERTY_HELP_CUSTOMIZER = "helpCustomizer";
    private static final String PROPERTY_CUSTOMIZE_VERSION_INFO = "customizeVersionInfo";
    private static final String PROPERTY_VERSION_INFO_PRODUCT_NAME = "versionInfoProductName";
    private static final String PROPERTY_VERSION_INFO_FILE_VERSION = "versionInfoFileVersion";
    private static final String PROPERTY_VERSION_INFO_INTERNAL_NAME = "versionInfoInternalName";
    private static final String PROPERTY_VERSION_INFO_FILE_DESCRIPTION = "versionInfoFileDescription";
    private static final String PROPERTY_VERSION_INFO_COPYRIGHT = "versionInfoCopyright";
    private static final String PROPERTY_UNATTENDED_ALERTS = "unattendedAlerts";

    protected ApplicationBeanInfo(String string, String string2, Class<? extends Application> clazz) {
        this(string, string2, clazz, true);
    }

    protected ApplicationBeanInfo(String string, String string2, Class<? extends Application> clazz, boolean bl2) {
        super(string, string2, null, true, false, null, clazz);
        if (bl2) {
            this.addDescriptors();
        }
    }

    protected void addDescriptors() {
        this.addPropertyDescriptor(this.categoryExecutionModes(Install4JPropertyDescriptor.create((String)PROPERTY_ALLOW_UNATTENDED, (Class)this.getBeanClass(), (String)"Allow unattended mode", (String)"If selected, the user can pass <tt>-q</tt> as an argument to run the installer application without a GUI. No user input is required, the installer applications work with the default values. Please see the corresponding help topic on installer modes for more information. All standard actions and standard screens support unattended installations. If your policy forbids unattended installations or if you include custom code that cannot handle unattended installations, you can disable them by deselecting this property.")));
        this.addPropertyDescriptor(BeanInfoUtil.reparent(PROPERTY_ALLOW_UNATTENDED, (Install4JPropertyDescriptor)ScriptPropertyDescriptor.create((String)PROPERTY_UNATTENDED_PROGRESS_INTERFACE_PROVIDER, (Class)this.getBeanClass(), (String)"Progress interface creation script", (String)("If you would like to implement your own way of displaying progress information for unattended installations, you can do so by returning a custom implementation of <tt>com.install4j.api.context.UnattendedProgressInterface</tt> from this script. If you return <tt>null</tt>, no progress information will be shown just as if this script had not been set. There is a default implementation <tt>com.install4j.api.context.DefaultUnattendedProgressInterface</tt> that does nothing for all its operations. You can derive from that class if you just need to implement a few particular methods in the progress interface.<p>If you just need a simple dialog that shows progress information in unattended mode, please choose the \"" + String.valueOf(ExecutionMode.UNATTENDED_WITH_PROGRESS) + "\" execution mode instead.</p>"), UnattendedProgressInterface.class, null).setCodeGalleryTags(new String[]{PROPERTY_UNATTENDED_PROGRESS_INTERFACE_PROVIDER})));
        this.addPropertyDescriptor(this.categoryExecutionModes(Install4JPropertyDescriptor.create((String)PROPERTY_ALLOW_CONSOLE, (Class)this.getBeanClass(), (String)"Allow console installations", (String)"If selected, the user can pass <tt>-c</tt> as an argument to run the installer application on the console. The installer asks for user input on the console in that mode. Please see the corresponding help topic on installer modes for more information. All standard actions and standard screens support console installations, form screens are also fully mapped to console installers. If your policy forbids console installations or if you include custom code that cannot handle console installations, you can disable them by deselecting this property.")));
        this.addPropertyDescriptor(BeanInfoUtil.reparent(PROPERTY_ALLOW_CONSOLE, Install4JPropertyDescriptor.create((String)PROPERTY_UNIX_FALLBACK_TO_CONSOLE, (Class)this.getBeanClass(), (String)"Fall back to console mode on Unix", (String)"On Unix, users often operate in environments where no X11 server is available and no GUI can be displayed. The installer will fall back to console mode if console mode execution is allowed and this option is selected. Otherwise, an error message will be displayed that tells the user how to invoke the installer in console mode.")));
        this.addPropertyDescriptor(BeanInfoUtil.reparent(PROPERTY_ALLOW_CONSOLE, Install4JPropertyDescriptor.create((String)PROPERTY_DISABLE_CONSOLE_ON_WINDOWS, (Class)this.getBeanClass(), (String)"Disable console mode on Windows", (String)"Offer console mode only on non-Windows platforms.")));
        ScriptPropertyDescriptor scriptPropertyDescriptor = ScriptPropertyDescriptor.create((String)PROPERTY_CONSOLE_SCREEN_CHANGE_HANDLER, (Class)this.getBeanClass(), (String)"Console screen change handler", (String)"By default, a screen in console mode does not show any particular separation. You insert your own custom display with this script. The title parameter gives you access to the title of the screen. In console mode, screens display their subtitle only, so the title string will not be displayed again.", Void.TYPE, (ScriptParameter[])new ScriptParameter[]{new ScriptParameter("console", Console.class), new ScriptParameter("title", String.class)});
        scriptPropertyDescriptor.setCodeGalleryTags(new String[]{PROPERTY_CONSOLE_SCREEN_CHANGE_HANDLER});
        this.addPropertyDescriptor(BeanInfoUtil.reparent(PROPERTY_ALLOW_CONSOLE, (Install4JPropertyDescriptor)scriptPropertyDescriptor));
        this.addPropertyDescriptor(this.categoryCustomizationOptions((Install4JPropertyDescriptor)ScriptPropertyDescriptor.create((String)PROPERTY_HELP_CUSTOMIZER, (Class)this.getBeanClass(), (String)"Help customizer script", (String)"If the user starts the installer application with one of the arguments <tt>-h -help /?</tt>, help regarding the available command-line options will be displayed. If you have your own command-line options, you can customize this help with this script. The script receives a <tt>List</tt> containing <tt>String</tt> arrays of length 2 with the options and explanations. You can add options like this: <tt>options.add(new String[] {\"/mySwitch\", \"Explanation of mySwitch\"}}</tt>. You can also delete default options in the list.Attention: The context parameter has not been initialized at that point.<p>In order to get extra command line arguments in the installer, call <tt>context.getExtraCommandLineArguments()</tt> in any script.</p>", Void.TYPE, (ScriptParameter[])new ScriptParameter[]{new ScriptParameter("options", (ParameterizedType)StringArrayList.class.getGenericInterfaces()[0])})));
        this.addPropertyDescriptor(this.categoryExecutionModes(Install4JPropertyDescriptor.create((String)PROPERTY_EXECUTION_MODE, (Class)this.getBeanClass(), (String)"Default execution mode", (String)"The default execution mode for the installer application. By default, a GUI wizard will be shown, but it is also possible to run in console mode or unattended mode by default.")));
        this.addPropertyDescriptor(BeanInfoUtil.reparent(PROPERTY_EXECUTION_MODE, Install4JPropertyDescriptor.create((String)PROPERTY_SPLASH_MESSAGE, (Class)this.getBeanClass(), (String)"Title for progress dialog", (String)"The title for the progress dialog, for example \"Updating installation\".This title and the unattended mode with a progress window can also be set by passing <tt>-splash [title]</tt> as an argument from the command line.").setVisibilityDiscriminator((bean, object) -> object == ExecutionMode.UNATTENDED_WITH_PROGRESS)));
        this.addPropertyDescriptor(BeanInfoUtil.reparent(PROPERTY_EXECUTION_MODE, Install4JPropertyDescriptor.create((String)PROPERTY_UNATTENDED_ALERTS, (Class)this.getBeanClass(), (String)"Show alerts", (String)"By default, no alerts are shown in unattended mode. This includes messages boxes, error alerts and questions. By selecting this  property, alerts are enabled for unattended executions with a progress dialog.<p>This mode can also be activated by passing <tt>-alerts</tt> as an argument from the command line.</p>").setVisibilityDiscriminator((bean, object) -> object == ExecutionMode.UNATTENDED_WITH_PROGRESS)));
        this.addPropertyDescriptor(this.categoryExecutionModes(Install4JPropertyDescriptor.create((String)PROPERTY_WINDOWS_CONSOLE_EXECUTABLE, (Class)this.getBeanClass(), (String)"Windows console executable", (String)"If selected, a console executable will be created on Windows. A non-hideable console will be shown when the installer is double-clicked in the explorer. This improves the user experience for a console-only installer (default execution mode set to console) and allows execution through <tt>rsh</tt>.")));
        this.addPropertyDescriptor(this.categoryGuiOptions(Install4JPropertyDescriptor.create((String)PROPERTY_FRAME_WIDTH, (Class)this.getBeanClass(), (String)"Window width", (String)"The width of the window displayed by the installer application. The default value is 500. If the \"Size client area\" property is selected, this does not include the size of the window frame border.")));
        this.addPropertyDescriptor(this.categoryGuiOptions(Install4JPropertyDescriptor.create((String)PROPERTY_FRAME_HEIGHT, (Class)this.getBeanClass(), (String)"Window height", (String)"The height of the window displayed by the installer application. The default value is 390.If the \"Size client area\" property is selected, this does not include the size of the window frame border.")));
        this.addPropertyDescriptor(this.categoryGuiOptions(Install4JPropertyDescriptor.create((String)PROPERTY_FRAME_SIZE_CLIENT_AREA, (Class)this.getBeanClass(), (String)"Size client area", (String)"If selected, the supplied size for the window will not be applied to the outer dimensions of the window, but to the actually usable area inside the window. Unusually large window frame borders can occur due to user settings (accessibility, window themes, etc.) and may interfere with banner images or introduce unwanted scroll bars to form screens.")));
        this.addPropertyDescriptor(this.categoryGuiOptions(Install4JPropertyDescriptor.create((String)PROPERTY_RESIZABLE, (Class)this.getBeanClass(), (String)"Resizable", (String)"If selected, the window displayed by the installer application is resizable.")));
        this.addPropertyDescriptor(this.categoryExecutionOptions(Install4JPropertyDescriptor.create((String)PROPERTY_VM_PARAMETERS, (Class)this.getBeanClass(), (String)"VM parameters", (String)"If you need to pass special VM parameters to the installer application, you can enter them here. A common case would be to raise the maximum heap size with a different -Xmx parameter if your installers require a lot of memory.")));
        this.addPropertyDescriptor(this.categoryExecutionOptions(Install4JPropertyDescriptor.create((String)PROPERTY_ARGUMENTS, (Class)this.getBeanClass(), (String)"Arguments", (String)"If you need to pass fixed default arguments to the installer application, you can enter them here. For example, if you want to display a splash screen in unattended mode by default, you can set the arguments to <tt>-splash \"Installing ...\"</tt>. Please note that command line arguments will be appended to this list, so it is not possible to \"override\" a fixed argument from the command line.")));
        this.addPropertyDescriptor(this.categoryExecutionOptions(Install4JPropertyDescriptor.create((String)PROPERTY_ROLLBACK, (Class)this.getBeanClass(), (String)"Rollback on failure", (String)"If selected, the installer application will try to restore the state before the last rollback barrier by rolling back all actions that were executed since the last barrier. Any screen or action can be selected as a rollback barrier with the property \"Rollback barrier\". If no rollback barrier was encountered, all executed actions will be rolled back.")));
        this.addPropertyDescriptor(this.categoryWindows(Install4JPropertyDescriptor.create((String)PROPERTY_CUSTOMIZE_VERSION_INFO, (Class)this.getBeanClass(), (String)"Customize version info", (String)"If selected, you can customize the fields of the Windows version info in the nested properties. A Windows version info resource is always generated for the executable with default values for product name and file version taken from the general settings.")));
        this.addPropertyDescriptor(BeanInfoUtil.reparent(PROPERTY_CUSTOMIZE_VERSION_INFO, Install4JPropertyDescriptor.create((String)PROPERTY_VERSION_INFO_PRODUCT_NAME, (Class)this.getBeanClass(), (String)"Product name", (String)"The product name field in the version resource. If empty, the full name from the general settings is used.", (String)"noInstallerVariables")).setEmptyMessage("[Default]"));
        this.addPropertyDescriptor(BeanInfoUtil.reparent(PROPERTY_CUSTOMIZE_VERSION_INFO, Install4JPropertyDescriptor.create((String)PROPERTY_VERSION_INFO_FILE_VERSION, (Class)this.getBeanClass(), (String)"File version", (String)"The file version field in the version resource. If empty, the version from the general settings is used. The file version must consist of four numbers separated by spaces, commas or dots.", (String)"noInstallerVariables")).setEmptyMessage("[Default]"));
        this.addPropertyDescriptor(BeanInfoUtil.reparent(PROPERTY_CUSTOMIZE_VERSION_INFO, Install4JPropertyDescriptor.create((String)PROPERTY_VERSION_INFO_INTERNAL_NAME, (Class)this.getBeanClass(), (String)"Internal name", (String)"The internal name field in the version resource. If empty, the short name from the general settings is used.", (String)"noInstallerVariables")).setEmptyMessage("[Default]"));
        this.addPropertyDescriptor(BeanInfoUtil.reparent(PROPERTY_CUSTOMIZE_VERSION_INFO, Install4JPropertyDescriptor.create((String)PROPERTY_VERSION_INFO_FILE_DESCRIPTION, (Class)this.getBeanClass(), (String)"File description", (String)"The file description field in the version resource. If empty, the full name from the general settings is used.", (String)"noInstallerVariables")).setEmptyMessage("[Default]"));
        this.addPropertyDescriptor(BeanInfoUtil.reparent(PROPERTY_CUSTOMIZE_VERSION_INFO, Install4JPropertyDescriptor.create((String)PROPERTY_VERSION_INFO_COPYRIGHT, (Class)this.getBeanClass(), (String)"Copyright", (String)"The copyright field in the version resource. If empty, the publisher name from the general settings is used.", (String)"noInstallerVariables")).setEmptyMessage("[Default]"));
        this.addPropertyDescriptor(Install4JPropertyDescriptor.create((String)PROPERTY_USE_CUSTOM_ICON, (Class)this.getBeanClass(), (String)"", (String)""));
        this.addPropertyDescriptor(Install4JPropertyDescriptor.create((String)PROPERTY_CUSTOM_ICON_IMAGE_FILES, (Class)this.getBeanClass(), (String)"", (String)""));
    }

    protected Install4JPropertyDescriptor categoryExecutionModes(Install4JPropertyDescriptor install4JPropertyDescriptor) {
        install4JPropertyDescriptor.setPropertyCategory("Execution Modes");
        return install4JPropertyDescriptor;
    }

    protected Install4JPropertyDescriptor categoryGuiOptions(Install4JPropertyDescriptor install4JPropertyDescriptor) {
        install4JPropertyDescriptor.setPropertyCategory(CATEGORY_GUI_OPTIONS);
        return install4JPropertyDescriptor;
    }

    protected Install4JPropertyDescriptor categoryExecutionOptions(Install4JPropertyDescriptor install4JPropertyDescriptor) {
        install4JPropertyDescriptor.setPropertyCategory("Execution Options");
        return install4JPropertyDescriptor;
    }

    protected Install4JPropertyDescriptor categoryCustomizationOptions(Install4JPropertyDescriptor install4JPropertyDescriptor) {
        install4JPropertyDescriptor.setPropertyCategory("General Customization Options");
        return install4JPropertyDescriptor;
    }

    protected Install4JPropertyDescriptor categoryWindows(Install4JPropertyDescriptor install4JPropertyDescriptor) {
        install4JPropertyDescriptor.setPropertyCategory("Windows");
        return install4JPropertyDescriptor;
    }

    protected Install4JPropertyDescriptor categoryUnix(Install4JPropertyDescriptor install4JPropertyDescriptor) {
        install4JPropertyDescriptor.setPropertyCategory("Unix");
        return install4JPropertyDescriptor;
    }

    public void validateBean(Bean bean) throws BeanValidationException {
        Application application = (Application)bean;
        if (application.getExecutionMode() == ExecutionMode.UNATTENDED_WITH_PROGRESS) {
            this.checkNotEmpty(PROPERTY_SPLASH_MESSAGE, bean);
        }
    }

    protected void setIcons(BeanIconHolder beanIconHolder) {
        BeanInfoUtil.setIcons(beanIconHolder, this);
    }

    private static interface StringArrayList
    extends List<String[]> {
    }
}

