package com.install4j.api.update;

import com.install4j.runtime.installer.helper.content.Downloader;

/**
 * Enumeration class that represents the different display modes. These values are used as an argument for
 * {@link UpdateChecker#getUpdateDescriptor(String, ApplicationDisplayMode)}.
 * @author ej-technologies GmbH
 */
public enum ApplicationDisplayMode {

    /**
     * The invoking application runs with a Swing GUI. Displaying a proxy dialog is acceptable.
     */
    GUI("GUI", Downloader.MODE_GUI),

    /**
     * The invoking application runs on the command line. Asking for proxy information on the command line
     * is acceptable.
     */
    CONSOLE("Console", Downloader.MODE_CONSOLE),

    /**
     * The invoking application does not take user input from a GUI or on the command line. Proxy information
     * cannot be supplied by the user.
     */
    UNATTENDED("Unattended", Downloader.MODE_UNATTENDED);

    private final String description;
    private final int intValue;

    ApplicationDisplayMode(String description, int value) {
        this.description = description;
        this.intValue = value;
    }

    /**
     * Convert to an int value.
     * @return the int value
     */
    public int getIntValue() {
        return intValue;
    }

    /**
     * Convert int value to constant.
     * @param value the int value
     * @return the constant
     */
    public static ApplicationDisplayMode getFromIntValue(int value) {
        for (ApplicationDisplayMode applicationDisplayMode : values()) {
            if (applicationDisplayMode.getIntValue() == value) {
                return applicationDisplayMode;
            }
        }
        return null;
    }

    @Override
    public String toString() {
        return description;
    }
}