package com.install4j.api.laf;

import javax.swing.*;

/**
 * Interface that must be implemented by a tri-state check box.
 * Tri-state check boxes are returned by {@link LookAndFeelEnhancer#createTriStateCheckBox()}.
 * <p>
 * Note that when {@link JCheckBox#setSelected(boolean)} is called,
 * the indeterminate state must be set to false.
 * </p>
 *
 * @author ej-technologies GmbH
 */
public interface IndeterminateStateComponent {
    /**
     * Sets whether the checkbox is in the third, indeterminate state.
     * @param indeterminate if {@code false} is passed, the checkbox must revert
     *                      to the previous determinate state.
     */
    void setIndeterminate(boolean indeterminate);
}
