package com.install4j.api.events;

/**
 * The interface that must be implemented by classes who are interested in installer events.
 * Event listeners are registered with the {@code Context}.
 * @author ej-technologies GmbH
 * @see com.install4j.api.context.Context#addInstallerEventListener(InstallerEventListener)
 * @see EventType
 * @see InstallerEvent
 * @see InstallerFileEvent
 *
 */
public interface InstallerEventListener {

    /**
     * Called when an installer event is fired.
     * @param event the event
     */
    void installerEvent(InstallerEvent event);

}
