package com.install4j.api;

import com.install4j.runtime.installer.helper.apiimpl.JVMSelectorImpl;

import java.io.File;

/**
 * With this class, you can retrieve the installed JVMs on Windows, Linux and Unix systems.
 * Additionally, you can set the preferred VM for your application.
 */
public class JVMSelector {

    private JVMSelector() {
    }


    /**
     * Returns JVMs found in standard locations.
     * On Windows, the registry is used to get the JVMs.
     * On Linux/Unix and macOS, this method searches the usual locations for JVMs.
     * Please be aware that this method can take some time on Linux/Unix as it
     * executes java to gather version information.
     * @return an array of JVMLocation objects. See this class for more detail.
     */
    public static JVMLocation[] getJVMLocations() {
        return JVMSelectorImpl.getJVMLocations();
    }

    /**
     * Returns JVMs found in standard locations with the given version requirements.
     * On Windows, the registry is used to get the JVMs.
     * On Linux/Unix and macOS, this method searches the usual locations for JVMs.
     * Please be aware that this method can take some time on Linux/Unix as it
     * executes java to gather version information.
     * @param minVersion the minimum java version
     * @param maxVersion the maximum java version
     * @param jdkOnly only JDKs
     * @param additionalLocations additional locations that should be tested for JVMs
     * @return an array of JVMLocation objects. See this class for more detail.
     */
    public static JVMLocation[] getJVMLocations(String minVersion, String maxVersion, boolean jdkOnly, File[] additionalLocations) {
        return JVMSelectorImpl.getJVMLocations(minVersion, maxVersion, jdkOnly, additionalLocations);
    }

    /**
     * Checks if this directory contains a JVM with the specified parameters and returns the location object.
     * The versions can be empty Strings if there should be no restriction.
     * @param javaHome the directory to check
     * @param minVersion the minimum java version
     * @param maxVersion the maximum java version
     * @param jdkOnly only JDKs
     * @return a JVMLocation object or null. See this class for more detail.
     */
    public static JVMLocation getJVMLocation(File javaHome, String minVersion, String maxVersion, boolean jdkOnly) {
        return JVMSelectorImpl.getJVMLocation(javaHome, minVersion, maxVersion, jdkOnly);
    }

    /**
     * Set the preferred JRE/JDK for your application. As long as this JRE/JDK exists and
     * fulfills the version requirement of your application, it will be used.
     * This method has no effect on macOS.
     * @param javaHome the base directory of the JDK/JRE.
     */
    public static void setPreferredJVM(String javaHome) {
        JVMSelectorImpl.setPreferredJVM(javaHome);
    }


    /**
     * The interface providing information about a JVM.
     */
    public interface JVMLocation {
        /**
         * Returns the base directory of a Java installation.
         * @return the JVM's base dir
         */
        File getJavaHome();

        /**
         * Returns the version of the JVM.
         * @return the JVM's version
         */
        String getVersion();

        /**
         * Returns whether this a JDK installation.
         * @return true if this a JDK
         */
        boolean isJDK();

    }

}
