<?xml version="1.0" encoding="ISO-8859-1"?>
<!-- install4j 12.0 -->
<xsl:transform version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns=""
               xmlns:math="http://exslt.org/math"
               xmlns:ext="com.install4j.config.XsltExtensions"
               extension-element-prefixes="ext math">

  <xsl:include href="common.xsl"/>

  <xsl:template match="/install4j/mediaSets/macosFolder | /install4j/mediaSets/macosArchive | /install4j/mediaSets/macosFolderArchive">
    <xsl:copy>
      <xsl:copy-of select="@*"/>
      <xsl:if test="topLevelFiles/*">
        <xsl:attribute name="dmgStylingMode">none</xsl:attribute>
      </xsl:if>
      <xsl:apply-templates/>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="/install4j/application/codeSigning/windowsDigestSigningExectuable">
    <windowsDigestSigningExecutable>
      <xsl:copy-of select="@*"/>
      <xsl:apply-templates/>
    </windowsDigestSigningExecutable>
  </xsl:template>

  <xsl:template match="/install4j/application/codeSigning/macDigestSigningExectuable">
    <macDigestSigningExecutable>
      <xsl:copy-of select="@*"/>
      <xsl:apply-templates/>
    </macDigestSigningExecutable>
  </xsl:template>

  <xsl:template match="//action[
    @beanClass='com.install4j.runtime.beans.actions.net.HttpRequestAction' or
    @beanClass='com.install4j.runtime.beans.actions.net.DownloadFileAction' or
    @beanClass='com.install4j.runtime.beans.actions.net.UploadFileAction' or
    @beanClass='com.install4j.runtime.beans.actions.update.CheckForUpdateAction'
    ]/serializedBean/property[@name='askForProxy']"/>

  <xsl:template match="serializedBean/property[
    @name='textFontSizePercent' or
    @name='textFontStyle' or
    @name='textFontType' or
    @name='textFont' or
    @name='linkLabelFontSizePercent' or
    @name='linkLabelFontStyle' or
    @name='linkLabelFontType' or
    @name='linkLabelFont' or
    @name='linkLabelActiveColor' or
    @name='linkLabelColor' or
    @name='labelFontSizePercent' or
    @name='labelFontStyle' or
    @name='labelFontType' or
    @name='labelFont' or
    @name='iconTextGap' or
    @name='labelColor' or
    @name='labelActiveColor' or
    @name='valueLabelFontSizePercent' or
    @name='valueLabelFontStyle' or
    @name='valueLabelFontType' or
    @name='valueLabelFont' or
    @name='valueIconTextGap' or
    @name='valueLabelColor'
  ]"/>

  <xsl:template match="serializedBean">
    <xsl:copy>
      <xsl:apply-templates select="." mode="default"/>
      <xsl:apply-templates select="." mode="label"/>
      <xsl:apply-templates select="." mode="valueLabel"/>
      <xsl:apply-templates/>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="serializedBean" mode="default">
    <xsl:if test="property[@name='textFontType'] or property[@name='linkLabelFontType'] or property[@name='linkLabelActiveColor'] or property[@name='linkLabelColor']">
      <property name="widgetStyleId" type="null" />
      <property name="widgetStyle">
        <xsl:if test="property[@name='textFontType' or @name='linkLabelFontType']">
          <property name="fontDescriptor">
            <property name="fontType">
              <xsl:copy-of select="property[@name='textFontType' or @name='linkLabelFontType']/@*[name() != 'name'] | property[@name='textFontType' or @name='linkLabelFontType']/*"/>
            </property>
            <xsl:if test="property[@name='textFontSizePercent'] or property[@name='linkLabelFontSizePercent']">
              <property name="fontSizePercent">
                <xsl:copy-of select="property[@name='textFontSizePercent' or @name='linkLabelFontSizePercent']/@*[name() != 'name'] | property[@name='textFontSizePercent' or @name='linkLabelFontSizePercent']/*"/>
              </property>
            </xsl:if>
            <xsl:if test="property[@name='textFontStyle'] or property[@name='linkLabelFontStyle']">
              <property name="fontStyle">
                <xsl:copy-of select="property[@name='textFontStyle' or @name='linkLabelFontStyle']/@*[name() != 'name'] | property[@name='textFontStyle' or @name='linkLabelFontStyle']/*"/>
              </property>
            </xsl:if>
            <xsl:if test="property[@name='textFont'] or property[@name='linkLabelFont']">
              <property name="font">
                <xsl:copy-of select="property[@name='textFont' or @name='linkLabelFont']/@*[name() != 'name'] | property[@name='textFont' or @name='linkLabelFont']/*"/>
              </property>
            </xsl:if>
          </property>
        </xsl:if>
        <xsl:if test="property[@name='linkLabelActiveColor']">
          <property name="pressedColor">
            <xsl:copy-of select="property[@name='linkLabelActiveColor']/@*[name() != 'name'] | property[@name='linkLabelActiveColor']/*"/>
          </property>
        </xsl:if>
        <xsl:if test="property[@name='linkLabelColor']">
          <property name="foregroundColor">
            <xsl:copy-of select="property[@name='linkLabelColor']/@*[name() != 'name'] | property[@name='linkLabelColor']/*"/>
          </property>
        </xsl:if>
      </property>
    </xsl:if>
  </xsl:template>

  <xsl:template match="serializedBean" mode="label">
    <xsl:if test="property[@name='labelFontType'] or property[@name='labelColor'] or property[@name='iconTextGap']">
      <property name="labelWidgetStyleId" type="null" />
      <property name="labelWidgetStyle">
        <xsl:if test="property[@name='labelFontType']">
          <property name="fontDescriptor">
            <property name="fontType">
              <xsl:copy-of select="property[@name='labelFontType']/@*[name() != 'name'] | property[@name='labelFontType']/*"/>
            </property>
            <xsl:if test="property[@name='labelFontSizePercent']">
              <property name="fontSizePercent">
                <xsl:copy-of select="property[@name='labelFontSizePercent']/@*[name() != 'name'] | property[@name='labelFontSizePercent']/*"/>
              </property>
            </xsl:if>
            <xsl:if test="property[@name='labelFontStyle']">
              <property name="fontStyle">
                <xsl:copy-of select="property[@name='labelFontStyle']/@*[name() != 'name'] | property[@name='labelFontStyle']/*"/>
              </property>
            </xsl:if>
            <xsl:if test="property[@name='labelFont']">
              <property name="font">
                <xsl:copy-of select="property[@name='labelFont']/@*[name() != 'name'] | property[@name='labelFont']/*"/>
              </property>
            </xsl:if>
          </property>
        </xsl:if>
        <xsl:if test="property[@name='iconTextGap']">
          <property name="iconTextGap">
            <xsl:copy-of select="property[@name='iconTextGap']/@*[name() != 'name']"/>
          </property>
        </xsl:if>
        <xsl:if test="property[@name='labelColor']">
          <property name="foregroundColor">
            <xsl:copy-of select="property[@name='labelColor']/@*[name() != 'name'] | property[@name='labelColor']/*"/>
          </property>
        </xsl:if>
      </property>
    </xsl:if>
  </xsl:template>

  <xsl:template match="serializedBean" mode="valueLabel">
    <xsl:if test="property[@name='valueLabelFontType'] or property[@name='valueLabelColor'] or property[@name='valueIconTextGap']">
      <property name="valueLabelWidgetStyleId" type="null" />
      <property name="valueLabelWidgetStyle">
        <xsl:if test="property[@name='valueLabelFontType']">
          <property name="fontDescriptor">
            <property name="fontType">
              <xsl:copy-of select="property[@name='valueLabelFontType']/@*[name() != 'name'] | property[@name='valueLabelFontType']/*"/>
            </property>
            <xsl:if test="property[@name='valueLabelFontSizePercent']">
              <property name="fontSizePercent">
                <xsl:copy-of select="property[@name='valueLabelFontSizePercent']/@*[name() != 'name'] | property[@name='valueLabelFontSizePercent']/*"/>
              </property>
            </xsl:if>
            <xsl:if test="property[@name='valueLabelFontStyle']">
              <property name="fontStyle">
                <xsl:copy-of select="property[@name='valueLabelFontStyle']/@*[name() != 'name'] | property[@name='valueLabelFontStyle']/*"/>
              </property>
            </xsl:if>
            <xsl:if test="property[@name='valueLabelFont']">
              <property name="font">
                <xsl:copy-of select="property[@name='valueLabelFont']/@*[name() != 'name'] | property[@name='valueLabelFont']/*"/>
              </property>
            </xsl:if>
          </property>
        </xsl:if>
        <xsl:if test="property[@name='valueIconTextGap']">
          <property name="iconTextGap">
            <xsl:copy-of select="property[@name='valueIconTextGap']/@*[name() != 'name']"/>
          </property>
        </xsl:if>
        <xsl:if test="property[@name='valueLabelColor']">
          <property name="foregroundColor">
            <xsl:copy-of select="property[@name='valueLabelColor']/@*[name() != 'name'] | property[@name='valueLabelColor']/*"/>
          </property>
        </xsl:if>
      </property>
    </xsl:if>
  </xsl:template>

  <xsl:template match="//action[@beanClass='com.install4j.runtime.beans.actions.desktop.CreateProgramGroupAction']">
    <xsl:copy>
      <xsl:copy-of select="@*[name()!='beanClass']"/>
      <xsl:attribute name="beanClass">com.install4j.runtime.beans.actions.desktop.CreateDefaultStartMenuEntriesAction</xsl:attribute>
      <xsl:apply-templates/>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="serializedBean[parent::action[@beanClass='com.install4j.runtime.beans.actions.desktop.CreateProgramGroupAction']]">
    <xsl:copy>
      <xsl:apply-templates select="@*|node()"/>
      <property name="folderName" type="string">
        <xsl:choose>
          <xsl:when test="property[@name='programGroupName']">
            <xsl:value-of select="property[@name='programGroupName']"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>${installer:sys.programGroupName}</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </property>
      <xsl:if test="not(property[@name='linkDirectory'])">
        <property name="linkDirectory" type="string">
          <xsl:text>${installer:sys.symlinkDir}</xsl:text>
        </property>
      </xsl:if>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="serializedBean[parent::action[@beanClass='com.install4j.runtime.beans.actions.desktop.CreateStartMenuEntryAction']]">
    <xsl:copy>
      <xsl:apply-templates select="@*|node()"/>
      <property name="folderName" type="string">
        <xsl:choose>
          <xsl:when test="property[@name='programGroupName']">
            <xsl:value-of select="property[@name='programGroupName']"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>${installer:sys.programGroupName}</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </property>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="//action[@beanClass='com.install4j.runtime.beans.actions.desktop.CreateProgramGroupAction']/serializedBean/property[@name='addUninstaller' or @name='uninstallerMenuName' or @name='programGroupName']"/>
  <xsl:template match="//action[@beanClass='com.install4j.runtime.beans.actions.desktop.CreateStartMenuEntryAction']/serializedBean/property[@name='programGroupName']"/>

  <xsl:template match="//formComponent/@beanClass[.='com.install4j.runtime.beans.formcomponents.UpdateAlertComponent']">
    <xsl:attribute name="beanClass">com.install4j.runtime.beans.formcomponents.StreamlinedInstallationChooserComponent</xsl:attribute>
  </xsl:template>

  <xsl:template match="//formComponent[@beanClass='com.install4j.runtime.beans.formcomponents.UpdateAlertComponent']/serializedBean/property[@name='updateCheck']"/>

  <xsl:template match="//formComponent[@beanClass='com.install4j.runtime.beans.formcomponents.UpdateAlertComponent']/externalParametrizationPropertyNames/propertyName[.='updateCheck']">
    <propertyName>streamlinedInstallationStrategy</propertyName>
  </xsl:template>

  <xsl:template match="formComponent[@beanClass='com.install4j.runtime.beans.formcomponents.UpdateAlertComponent' and not(serializedBean)]">
    <xsl:copy>
      <xsl:apply-templates select="@*|node()"/>
      <serializedBean>
        <property name="streamlinedInstallationStrategy" type="enum" class="com.install4j.runtime.beans.formcomponents.StreamlinedInstallationStrategy" value="UPDATE_ONLY"/>
      </serializedBean>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="serializedBean[parent::formComponent[@beanClass='com.install4j.runtime.beans.formcomponents.UpdateAlertComponent']]">
    <xsl:copy>
      <xsl:apply-templates select="@*|node()"/>
      <property name="streamlinedInstallationStrategy" type="enum" class="com.install4j.runtime.beans.formcomponents.StreamlinedInstallationStrategy">
        <xsl:attribute name="value">
          <xsl:choose>
            <xsl:when test="property[@name='updateCheck' and @value='false']"><xsl:text>NEVER</xsl:text></xsl:when>
            <xsl:otherwise><xsl:text>UPDATE_ONLY</xsl:text></xsl:otherwise>
          </xsl:choose>
        </xsl:attribute>
      </property>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="group[@beanClass='com.install4j.runtime.beans.groups.VerticalFormComponentGroup' and serializedBean/property[@name='imageFile']/object/string[.='${compiler:sys.install4jHome}/resource/styles/wizard.png']]/serializedBean/property[@name='imageEdgeBackgroundColor' or @name='imageEdgeBorder']"/>

  <xsl:template match="serializedBean[parent::group[@beanClass='com.install4j.runtime.beans.groups.VerticalFormComponentGroup' and serializedBean/property[@name='imageFile']/object/string[.='${compiler:sys.install4jHome}/resource/styles/wizard.png']]]">
    <xsl:copy>
      <xsl:apply-templates select="@*|node()"/>
      <property name="imageEdgeBackgroundColor">
        <object class="com.install4j.runtime.beans.LightOrDarkColor">
          <object class="java.awt.Color">
            <int>27</int>
            <int>143</int>
            <int>220</int>
            <int>255</int>
          </object>
          <object class="java.awt.Color">
            <int>0</int>
            <int>73</int>
            <int>150</int>
            <int>255</int>
          </object>
        </object>
      </property>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="//action[@beanClass='com.install4j.runtime.beans.actions.misc.RequestPrivilegesAction']/serializedBean/property[@name='updateInstallationDirectory']"/>

  <xsl:template name="addStartupSetInstallationDirectoryAction">
    <xsl:param name="forceAllUsers" select="string(boolean(//application[@id='installer']//screens//action[@beanClass='com.install4j.runtime.beans.actions.misc.RequestPrivilegesAction']))"/>

    <action beanClass="com.install4j.runtime.beans.actions.control.SetInstallationDirectoryAction" actionElevationType="none">
      <xsl:call-template name="addIdAttribute"/>
      <xsl:if test="@multiExec='true'">
        <xsl:attribute name="multiExec">true</xsl:attribute>
      </xsl:if>
      <serializedBean>
        <xsl:if test="$forceAllUsers = 'true'">
          <property name="installationScope" type="enum" class="com.install4j.runtime.beans.actions.control.InstallationScope" value="ALL_USERS" />
        </xsl:if>
        <property name="searchForPreviousInstallation" type="boolean" value="{string(not(/install4j/installerGui/@suggestPreviousLocations) or /install4j/installerGui/@suggestPreviousLocations = 'true')}" />
        <property name="includeUserSpecific" type="boolean" value="{$forceAllUsers}" />
      </serializedBean>
    </action>
  </xsl:template>

  <xsl:template match="//application[@id='installer']/startup/screen">
    <xsl:copy>
      <xsl:apply-templates select="@*"/>
      <xsl:if test="not(//application[@id='installer']/startup/screen/actions)">
        <actions>
          <xsl:call-template name="addStartupSetInstallationDirectoryAction"/>
        </actions>
      </xsl:if>
      <xsl:apply-templates/>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="//application[@id='installer']/startup/screen/actions">
    <xsl:copy>
      <xsl:apply-templates select="@*"/>
      <xsl:if test="not(//application[@id='installer']/startup/screen/actions/action[@beanClass='com.install4j.runtime.beans.actions.misc.RequestPrivilegesAction'])">
        <xsl:call-template name="addStartupSetInstallationDirectoryAction"/>
      </xsl:if>
      <xsl:apply-templates/>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="//application[@id='installer']//startup//action[@beanClass='com.install4j.runtime.beans.actions.misc.RequestPrivilegesAction']">
    <xsl:copy>
      <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
    <xsl:call-template name="addStartupSetInstallationDirectoryAction">
        <xsl:with-param name="forceAllUsers" select="'false'"/>
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="//application[@id='installer']//screens//action[@beanClass='com.install4j.runtime.beans.actions.misc.RequestPrivilegesAction']">
    <xsl:copy>
      <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
    <action beanClass="com.install4j.runtime.beans.actions.control.SetInstallationDirectoryAction" actionElevationType="none">
      <xsl:call-template name="addIdAttribute"/>
      <xsl:if test="@multiExec='true'">
        <xsl:attribute name="multiExec">true</xsl:attribute>
      </xsl:if>
      <serializedBean>
        <property name="searchForPreviousInstallation" type="boolean" value="false" />
      </serializedBean>
    </action>
  </xsl:template>

</xsl:transform>
