/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.aws.lw.client;

import com.github.davidmoten.aws.lw.client.Client;
import com.github.davidmoten.aws.lw.client.MultipartOutputStream;
import com.github.davidmoten.aws.lw.client.Request;
import com.github.davidmoten.aws.lw.client.internal.Retries;
import com.github.davidmoten.aws.lw.client.internal.util.Preconditions;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public final class Multipart {
    private Multipart() {
    }

    public static Builder s3(Client s3) {
        Preconditions.checkNotNull(s3);
        return new Builder(s3);
    }

    private static void copy(InputStream in, OutputStream out) throws IOException {
        int n;
        byte[] buffer = new byte[8192];
        while ((n = in.read(buffer)) != -1) {
            out.write(buffer, 0, n);
        }
    }

    public static final class Builder3 {
        private final Builder b;

        Builder3(Builder b) {
            this.b = b;
        }

        public Builder3 executor(ExecutorService executor) {
            Preconditions.checkNotNull(executor, "executor cannot be null");
            this.b.executor = executor;
            return this;
        }

        public Builder3 partTimeout(long duration, TimeUnit unit) {
            Preconditions.checkArgument(duration > 0L, "duration must be positive");
            Preconditions.checkNotNull(unit, "unit cannot be null");
            this.b.timeoutMs = unit.toMillis(duration);
            return this;
        }

        public Builder3 partSize(int partSize) {
            Preconditions.checkArgument(partSize >= 0x500000);
            this.b.partSize = partSize;
            return this;
        }

        public Builder3 partSizeMb(int partSizeMb) {
            return this.partSize(partSizeMb * 1024 * 1024);
        }

        public Builder3 maxAttemptsPerAction(int maxAttempts) {
            Preconditions.checkArgument(maxAttempts >= 1, "maxAttempts must be at least one");
            this.b.retries = this.b.retries.withMaxAttempts(maxAttempts);
            return this;
        }

        public Builder3 retryInitialInterval(long duration, TimeUnit unit) {
            Preconditions.checkArgument(duration >= 0L, "duration cannot be negative");
            Preconditions.checkNotNull(unit, "unit cannot be null");
            this.b.retries = this.b.retries.withInitialIntervalMs(unit.toMillis(duration));
            return this;
        }

        public Builder3 retryBackoffFactor(double factor) {
            Preconditions.checkArgument(factor >= 0.0, "retryBackoffFactory cannot be negative");
            this.b.retries = this.b.retries.withBackoffFactor(factor);
            return this;
        }

        public Builder3 retryMaxInterval(long duration, TimeUnit unit) {
            Preconditions.checkArgument(duration >= 0L, "duration cannot be negative");
            Preconditions.checkNotNull(unit, "unit cannot be null");
            this.b.retries = this.b.retries.withMaxIntervalMs(unit.toMillis(duration));
            return this;
        }

        public Builder3 retryJitter(double jitter) {
            Preconditions.checkArgument(jitter >= 0.0 && jitter <= 1.0, "jitter must be between 0 and 1");
            this.b.retries = this.b.retries.withJitter(jitter);
            return this;
        }

        public Builder3 transformCreateRequest(Function<? super Request, ? extends Request> transform) {
            Preconditions.checkNotNull(transform, "transform cannot be null");
            this.b.transform = transform;
            return this;
        }

        public void upload(byte[] bytes, int offset, int length) {
            Preconditions.checkNotNull(bytes, "bytes cannot be null");
            try (MultipartOutputStream out = this.outputStream();){
                ((OutputStream)out).write(bytes, offset, length);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public void upload(byte[] bytes) {
            this.upload(bytes, 0, bytes.length);
        }

        public void upload(File file) {
            Preconditions.checkNotNull(file, "file cannot be null");
            this.upload(() -> new BufferedInputStream(new FileInputStream(file)));
        }

        public void upload(Callable<? extends InputStream> factory) {
            Preconditions.checkNotNull(factory, "factory cannot be null");
            try (InputStream in = factory.call();
                 MultipartOutputStream out = this.outputStream();){
                Multipart.copy(in, out);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public MultipartOutputStream outputStream() {
            if (this.b.executor == null) {
                this.b.executor = Executors.newCachedThreadPool();
            }
            return new MultipartOutputStream(this.b.s3, this.b.bucket, this.b.key, this.b.transform, this.b.executor, this.b.timeoutMs, this.b.retries, this.b.partSize);
        }
    }

    public static final class Builder2 {
        private final Builder b;

        Builder2(Builder b) {
            this.b = b;
        }

        public Builder3 key(String key) {
            Preconditions.checkNotNull(key, "key cannot be null");
            this.b.key = key;
            return new Builder3(this.b);
        }
    }

    public static final class Builder {
        private final Client s3;
        private String bucket;
        public String key;
        public ExecutorService executor;
        public long timeoutMs = TimeUnit.HOURS.toMillis(1L);
        public Function<? super Request, ? extends Request> transform = x -> x;
        public int partSize = 0x500000;
        public Retries<Void> retries;

        Builder(Client s3) {
            this.s3 = s3;
            this.retries = s3.retries().withValueShouldRetry(values -> false);
        }

        public Builder2 bucket(String bucket) {
            Preconditions.checkNotNull(bucket, "bucket cannot be null");
            this.bucket = bucket;
            return new Builder2(this);
        }
    }
}

