/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.buildtools.shadowed.ejt;

import com.install4j.buildtools.shadowed.ejt.CommonApplicationServices;
import java.awt.Image;
import java.awt.Window;
import java.io.File;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.List;

public class UnshadedWrapper
extends CommonApplicationServices {
    private final WeakReference<Object> unshadedInstanceRef;
    private final Method getWindowImageIcons;
    private final Method isFrameworkWindow;
    private final Method beforeAlertOn;
    private final Method getApplicationName;
    private final Method confirmOverwrite;
    private final Method isLocalized;
    private final Method getPreferenceRootPath;

    public UnshadedWrapper(Class<?> unshadedClass, Object unshadedInstance) {
        this.unshadedInstanceRef = new WeakReference<Object>(unshadedInstance);
        this.getWindowImageIcons = this.getDelegateMethod(unshadedClass, "getWindowImageIcons", new Class[0]);
        this.isFrameworkWindow = this.getDelegateMethod(unshadedClass, "isFrameworkWindow", Window.class);
        this.beforeAlertOn = this.getDelegateMethod(unshadedClass, "beforeAlertOn", Window.class);
        this.getApplicationName = this.getDelegateMethod(unshadedClass, "getApplicationName", new Class[0]);
        this.confirmOverwrite = this.getDelegateMethod(unshadedClass, "confirmOverwrite", Window.class, File.class);
        this.isLocalized = this.getDelegateMethod(unshadedClass, "isLocalized", new Class[0]);
        this.getPreferenceRootPath = this.getDelegateMethod(unshadedClass, "getPreferenceRootPath", new Class[0]);
    }

    public boolean isAlive() {
        return this.unshadedInstanceRef.get() != null;
    }

    private Method getDelegateMethod(Class<?> unshadedClass, String methodName, Class ... argumentClasses) {
        try {
            return unshadedClass.getDeclaredMethod(methodName, argumentClasses);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return null;
        }
    }

    private <T> T invokeMethod(Method method, Object ... arguments) {
        return this.invokeMethod((T)null, method, arguments);
    }

    private <T> T invokeMethod(T defaultValue, Method method, Object ... arguments) {
        try {
            Object instance = this.unshadedInstanceRef.get();
            if (method != null && instance != null) {
                return (T)method.invoke(instance, arguments);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return defaultValue;
    }

    @Override
    public List<? extends Image> getWindowImageIcons() {
        return (List)this.invokeMethod(this.getWindowImageIcons, new Object[0]);
    }

    @Override
    public boolean isFrameworkWindow(Window window) {
        return this.invokeMethod(true, this.isFrameworkWindow, window);
    }

    @Override
    public void beforeAlertOn(Window parentWindow) {
        this.invokeMethod(true, this.beforeAlertOn, parentWindow);
    }

    @Override
    public String getApplicationName() {
        return this.invokeMethod("application", this.getApplicationName, new Object[0]);
    }

    @Override
    public boolean confirmOverwrite(Window parent, File selectedFile) {
        return this.invokeMethod(false, this.confirmOverwrite, parent, selectedFile);
    }

    @Override
    public boolean isLocalized() {
        return this.invokeMethod(false, this.isLocalized, new Object[0]);
    }

    @Override
    public String getPreferenceRootPath() {
        return (String)this.invokeMethod(this.getPreferenceRootPath, new Object[0]);
    }
}

