/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.JideSwingUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JComponent;

public class HeavyweightWrapper
extends Panel {
    private Component _component;
    private boolean _heavyweight;
    private final Dimension MIN_DIM = new Dimension(0, 0);

    public HeavyweightWrapper(Component component) {
        this(component, false);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.MIN_DIM;
    }

    public HeavyweightWrapper(Component component, boolean bl2) {
        this._component = component;
        if (this._component != null) {
            ((JComponent)this._component).putClientProperty("HeavyweightWrapper", this);
            this._component.addComponentListener(new ComponentListener(){

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                }

                @Override
                public void componentMoved(ComponentEvent componentEvent) {
                }

                @Override
                public void componentShown(ComponentEvent componentEvent) {
                    HeavyweightWrapper.this.setVisible(true);
                }

                @Override
                public void componentHidden(ComponentEvent componentEvent) {
                    HeavyweightWrapper.this.setVisible(false);
                }
            });
        }
        this.setLayout(new BorderLayout());
        this.setVisible(false);
        this._heavyweight = bl2;
    }

    public boolean isHeavyweight() {
        return this._heavyweight;
    }

    public void setHeavyweight(boolean bl2) {
        this._heavyweight = bl2;
    }

    public void delegateAdd(Container container, Object object) {
        JideSwingUtilities.removeFromParentWithFocusTransfer(this._component);
        if (this.isHeavyweight()) {
            if (this._component.getParent() != this) {
                this.add(this._component);
            }
            if (this.getParent() != container) {
                container.add((Component)this, object);
            }
        } else {
            container.add(this._component, object);
        }
    }

    public void delegateRemove(Container container) {
        JideSwingUtilities.removeFromParentWithFocusTransfer(this._component);
        if (this.isHeavyweight()) {
            this.remove(this._component);
            container.remove(this);
        } else {
            container.remove(this._component);
        }
    }

    public void delegateSetVisible(boolean bl2) {
        if (this.isHeavyweight()) {
            this.setVisible(bl2);
            this._component.setVisible(bl2);
        } else {
            this._component.setVisible(bl2);
        }
    }

    public void delegateSetBounds(Rectangle rectangle) {
        if (this.isHeavyweight()) {
            this.setBounds(rectangle);
            this._component.setBounds(0, 0, rectangle.width, rectangle.height);
        } else {
            this._component.setBounds(rectangle);
        }
    }

    public void delegateSetBounds(int n2, int n3, int n4, int n5) {
        if (this.isHeavyweight()) {
            this.setBounds(n2, n3, n4, n5);
            this._component.setBounds(0, 0, n4, n5);
        } else {
            this._component.setBounds(n2, n3, n4, n5);
        }
    }

    public void delegateSetLocation(int n2, int n3) {
        if (this.isHeavyweight()) {
            this.setLocation(n2, n3);
            this._component.setLocation(0, 0);
        } else {
            this._component.setLocation(n2, n3);
        }
    }

    public void delegateSetLocation(Point point) {
        if (this.isHeavyweight()) {
            this.setLocation(point);
            this._component.setLocation(0, 0);
        } else {
            this._component.setLocation(point);
        }
    }

    public void delegateSetCursor(Cursor cursor) {
        this._component.setCursor(cursor);
    }

    public void delegateSetNull() {
        ((JComponent)this._component).putClientProperty("HeavyweightWrapper", null);
        this._component = null;
    }

    public Container delegateGetParent() {
        if (this.isHeavyweight()) {
            return this.getParent();
        }
        return this._component.getParent();
    }

    public boolean delegateIsVisible() {
        if (this.isHeavyweight()) {
            return this.isVisible();
        }
        return this._component.isVisible();
    }

    public Rectangle delegateGetBounds() {
        if (this.isHeavyweight()) {
            return this.getBounds();
        }
        return this._component.getBounds();
    }

    public void delegateRepaint() {
        if (this.isHeavyweight()) {
            this.repaint();
            this._component.repaint();
        } else {
            this._component.repaint();
        }
    }

    public Component getComponent() {
        return this._component;
    }

    public void setComponent(Component component) {
        this._component = component;
    }
}

