/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.util;

import com.install4j.api.UiUtil;
import com.install4j.api.Util;
import com.install4j.runtime.beans.DynamicLightOrDarkColor;
import com.install4j.runtime.util.PartialLineBorder;
import java.awt.Color;
import java.awt.Font;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class AlertLafHelper {
    public static final float TITLE_FONT_FACTOR = 1.25f;
    private static final Color SEPARATOR_COLOR = new DynamicLightOrDarkColor(() -> new Color(223, 223, 223), () -> UIManager.getColor("Separator.foreground"));

    public static <T extends JComponent> T applyBottomSeparator(T component) {
        component.setBorder(new PartialLineBorder(SEPARATOR_COLOR, 1, 2));
        return component;
    }

    public static <T extends JComponent> T alertFont(T component) {
        if (!Boolean.getBoolean("ejt.noNativeDialogFont") && Util.isWindows()) {
            component.setFont(AlertLafHelper.getAlertFont());
        }
        return component;
    }

    public static Font getAlertFont() {
        return UiUtil.getLookAndFeelEnhancer().getAlertFont();
    }

    public static <T extends JComponent> T makeAlertTitleLabel(T component) {
        AlertLafHelper.alertFont(component);
        Font font = component.getFont();
        float size = font.getFamily().equals("Segoe UI") ? 16.0f * UiUtil.getLookAndFeelEnhancer().getCustomScaleFactor() : (float)font.getSize() * 1.25f;
        component.setFont(font.deriveFont(size));
        component.setForeground(UiUtil.getLookAndFeelEnhancer().getTitleColor());
        return component;
    }
}

