/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend.headless;

import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.screens.FormPanelContainer;
import com.install4j.api.screens.Screen;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.config.LanguageConfig;
import com.install4j.runtime.installer.config.ScreenBeanConfig;
import com.install4j.runtime.installer.controller.ControllerCommand;
import com.install4j.runtime.installer.controller.ReturnToken;
import com.install4j.runtime.installer.frontend.FormPanel;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.VariableResourceBundleWrapper;
import com.install4j.runtime.installer.frontend.headless.AbstractHeadlessScreenExecutor;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.applaunch.ProgressCommunication;
import com.install4j.runtime.installer.helper.console.ConsoleImpl;
import java.util.List;

public abstract class ConsoleScreenExecutor
extends AbstractHeadlessScreenExecutor {
    protected ConsoleScreenExecutor() {
        this.init(true);
    }

    @Override
    public boolean isUnattended() {
        return false;
    }

    @Override
    public boolean isUnattendedAlerts() {
        return false;
    }

    @Override
    public boolean isUnattendedWithProgress() {
        return false;
    }

    @Override
    public boolean isConsole() {
        return true;
    }

    @Override
    protected ControllerCommand handleScreen(ScreenBeanConfig screenConfig) throws UserCanceledException {
        Object[] scriptParameters;
        ControllerCommand controllerCommand;
        Screen screen = screenConfig.getOrInstantiateScreen(false);
        do {
            ConsoleImpl console = ConsoleImpl.getInstance();
            scriptParameters = null;
            if (screen instanceof FormPanelContainer) {
                FormPanel formPanel = new FormPanel(screenConfig.getFormComponentConfigs(), this.getContext(), screen, null, null);
                ((FormPanelContainer)((Object)screen)).setFormPanel(formPanel, formPanel.getFormEnvironment());
                scriptParameters = new Object[]{formPanel.getFormEnvironment()};
            }
            screen.createComponent();
            if (screen.isHidden() || screen.isHiddenForNext()) {
                return null;
            }
            this.getContext().runBooleanScript(screenConfig.getPreActivationClassName(), screen, scriptParameters);
            if (!screen.handleConsole(console)) {
                return ControllerCommand.CANCEL;
            }
            ControllerCommand overriddenCommand = this.getCommandSink().getOverriddenCommand();
            if (overriddenCommand == null) continue;
            return overriddenCommand;
        } while ((controllerCommand = this.runValidationScript(screenConfig, screen, scriptParameters)) == ControllerCommand.CANCEL);
        return controllerCommand;
    }

    @Override
    public ProgressInterface getProgressInterface() {
        return ProgressCommunication.getCurrent().wrap(ConsoleImpl.getInstance());
    }

    @Override
    public void selectLanguage(ReturnToken wakeupToken) {
        ConsoleImpl console = ConsoleImpl.getInstance();
        InstallerConfig config = InstallerConfig.getCurrentInstance();
        List<LanguageConfig> languages = config.getLanguages();
        String systemLanguageId = InstallerUtil.getSupportedSystemLanguageId();
        LanguageConfig systemLanguage = config.isLanguageSelectionInPrincipalLanguage() || systemLanguageId == null ? languages.get(0) : config.getLanguageById(systemLanguageId);
        VariableResourceBundleWrapper messages = Messages.createMessages(systemLanguage);
        console.println(messages.getString(".LanguageSelectionLabel"));
        List<LanguageConfig> sortedList = Messages.sortLanguages(languages, messages);
        int defaultPos = -1;
        for (int i = 0; i < sortedList.size(); ++i) {
            console.print(i + 1 + ": " + Messages.getLocalizedLanguageName(sortedList.get(i), messages));
            if (sortedList.get(i) == systemLanguage) {
                console.print(" [" + messages.getString(".ConsoleEnter") + "]");
                defaultPos = i;
            }
            console.println();
        }
        while (true) {
            try {
                String answer;
                int number;
                do {
                    console.println("[1 - " + sortedList.size() + "]");
                    answer = console.readLine();
                    if (!answer.trim().isEmpty() || defaultPos <= -1) continue;
                    wakeupToken.returnToController(sortedList.get(defaultPos).getId());
                    return;
                } while ((number = Integer.parseInt(answer)) <= 0 || number > sortedList.size());
                wakeupToken.returnToController(sortedList.get(number - 1).getId());
                return;
            }
            catch (NumberFormatException answer) {
                continue;
            }
            catch (UserCanceledException e) {
                try {
                    Thread.sleep(100000000L);
                    continue;
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                    continue;
                }
            }
            break;
        }
    }

    @Override
    public void closeWindows() {
        super.closeWindows();
        ConsoleImpl.getInstance().cleanup();
    }
}

