/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.control;

import com.install4j.api.Util;
import com.install4j.api.context.InstallerContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;

public enum InstallationScope {
    FULL_ADMIN("For all users if full admin rights are available"){

        @Override
        public boolean isInstallForAllUsers(InstallerContext context) {
            return Util.hasFullAdminRights() || HelperCommunication.getInstance().hasElevatedHelper() || HelperCommunication.getInstance().isElevatedHelper();
        }
    }
    ,
    DIRECTORY_WRITABLE("For all users if directory is writable"){

        @Override
        public boolean isInstallForAllUsers(InstallerContext context) {
            return Util.hasAllUserInstallationRights();
        }
    }
    ,
    ACCORDING_TO_VARIABLE("According to the sys.installForAllUsers variable"){

        @Override
        public boolean isInstallForAllUsers(InstallerContext context) {
            return context.getBooleanVariable("sys.installForAllUsers");
        }
    }
    ,
    USER_WRITABLE("User-specific installation directory"){

        @Override
        public boolean isInstallForAllUsers(InstallerContext context) {
            return false;
        }
    }
    ,
    ALL_USERS("Installation directory for all users"){

        @Override
        public boolean isInstallForAllUsers(InstallerContext context) {
            return true;
        }
    };

    private final String verbose;

    private InstallationScope(String verbose) {
        this.verbose = verbose;
    }

    public abstract boolean isInstallForAllUsers(InstallerContext var1);

    public String toString() {
        return this.verbose;
    }
}

