/*
 * Decompiled with CFR 0.152.
 */
package com.exe4j.runtime;

import com.exe4j.Controller;
import com.exe4j.runtime.LauncherEngine;
import com.exe4j.runtime.splash.SplashEngine;
import com.exe4j.runtime.splash.SplashScreenConfig;
import com.exe4j.runtime.splash.TextLineConfig;
import com.exe4j.runtime.util.ArgumentStack;
import com.exe4j.runtime.util.EmptyInputStream;
import com.exe4j.runtime.util.WinDel;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

public class WinLauncher {
    public static final String LEGACY_PROCESS_COMM_FILE_NAME = System.getProperty("exe4j.processCommFile");
    static final boolean APP_MODE_INSTALL4J = Boolean.getBoolean("exe4j.isInstall4j");
    private static final boolean IS_SERVICE = Boolean.getBoolean("exe4j.isService");
    public static final String PROPNAME_LAUNCH_NAME = "exe4j.launchName";
    private static final String PROPNAME_TEMP_DIR = "exe4j.tempDir";
    public static final String PROPNAME_UNEXTRACTED_POSITION = "exe4j.unextractedPosition";
    private static String[] originalArgs;
    private static boolean used;

    public static boolean isService() {
        return IS_SERVICE;
    }

    public static void main(String[] args) {
        used = true;
        if (LEGACY_PROCESS_COMM_FILE_NAME != null) {
            new File(LEGACY_PROCESS_COMM_FILE_NAME).deleteOnExit();
            Controller.registerStartupListener(null);
        }
        WinLauncher.registerCleanup();
        final ConfigArgs configArgs = WinLauncher.getConfigArgs(args);
        originalArgs = configArgs.originalArgs;
        if (IS_SERVICE) {
            Thread thread = new Thread("_shutdown_waiter"){

                @Override
                public void run() {
                    try {
                        InputStream systemIn = System.in;
                        if (!Boolean.getBoolean("install4j.dontReplaceIn")) {
                            System.setIn(new EmptyInputStream());
                        }
                        BufferedReader reader = new BufferedReader(new InputStreamReader(systemIn, "UTF-8"));
                        while (systemIn.available() < 1) {
                            Thread.sleep(200L);
                        }
                        String str = reader.readLine();
                        if (Integer.parseInt(str) == 1) {
                            WinLauncher.exitMessage();
                        }
                        System.exit(0);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.exit(1);
                    }
                }
            };
            thread.setDaemon(true);
            thread.start();
            new Thread("main"){

                @Override
                public void run() {
                    LauncherEngine.launch(configArgs.className, originalArgs, configArgs.stdErrFile, configArgs.stdOutFile, configArgs.failOnMainMethodException, configArgs.guiApplication, ClassLoader.getSystemClassLoader());
                }
            }.start();
        } else {
            LauncherEngine.launch(configArgs.className, originalArgs, configArgs.stdErrFile, configArgs.stdOutFile, configArgs.failOnMainMethodException, configArgs.guiApplication, ClassLoader.getSystemClassLoader());
        }
    }

    public static ConfigArgs getConfigArgs(String[] args) {
        String launchName;
        ArgumentStack argStack = new ArgumentStack(args);
        boolean guiApplication = argStack.popBoolean();
        String className = argStack.popString();
        String stdErrFile = argStack.popString();
        String stdOutFile = argStack.popString();
        boolean failOnMainMethodException = argStack.popBoolean();
        try {
            launchName = argStack.popString();
            System.setProperty(PROPNAME_LAUNCH_NAME, launchName);
        }
        catch (NoSuchElementException ex) {
            launchName = null;
        }
        return new ConfigArgs(argStack.getStringArray(), guiApplication, className, stdErrFile, stdOutFile, failOnMainMethodException, launchName);
    }

    private static void registerCleanup() {
        final String tempDir = System.getProperty(PROPNAME_TEMP_DIR);
        Integer unextractedPos = Integer.getInteger(PROPNAME_UNEXTRACTED_POSITION);
        if (!(tempDir == null || tempDir.trim().isEmpty() || unextractedPos != null && unextractedPos == -1)) {
            WinDel.setUsed(true);
            Runtime.getRuntime().addShutdownHook(new Thread("temp_deletion_starter"){

                @Override
                public void run() {
                    try {
                        ArrayList<File> dirs = new ArrayList<File>();
                        ArrayList<File> files = new ArrayList<File>();
                        File tempDirFile = new File(tempDir);
                        WinLauncher.fill(dirs, files, tempDirFile);
                        WinDel.prepareDeletion(new File(tempDir, "i4jdel.exe"));
                        String tempFileName = tempDirFile.getName();
                        int dirMarkerPos = tempFileName.lastIndexOf("_dir");
                        if (dirMarkerPos > 0) {
                            tempFileName = tempFileName.substring(0, dirMarkerPos);
                        }
                        files.add(new File(tempDirFile.getParent(), tempFileName));
                        WinDel.scheduleDeletion(files, dirs, false);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
        }
    }

    public static String[] appendOriginalArgs(String[] params) {
        String[] ret = new String[params.length + originalArgs.length];
        System.arraycopy(params, 0, ret, 0, params.length);
        System.arraycopy(originalArgs, 0, ret, params.length, originalArgs.length);
        return ret;
    }

    static boolean isUsed() {
        return used;
    }

    private static void fill(List<File> dirs, List<File> files, File dir) {
        File[] newFiles = dir.listFiles();
        if (newFiles != null) {
            for (File newFile : newFiles) {
                if (newFile.isDirectory()) {
                    WinLauncher.fill(dirs, files, newFile);
                    continue;
                }
                files.add(newFile);
            }
            dirs.add(dir);
        }
    }

    public static void exitMessage() {
        System.err.println("*******************************************************************");
        System.err.println("This is an evaluation version of exe4j. The service is terminated");
        System.err.println("after 120 minutes. A licensed version of exe4j will create services");
        System.err.println("without this restriction.");
        System.err.println("*******************************************************************");
    }

    static void initAwtSplashConfig(boolean eval, boolean textOverlay, String status, int statusX, int statusY, String statusColor, int statusSize, int statusWeight, String version, int versionX, int versionY, String versionColor, int versionSize, int versionWeight) {
        try {
            SplashScreenConfig splashScreenConfig = new SplashScreenConfig();
            splashScreenConfig.init(textOverlay, new TextLineConfig(status, statusX, statusY, statusColor, statusSize, statusWeight), new TextLineConfig(version, versionX, versionY, versionColor, versionSize, versionWeight));
            SplashEngine.setJavaSplashScreenConfig(true, splashScreenConfig);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static {
        used = false;
    }

    public static class ConfigArgs {
        public final String[] originalArgs;
        public final boolean guiApplication;
        public final String className;
        public final String stdErrFile;
        public final String stdOutFile;
        public final boolean failOnMainMethodException;
        public final String launchName;

        public ConfigArgs(String[] originalArgs, boolean guiApplication, String className, String stdErrFile, String stdOutFile, boolean failOnMainMethodException, String launchName) {
            this.originalArgs = originalArgs;
            this.guiApplication = guiApplication;
            this.className = className;
            this.stdErrFile = stdErrFile;
            this.stdOutFile = stdOutFile;
            this.failOnMainMethodException = failOnMainMethodException;
            this.launchName = launchName;
        }
    }
}

