/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.buildtools;

import com.install4j.buildtools.shadowed.apache.archivers.tar.TarArchiveEntry;
import com.install4j.buildtools.shadowed.apache.archivers.tar.TarArchiveInputStream;
import com.install4j.buildtools.shadowed.ejt.io.CommonFileUtil;
import com.install4j.buildtools.shadowed.ejt.io.DirectoryLocker;
import com.install4j.buildtools.shadowed.ejt.util.CommonPlatformUtil;
import com.install4j.buildtools.shadowed.ejt.util.CommonStringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jetbrains.annotations.NotNull;

public abstract class InstallationProvisioner {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File provision() {
        Class<VirtualMachineError> clazz = VirtualMachineError.class;
        synchronized (VirtualMachineError.class) {
            File cacheDirectory = this.getCacheDirectory();
            if (!cacheDirectory.exists()) {
                cacheDirectory.mkdirs();
            }
            String install4jVersion = this.getInstall4jVersion();
            MediaSpec mediaSpec = this.getInstall4JMediaSpec(install4jVersion.replace('.', '_'));
            File install4jDir = cacheDirectory.toPath().resolve(install4jVersion).toFile();
            File completionMarkerFile = new File(install4jDir, "__complete");
            if (!completionMarkerFile.exists()) {
                DirectoryLocker.withLock(install4jDir, "Locking auto-provisioning directory ...", this::log, () -> {
                    this.downloadInstall4j(install4jDir, completionMarkerFile, install4jVersion, mediaSpec);
                    return null;
                });
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return install4jDir;
        }
    }

    private void downloadInstall4j(File install4jDir, File completionMarkerFile, String install4jVersion, MediaSpec mediaSpec) {
        File[] files = install4jDir.listFiles((dir, name) -> !name.equals(".lock"));
        if (files != null && files.length > 0 && !completionMarkerFile.exists()) {
            throw new RuntimeException("The auto-provisioned install4j distribution in " + install4jDir + " is corrupt. Please delete that directory and try again.");
        }
        File archiveFile = this.downloadMediaFile(install4jVersion, mediaSpec);
        this.extractMediaFile(archiveFile, mediaSpec, install4jDir);
        archiveFile.delete();
        try {
            completionMarkerFile.createNewFile();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create completion marker file " + completionMarkerFile, e);
        }
    }

    protected abstract File getCacheDirectory();

    protected abstract void log(String var1);

    protected abstract void logVerbose(String var1);

    @NotNull
    private String getInstall4jVersion() {
        try {
            File root = new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI());
            String customPropertiesPath = "META-INF/custom.properties";
            String version = this.readCustomProperties(root, customPropertiesPath).stream().filter(line -> line.startsWith("version=")).map(line -> line.substring("version=".length())).findFirst().orElseThrow(() -> new RuntimeException("The custom properties file does not contain a version"));
            return System.getProperty("install4j.autoProvisionVersion", version);
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException("An error occurred while retrieving the install4j version", e);
        }
    }

    @NotNull
    private List<String> readCustomProperties(File root, String customPropertiesPath) throws IOException {
        if (root.isDirectory()) {
            File file = root.toPath().resolve("../../../resources/main/" + customPropertiesPath).toFile();
            if (file.exists()) {
                return new BufferedReader(new FileReader(file)).lines().collect(Collectors.toList());
            }
            throw new RuntimeException("The custom properties file " + file + " does not exist");
        }
        Throwable throwable = null;
        try (JarFile jarFile = new JarFile(root);){
            JarEntry jarEntry = jarFile.getJarEntry(customPropertiesPath);
            if (jarEntry != null) {
                List<String> list = new BufferedReader(new InputStreamReader(jarFile.getInputStream(jarEntry))).lines().collect(Collectors.toList());
                return list;
            }
            try {
                throw new RuntimeException("The JAR entry " + customPropertiesPath + " does not exist in the plugin JAR file");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    @NotNull
    private MediaSpec getInstall4JMediaSpec(String install4jVersion) {
        if (CommonPlatformUtil.isWindows()) {
            return new MediaSpec("install4j_windows-x64_" + install4jVersion + ".zip", MediaType.ZIP);
        }
        if (CommonPlatformUtil.isMacOS()) {
            return new MediaSpec("install4j_macos_" + install4jVersion + ".tgz", MediaType.TGZ);
        }
        if (CommonPlatformUtil.isLinuxX64()) {
            return new MediaSpec("install4j_linux-x64_" + install4jVersion + ".tar.gz", MediaType.TGZ);
        }
        return new MediaSpec("install4j_unix_" + install4jVersion + ".tar.gz", MediaType.TGZ);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private File downloadMediaFile(String install4jVersion, MediaSpec mediaSpec) {
        this.log("Downloading install4j " + install4jVersion);
        String downloadUrl = "https://download.ej-technologies.com/install4j/" + mediaSpec.mediaName;
        this.logVerbose("Download URL is " + downloadUrl);
        try {
            HttpURLConnection connection = this.createConnection(downloadUrl);
            File archiveFile = File.createTempFile(mediaSpec.mediaName, "");
            this.logVerbose("Target file is " + archiveFile);
            try (InputStream inputStream = connection.getInputStream();){
                CommonFileUtil.copyStream(inputStream, archiveFile);
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                connection.disconnect();
            }
            return archiveFile;
        }
        catch (IOException e) {
            throw new RuntimeException("Error during provisioning", e);
        }
    }

    private HttpURLConnection createConnection(String downloadUrl) throws IOException {
        URL url = URI.create(downloadUrl).toURL();
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.connect();
        int statusCode = connection.getResponseCode();
        if (statusCode != 200) {
            throw new RuntimeException("Error downloading " + downloadUrl + ": " + statusCode + " " + connection.getResponseMessage());
        }
        return connection;
    }

    private void extractMediaFile(@NotNull File archiveFile, MediaSpec mediaSpec, File install4jDir) {
        this.logVerbose("Extracting install4j to " + install4jDir);
        CommonFileUtil.deleteDirectory(install4jDir);
        install4jDir.mkdirs();
        try {
            switch (mediaSpec.type) {
                case ZIP: {
                    this.extractZipFile(archiveFile, install4jDir);
                    break;
                }
                case TGZ: {
                    this.extractTarFile(archiveFile, install4jDir);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported media type " + (Object)((Object)mediaSpec.type));
                }
            }
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException("An error occurred while extracting the install4j media file", e);
        }
    }

    public void extractZipFile(File archiveFile, File dir) throws InterruptedException, IOException {
        dir = dir.getCanonicalFile();
        try (ZipInputStream zipIn = new ZipInputStream(new FileInputStream(archiveFile));){
            ZipEntry entry = zipIn.getNextEntry();
            while (entry != null) {
                File file = new File(dir, this.dropTopLevelDir(entry.getName())).getCanonicalFile();
                if (file.getPath().startsWith(dir.getPath() + File.separator)) {
                    if (!entry.isDirectory()) {
                        CommonFileUtil.copyStream(zipIn, file, null, 0L, false);
                    } else {
                        file.mkdirs();
                    }
                    FileTime lastModifiedTime = entry.getLastModifiedTime();
                    if (lastModifiedTime != null) {
                        file.setLastModified(lastModifiedTime.toMillis());
                    }
                }
                zipIn.closeEntry();
                entry = zipIn.getNextEntry();
            }
        }
    }

    public void extractTarFile(File archiveFile, File dir) throws InterruptedException, IOException {
        dir = dir.getCanonicalFile();
        try (TarArchiveInputStream tarIn = new TarArchiveInputStream(new GZIPInputStream(new FileInputStream(archiveFile)));){
            TarArchiveEntry entry = tarIn.getNextEntry();
            while (entry != null) {
                File file = new File(dir, this.dropTopLevelDir(entry.getName())).getCanonicalFile();
                if (file.getPath().startsWith(dir.getPath() + File.separator)) {
                    if (!entry.isDirectory()) {
                        CommonFileUtil.copyStream(tarIn, file, null, 0L, false);
                    } else {
                        file.mkdirs();
                    }
                    file.setLastModified(entry.getModTime().getTime());
                    if (!CommonPlatformUtil.isWindows()) {
                        String mode = CommonStringUtil.toJavaTypeMode(entry.getMode());
                        Files.setPosixFilePermissions(file.toPath(), PosixFilePermissions.fromString(mode));
                    }
                }
                entry = tarIn.getNextEntry();
            }
        }
    }

    private String dropTopLevelDir(String name) {
        return name.substring(name.indexOf(47) + 1);
    }

    private static class MediaSpec {
        public final String mediaName;
        public final MediaType type;

        public MediaSpec(String mediaName, MediaType type) {
            this.mediaName = mediaName;
            this.type = type;
        }
    }

    private static enum MediaType {
        ZIP,
        TGZ;

    }
}

